/* X509_f2i.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "der.h"
#include "bn.h"
#include "X509.h"
#include "Buffer.h"

static int Fgets();
static int f2i_get_token();

static int f2i_line_no=0;

int f2i_X509_ALGOR(fp,a,size,buf)
FILE *fp;
X509_ALGOR *a;
int size;
char *buf;
	{
	if (f2i_get_token(fp,size,buf) != TOKEN_ALGORITHMIDENTIFIER_BEGIN)
		{
		DER_errno=DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_X509_ALGOR;
		return(0);
		}
	if (!f2i_DER_OBJECT(fp,a->algorithm,size,buf)) return(0);
	if (!f2i_DER_BIT_STRING(fp,a->parameters,size,buf)) return(0);
	if (f2i_get_token(fp,size,buf) != TOKEN_ALGORITHMIDENTIFIER_END)
		{
		DER_errno=DER_ERR_EXPECTING_END_TOKEN_IN_F2I_X509_ALGOR;
		return(0);
		}
	return(1);
	}

int f2i_X509_NAME(fp,a,size,buf)
FILE *fp;
X509_NAME *a;
int size;
char *buf;
	{
	int i=0,j;
	DER_OBJECT **objs,*obj;
	DER_BIT_STRING *bs,**vals;
	int *types;
	unsigned char *s;
	int n=0;

	if (f2i_get_token(fp,size,buf) != TOKEN_NAME_BEGIN)
		{
		DER_errno=DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_X509_NAME;
		return(0);
		}
	objs=a->objects;
	types=a->types;
	vals=a->values;
	n=a->num;
	for (;;)
		{
		if (i >= n)
			{
			n+=10;
			if (objs == NULL)
				{
				objs=(DER_OBJECT **)malloc(
					sizeof(DER_OBJECT *)*n);
				types=(int *)malloc(sizeof(int *)*n);
				vals=(DER_BIT_STRING **)malloc(
					sizeof(DER_BIT_STRING *)*n);
				}
			else	
				{
				objs=(DER_OBJECT **)realloc(objs,
					sizeof(DER_OBJECT *)*n);
				types=(int *)realloc(types,sizeof(int *)*n);
				vals=(DER_BIT_STRING **)realloc(vals,
					sizeof(DER_BIT_STRING *)*n);
				}
			if ((objs == NULL) || (vals == NULL) || (types == NULL))
				{ DER_errno=DER_ERR_OUT_OF_MEM; return(0); }
			for (j=i; j<n; j++)
				{
				objs[j]=NULL;
				types[j]=0;
				vals[j]=DER_BIT_STRING_new();
				if (vals[j] == NULL) return(0);
				}
			a->objects=objs;
			a->types=types;
			a->values=vals;
			}
		obj=a->objects[i];
		if (obj == NULL)
			{
			obj=(DER_OBJECT *)DER_OBJECT_new();
			if (obj == NULL)
				{
				DER_errno=DER_ERR_OUT_OF_MEM;
				return(0);
				}
			}
		if (!f2i_DER_OBJECT(fp,obj,size,buf))
			return(0);
		a->objects[i]=obj;

/* EAY FIX - change to print any type */
		if (!f2i_PRINTABLESTRING(fp,&s,size,buf)) return(0);
		a->values[i]->length=strlen(s);
		a->types[i]=DER_PRINTABLESTRING;
		a->values[i]->data=s;
		a->num++;
		i++;
		if (buf[0] == '-') break;
		}
	if (f2i_get_token(fp,size,buf) != TOKEN_NAME_END)
		{
		DER_errno=DER_ERR_EXPECTING_END_TOKEN_IN_F2I_X509_NAME;
		return(0);
		}
	return(1);
	}

int f2i_X509_VAL(fp,a,size,buf)
FILE *fp;
X509_VAL *a;
int size;
char *buf;
	{
	if (f2i_get_token(fp,size,buf) != TOKEN_VALIDITY_BEGIN)
		{
		DER_errno=DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_X509_VAL;
		return(0);
		}
	if (!f2i_UTCTime(fp,&a->notBefore,size,buf)) return(0);
	if (!f2i_UTCTime(fp,&a->notAfter,size,buf)) return(0);
	if (f2i_get_token(fp,size,buf) != TOKEN_VALIDITY_END)
		{
		DER_errno=DER_ERR_EXPECTING_END_TOKEN_IN_F2I_X509_VAL;
		return(0);
		}
	return(1);
	}

int f2i_X509_PUBKEY(fp,a,size,buf)
FILE *fp;
X509_PUBKEY *a;
int size;
char *buf;
	{
	if (f2i_get_token(fp,size,buf) != TOKEN_SUBJECTPUBLICKEYINFO_BEGIN)
		{
		DER_errno=DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_X509_PUBKEY;
		return(0);
		}
	if (!f2i_X509_ALGOR(fp,a->algor,size,buf)) return(0);
	if (!f2i_DER_BIT_STRING(fp,a->public_key,size,buf)) return(0);
	if (f2i_get_token(fp,size,buf) != TOKEN_SUBJECTPUBLICKEYINFO_END)
		{
		DER_errno=DER_ERR_EXPECTING_END_TOKEN_IN_F2I_X509_PUBKEY;
		return(0);
		}
	return(1);
	}

int f2i_X509_CINF(fp,a,size,buf)
FILE *fp;
X509_CINF *a;
int size;
char *buf;
	{
	if (f2i_get_token(fp,size,buf) != TOKEN_CERTIFICATE_BEGIN)
		{
		DER_errno=DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_X509_PUBKEY;
		return(0);
		}
/*	fprintf(fp,"= %ld\n",a->version);/**/
	if (!f2i_DER_BIT_STRING(fp,a->serialNumber,size,buf)) return(0);
	if (!f2i_X509_ALGOR(fp,a->signature,size,buf)) return(0);
	if (!f2i_X509_NAME(fp,a->issuer,size,buf)) return(0);
	if (!f2i_X509_VAL(fp,a->validity,size,buf)) return(0);
	if (!f2i_X509_NAME(fp,a->subject,size,buf)) return(0);
	if (!f2i_X509_PUBKEY(fp,a->key,size,buf)) return(0);
	if (f2i_get_token(fp,size,buf) != TOKEN_CERTIFICATE_END)
		{
		DER_errno=DER_ERR_EXPECTING_END_TOKEN_IN_F2I_X509_PUBKEY;
		return(0);
		}
	return(1);
	}

int f2i_X509(fp,a)
FILE *fp;
X509 *a;
	{
	BUFFER *b;

	b=buffer_new();
	if ((b == NULL) || !buffer_grow(b,1024*4))
		{
		DER_errno=DER_ERR_OUT_OF_MEM;
		return(0);
		}

	f2i_line_no=0;
	if (f2i_get_token(fp,b->length,b->data) != TOKEN_X509_CERTIFICATE_BEGIN)
		{
		DER_errno=DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_X509;
		return(0);
		}
	if (!f2i_X509_CINF(fp,a->cert_info,b->length,b->data)) return(0);
	if (!f2i_X509_ALGOR(fp,a->sig_alg,b->length,b->data)) return(0);
	if (!f2i_DER_BIT_STRING(fp,a->signature,b->length,b->data)) return(0);
	if (f2i_get_token(fp,b->length,b->data) != TOKEN_X509_CERTIFICATE_END)
		{
		DER_errno=DER_ERR_EXPECTING_END_TOKEN_IN_F2I_X509;
		return(0);
		}
	return(1);
	}

static int f2i_get_token(fp,size,buf)
FILE *fp;
int size;
char *buf;
	{
	int len;

	if ((len=Fgets(buf,size,fp)) == 0) return(TOKEN_ERROR);
	buf[len-1]='\0';
	/* shoud do this with a hash table to make it fast */
	if (strcmp(buf,STRING_X509_CERTIFICATE_BEGIN) == 0)
		return(TOKEN_X509_CERTIFICATE_BEGIN);
	if (strcmp(buf,STRING_X509_CERTIFICATE_END) == 0)
		return(TOKEN_X509_CERTIFICATE_END);
	if (strcmp(buf,STRING_CERTIFICATE_BEGIN) == 0)
		return(TOKEN_CERTIFICATE_BEGIN);
	if (strcmp(buf,STRING_CERTIFICATE_END) == 0)
		return(TOKEN_CERTIFICATE_END);
	if (strcmp(buf,STRING_ALGORITHMIDENTIFIER_BEGIN) == 0)
		return(TOKEN_ALGORITHMIDENTIFIER_BEGIN);
	if (strcmp(buf,STRING_ALGORITHMIDENTIFIER_END) == 0)
		return(TOKEN_ALGORITHMIDENTIFIER_END);
	if (strcmp(buf,STRING_NAME_BEGIN) == 0)
		return(TOKEN_NAME_BEGIN);
	if (strcmp(buf,STRING_NAME_END) == 0)
		return(TOKEN_NAME_END);
	if (strcmp(buf,STRING_VALIDITY_BEGIN) == 0)
		return(TOKEN_VALIDITY_BEGIN);
	if (strcmp(buf,STRING_VALIDITY_END) == 0)
		return(TOKEN_VALIDITY_END);
	if (strcmp(buf,STRING_SUBJECTPUBLICKEYINFO_BEGIN) == 0)
		return(TOKEN_SUBJECTPUBLICKEYINFO_BEGIN);
	if (strcmp(buf,STRING_SUBJECTPUBLICKEYINFO_END) == 0)
		return(TOKEN_SUBJECTPUBLICKEYINFO_END);
	if (strcmp(buf,STRING_RSAPUBLICKEY_BEGIN) == 0)
		return(TOKEN_RSAPUBLICKEY_BEGIN);
	if (strcmp(buf,STRING_RSAPUBLICKEY_END) == 0)
		return(TOKEN_RSAPUBLICKEY_END);
	if (strcmp(buf,STRING_RSAPRIVATEKEY_BEGIN) == 0)
		return(TOKEN_RSAPRIVATEKEY_BEGIN);
	if (strcmp(buf,STRING_RSAPRIVATEKEY_END) == 0)
		return(TOKEN_RSAPRIVATEKEY_END);
	return(TOKEN_ERROR);
	}

int f2i_error_line()
	{
	return(f2i_line_no);
	}

static int Fgets(buf,size,fp)
char *buf;
int size;
FILE *fp;
	{
	int ret;

	f2i_line_no++;
	buf[0]='\0';
	fgets(buf,size,fp);
	if (buf[0] == '\0') return(0);
	ret=strlen(buf);
	return(ret);
	}

int f2i_PRINTABLESTRING(fp,s,size,buf)
FILE *fp;
unsigned char **s;
int size;
char *buf;
	{
	int i;

	size=Fgets(buf,size,fp);
	if (size < 3)
		{
		DER_errno=DER_ERR_SHORT_LINE_IN_F2I_PRINTABLESTRING;
		return(0);
		}
	if (	!((buf[0] == '=') || (buf[0] == '-')) ||
		(buf[1] != ' '))
		{
		DER_errno=DER_ERR_BAD_SOL_CHARACTER;
		return(0);
		}
	i=strlen(buf);
	if (buf[i-1] != '\n')
		{
		DER_errno=DER_ERR_BAD_EOL_CHARACTER;
		return(0);
		}
	buf[i-1]='\0';
	buf+=2;
	i-=3;
	*s=(unsigned char *)malloc(i+1);
	if (*s == NULL)
		{
		DER_errno=DER_ERR_OUT_OF_MEM;
		return(0);
		}
	strcpy(*s,buf);
	return(1);
	}

int f2i_DER_BIT_STRING(fp,bs,size,buf)
FILE *fp;
DER_BIT_STRING *bs;
int size;
char *buf;
	{
	int i,j,k,m,n,again,bufsize;
	unsigned char *s=NULL;
	int num=0,slen=0;

	bufsize=Fgets(buf,size,fp);
	if ((bufsize > 6) && (strncmp("= NULL",buf,6) == 0))
			return(1); /* null entry */
	
	for (;;)
		{
		if (bufsize < 4) return(0);
		if (!((buf[0] == '=') || (buf[0] == '-')) ||
			(buf[1] != ' '))
			{
			DER_errno=DER_ERR_BAD_SOL_CHARACTER;
			return(0);
			}
		i=strlen(buf);
		if (buf[i-1] != '\n')
			{
			DER_errno=DER_ERR_BAD_EOL_CHARACTER;
			return(0);
			}
		buf[i-1]='\0';
		again=(buf[0] == '=');
		k=2;
		i-=3;
		if (i%2 != 0)
			{
			DER_errno=DER_ERR_ODD_NUMBER_OF_CHARS_ON_LINE;
			return(0);
			}
		i/=2;
		if (num+i > slen)
			{
			if (s == NULL)
				s=(unsigned char *)malloc(num+i*2);
			else
				s=(unsigned char *)realloc(s,num+i*2);
			if (s == NULL)
				{
				DER_errno=DER_ERR_OUT_OF_MEM;
				return(0);
				}
			slen=num+i*2;
			}
		for (j=0; j<i; j++,k+=2)
			{
			for (n=0; n<2; n++)
				{
				m=buf[k+n];
				if ((m >= '0') && (m <= '9'))
					m-='0';
				else if ((m >= 'a') && (m <= 'f'))
					m=m-'a'+10;
				else if ((m >= 'A') && (m <= 'F'))
					m=m-'A'+10;
				else
					{
					DER_errno=DER_ERR_NON_HEX_CHARACTERS;
					return(0);
					}
				s[num+j]<<=4;
				s[num+j]|=m;
				}
			}
		num+=i;
		if (again)
			bufsize=Fgets(buf,size,fp);
		else
			break;
		}
	bs->length=num;
	bs->data=s;
	return(1);
	}

int f2i_UTCTime(fp,s,size,buf)
FILE *fp;
unsigned char **s;
int size;
char *buf;
	{
	return(f2i_PRINTABLESTRING(fp,s,size,buf));
	}

int f2i_DER_OBJECT(fp,o,size,buf)
FILE *fp;
DER_OBJECT *o;
int size;
char *buf;
	{
	int i,ok,j,num=0;
	char *b;
	unsigned long l;

	size=Fgets(buf,size,fp);
	if (size < 3)
		{
		DER_errno=DER_ERR_SHORT_LINE_IN_F2I_DER_OBJECT;
		return(0);
		}
	if (	!((buf[0] == '=') || (buf[0] == '-')) ||
		(buf[1] != ' '))
		{
		DER_errno=DER_ERR_BAD_SOL_CHARACTER;
		return(0);
		}
	i=strlen(buf);
	if (buf[i-1] != '\n')
		{
		DER_errno=DER_ERR_BAD_EOL_CHARACTER;
		return(0);
		}
	buf[i-1]='\0';
	buf+=2;
	i-=3;
	b=buf;
	for (j=0; j<i; j++)
		{
		/* skip white space */
		while (*b == ' ') b++;
		/* a number? */
		if ((*b >= '0') && (*b <= '9')) num++;
		/* skip number */
		while ((*b >= '0') && (*b <= '9')) b++;
		}
	if (o->num < num)
		{
		if (o->values != NULL) free(o->values);
		o->values=(unsigned long *)malloc(sizeof(unsigned long)*num);
		if (o->values == NULL)
			{
			DER_errno=DER_ERR_OUT_OF_MEM;
			return(0);
			}
		}
	o->num=num;

	b=buf;
	num=0;
	for (j=0; j<i; j++)
		{
		l=0;
		ok=0;
		while (*b == ' ') b++;
		while ((*b >= '0') && (*b <= '9'))
			{
			l=l*10+(*b-'0');
			ok++;
			b++;
			}
		if (ok)
			{
			o->values[num]=l;
			num++;
			}
		}
	return(1);
	}

int f2i_RSAPrivateKey(fp,rsa)
FILE *fp;
RSA *rsa;
	{
	DER_BIT_STRING bs1,bs2;
	BUFFER *buf;
	int btos;

	btos=buffer_get_tos();
	buf=buffer_get_buf();
	if (buf == NULL)
		{ DER_errno=DER_ERR_OUT_OF_MEM; return(0); }

	if (!buffer_grow(buf,1024*4))
		{ DER_errno=DER_ERR_OUT_OF_MEM; return(0); }
	f2i_line_no=0;
	bs1.length=0; bs1.data=NULL;
	bs2.length=0; bs2.data=NULL;
	if (f2i_get_token(fp,buf->length,buf->data) != TOKEN_RSAPRIVATEKEY_BEGIN)
		{
		DER_errno=DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_RSAPRIVATEKEY;
		goto err;
		}
	/* read and throw away version number */
	if (!f2i_DER_BIT_STRING(fp,&bs1,buf->length,buf->data)) goto err;
	rsa->n=bn_bin2bn(bs1.length,bs1.data,rsa->n);
	if (rsa->n == NULL) { DER_errno=DER_ERR_RSA; goto err; }

	if (!f2i_DER_BIT_STRING(fp,&bs1,buf->length,buf->data)) goto err;
	rsa->n=bn_bin2bn(bs1.length,bs1.data,rsa->n);
	if (rsa->n == NULL) { DER_errno=DER_ERR_RSA; goto err; }

	if (!f2i_DER_BIT_STRING(fp,&bs2,buf->length,buf->data)) goto err;
	rsa->e=bn_bin2bn(bs2.length,bs2.data,rsa->e);
	if (rsa->e == NULL) { DER_errno=DER_ERR_RSA; goto err; }

	if (!f2i_DER_BIT_STRING(fp,&bs1,buf->length,buf->data)) goto err;
	rsa->d=bn_bin2bn(bs1.length,bs1.data,rsa->d);
	if (rsa->d == NULL) { DER_errno=DER_ERR_RSA; goto err; }

	if (!f2i_DER_BIT_STRING(fp,&bs1,buf->length,buf->data)) goto err;
	rsa->p=bn_bin2bn(bs1.length,bs1.data,rsa->p);
	if (rsa->p == NULL) { DER_errno=DER_ERR_RSA; goto err; }

	if (!f2i_DER_BIT_STRING(fp,&bs1,buf->length,buf->data)) goto err;
	rsa->q=bn_bin2bn(bs1.length,bs1.data,rsa->q);
	if (rsa->q == NULL) { DER_errno=DER_ERR_RSA; goto err; }

	if (!f2i_DER_BIT_STRING(fp,&bs1,buf->length,buf->data)) goto err;
	rsa->dmp1=bn_bin2bn(bs1.length,bs1.data,rsa->dmp1);
	if (rsa->dmp1 == NULL) { DER_errno=DER_ERR_RSA; goto err; }

	if (!f2i_DER_BIT_STRING(fp,&bs1,buf->length,buf->data)) goto err;
	rsa->dmq1=bn_bin2bn(bs1.length,bs1.data,rsa->dmq1);
	if (rsa->dmq1 == NULL) { DER_errno=DER_ERR_RSA; goto err; }

	if (!f2i_DER_BIT_STRING(fp,&bs1,buf->length,buf->data)) goto err;
	rsa->iqmp=bn_bin2bn(bs1.length,bs1.data,rsa->iqmp);
	if (rsa->iqmp == NULL) { DER_errno=DER_ERR_RSA; goto err; }

	free(bs1.data);
	free(bs2.data);
	if (f2i_get_token(fp,buf->length,buf->data) != TOKEN_RSAPRIVATEKEY_END)
		{
		DER_errno=DER_ERR_EXPECTING_END_TOKEN_IN_F2I_RSAPRIVATEKEY;
		goto err;
		}
	buffer_set_tos(btos);
	return(1);
err:
	buffer_set_tos(btos);
	return(0);
	}

int f2i_RSAPublicKey(fp,rsa,size,buf)
FILE *fp;
RSA *rsa;
int size;
char *buf;
	{
	DER_BIT_STRING bs1;

	f2i_line_no=0;
	bs1.length=0; bs1.data=NULL;
	if (f2i_get_token(fp,size,buf) != TOKEN_RSAPUBLICKEY_BEGIN)
		{
		DER_errno=DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_RSAPUBLICKEY;
		return(0);
		}
	if (!f2i_DER_BIT_STRING(fp,&bs1,size,buf)) return(0);
	rsa->n=bn_bin2bn(bs1.length,bs1.data,rsa->n);
	if (rsa->n == NULL) { DER_errno=DER_ERR_RSA; return(0); }

	if (!f2i_DER_BIT_STRING(fp,&bs1,size,buf)) return(0);
	rsa->e=bn_bin2bn(bs1.length,bs1.data,rsa->e);
	if (rsa->e == NULL) { DER_errno=DER_ERR_RSA; return(0); }

	free(bs1.data);
	if (f2i_get_token(fp,size,buf) != TOKEN_RSAPUBLICKEY_END)
		{
		DER_errno=DER_ERR_EXPECTING_END_TOKEN_IN_F2I_RSAPUBLICKEY;
		return(0);
		}
	if (rsa->d != NULL) bn_free(rsa->d);
	if (rsa->p != NULL) bn_free(rsa->d);
	if (rsa->q != NULL) bn_free(rsa->d);
	if (rsa->dmp1 != NULL) bn_free(rsa->d);
	if (rsa->dmq1 != NULL) bn_free(rsa->d);
	if (rsa->iqmp != NULL) bn_free(rsa->d);
	return(1);
	}
