/*
 * Copyright (c) 1989 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 */


/*
 * Copyright (c) 2000 Qualcomm Incorporated.  All rights reserved.
 * The file License.txt specifies the terms for use, modification,
 * and redistribution.
 *
 * Revisions:
 *     03/14/00  [rcg]
 *              - Minor syntactical tweaks.
 *
 *     03/06/00  [rcg]
 *              - Renamed authenticate to kerb_authenticate because of
 *                name conflict on AIX (thanks to Nik Conwell).
 */


#include <config.h>

#include <errno.h>
#include <stdio.h>
#include <sys/types.h>

#if HAVE_SYS_NETINET_IN_H
#  include <sys/netinet/in.h>
#endif

#if HAVE_NETINET_IN_H
#  include <netinet/in.h>
#endif

#include <netdb.h>
#include <arpa/inet.h>
#include <string.h>

#if HAVE_SYS_PARAM_H
#  include <sys/param.h>
#endif

#if HAVE_STRINGS_H
#  include <strings.h>
#endif

#ifndef HAVE_INDEX
#  define index(s,c) strchr(s,c)
#  define rindex(s,c) strrchr(s,c)
#endif /* HAVE_INDEX */

#ifndef HAVE_BCOPY
#  define bcopy(src,dest,len)   (void) (memcpy(dest, src, len))
#  define bzero(dest,len)       (void) (memset(dest, (char)NULL, len))
#  define bcmp(b1,b2,n)         memcmp(b1,b2,n)
#endif /* HAVE_BCOPY */

#include "get_sub_opt.h"
#include "popper.h"

/* CNS Kerberos IV */
#ifdef KERBEROS
  AUTH_DAT kdata;
#endif

/* Some systems define (in netdb.h) h_errno as get_h_errno() */
#ifndef h_errno
  extern int      h_errno; /* Error external for gethostxxxx library */
#endif

/* Method to get friendly string from h_errno */
#ifndef HAVE_HSTRERROR
  const char * _HERRORS[] = 
      {"(No problem)",                                          /*  0  NETDB_SUCCESS  */
       "Authoritive answer: Host not found",                    /*  1  HOST_NOT_FOUND */
       "Non-Authoritive answer: Host not found, or SERVERFAIL", /*  2  TRY_AGAIN      */
       "Non recoverable errors, FORMERR, REFUSED, NOTIMP",      /*  3  NO_RECOVERY    */
       "Valid name, no data record of requested type",          /*  4  NO_DATA        */
       "(Unknown)"};
#  define hstrerror(x) ( (x >= 0 && x <= NO_DATA) ? _HERRORS[x] : "(unknown)" )
#endif /* HAVE_HSTRERROR */

extern int      errno;
extern int login_delay;
extern int expire;

/*
#ifdef POPSCO
  extern struct state   _res;
#endif
*/


#ifndef HAVE_STRDUP
#  include <stddef.h>
#  include <stdlib.h>

char *
strdup(str)
        char *str;
{
    int len;
    char *copy;

    len = strlen(str) + 1;
    if (!(copy = malloc((u_int)len)))
        return((char *)NULL);
    bcopy(str, copy, len);
    return(copy);
}
#endif /* not HAVE_STRDUP */

kerb_authenticate(p, addr)
     POP     *p;
     struct sockaddr_in *addr;
{

#ifdef KERBEROS
    Key_schedule schedule;
    KTEXT_ST ticket;
    char instance[INST_SZ];  
    char version[9];
    int auth;
  
    if ( p->kerberos ) {
        strcpy ( instance, "*" );
        auth = krb_recvauth ( 0L, 0, &ticket, KERBEROS_SERVICE, instance,
                              addr, (struct sockaddr_in *) NULL,
                              &kdata, "", schedule, version );
        
        if ( auth != KSUCCESS ) {
            pop_msg ( p, POP_FAILURE, HERE, "Kerberos authentication failure: %s", 
                      krb_err_txt[auth] );
            pop_log ( p, POP_WARNING, HERE, "%s: (%s.%s@%s) %s", 
                      p->client, 
                      kdata.pname, kdata.pinst, kdata.prealm, 
                      krb_err_txt[auth] );

            return ( POP_FAILURE );
        }

        DEBUG_LOG4 ( p, "%s.%s@%s (%s): ok", kdata.pname, 
                     kdata.pinst, kdata.prealm, inet_ntoa(addr->sin_addr) );

        strncpy ( p->user, kdata.pname, sizeof(p->user) );
        p->AuthType = kerberos;

    }
#endif /* KERBEROS */

    return ( POP_SUCCESS );
}

/* 
 *  init:   Start a Post Office Protocol session
 */

pop_init(p, argcount, argmessage)
POP     *       p;
int             argcount;
char    **      argmessage;
{

    struct sockaddr_in      cs;                 /*  Communication parameters */
    struct hostent      *   ch;                 /*  Client host information */
    int                     errflag = 0;
    int                     c;
    int                     len;
    extern char         *   optarg;
    int                     options = 0;
    int                     sp = 0;             /*  Socket pointer */
    int                     no_rev_lookup;      /*  avoid reverse lookup? */
    char                *   trace_file_name;
    struct hostent      *   hp = NULL;


#if DISABLE_CANNONICAL_LOOKUP
    no_rev_lookup = 1;
#else
    no_rev_lookup = 0;
#endif

    /*  
     * Initialize the POP parameter block 
     */
    bzero ((char *)p,(int)sizeof(POP));

    /*  
     * Initialize maildrop status variables in the POP parameter block 
     */
    p->msgs_deleted = 0;
    p->last_msg = 0;
    p->bytes_deleted = 0;
    p->drop_size = 0;
    p->mmdf_separator = NULL;
    p->bulldir = BULLDIR;
    p->dirty = 0;
    p->xmitting = 0;
    p->AuthType = noauth;
    p->AuthState = none;
    p->kerberos = 0;

#ifdef SERVER_MODE
    p->server_mode = 1;
#else
    p->server_mode = 0;
#endif

    StackInit(&(p->InProcess));
    
    /*  
     * Save my name in a global variable 
     */
    p->myname = argmessage[0];

    /*  
     * Open the log file 
     */
#ifdef SYSLOG42
    (void)openlog(p->myname,0);
#else
    (void)openlog(p->myname,POP_LOGOPTS,POP_FACILITY);
#endif

    /*  
     * Process command line arguments 
     */
    while ( ( c = getopt ( argcount, argmessage, "cdkst:T:b:e:R") ) != EOF )
        switch (c) {

        /*  
         * Debugging requested 
         */
        case 'd':
            p->debug++;
            options |= SO_DEBUG;
            DEBUG_LOG0(p,"Debugging turned on");
            break;

#ifdef KERBEROS
        case 'k':
            p->kerberos++;
            break;
#endif  /* KERBEROS */

            /*  Debugging trace file specified */
        case 't':
            p->debug++;
            if ((p->trace = fopen(optarg,"a+")) == NULL) {
                pop_log ( p, POP_PRIORITY, HERE,
                          "Unable to open trace file \"%s\": %s (%d)",
                          optarg, STRERROR(errno), errno );
                exit(1);
            }
            trace_file_name = optarg;
            DEBUG_LOG1(p, "Trace and Debug destination is file \"%s\"",
                       trace_file_name);
            break;

            /* Stats requested */
        case 's':
            p->stats++;
            break;

            /* Bulletins requested */
        case 'b':
            p->bulldir = optarg;
            DEBUG_LOG1(p, "bulletin directory = %s", p->bulldir);
            break;

            /* Force user names to be lower case */
        case 'c':
            p->downcase_user++;
            DEBUG_LOG0(p, "user names will be downcased (-c)");
            break;

            /* Pop Extensions */
            /* -e login_delay=xx,expire=xx */
        case 'e':
            {
                char *extn_options[] = { "login_delay", "expire", NULL };
                char *value, *option = optarg;
                while(*option) {
                    switch(get_sub_option(&option, extn_options, &value)) {
                    case 0:
                        login_delay = value ? atoi(value) : -1;
                        break;
                    case 1:
                        expire = value ? atoi(value) : -1;
                        break;
                    }
                }
            }
            break;

            /*  Avoid reverse lookups on client */
        case 'R':
            no_rev_lookup = 1;
            DEBUG_LOG0(p,"Avoiding reverse lookups");
            break;

            /*  Timeout value passed.  Default changed */
        case 'T':
            pop_timeout = atoi(optarg);
            DEBUG_LOG1(p, "timeout = %i", pop_timeout);
            break;

            /*  Unknown option received */
        default:
            errflag++;
        }

    /*  Exit if bad options specified */

#ifdef AUTO_DELETE
    if (expire != -1) {
        (void) fprintf(stderr,"EXPIRE must be NEVER (-1) when AUTO_DELETE defined.\n");
        errflag++;
    }

#endif

    if (errflag) {
#ifdef KERBEROS
        (void)fprintf(stderr,"Usage: %s [-c] [-d] [-k] [-R] [-s] [-t trace-file]"
        " [-T timeout] [-b bulldir] [-e login_delay=nn,expire=nn]\n",argmessage[0]);
#else
        (void)fprintf(stderr,"Usage: %s [-c] [-d] [-s] [-R] [-t trace-file]"
        " [-T timeout] [-b bulldir] [-e login_delay=nn,expire=nn]\n",argmessage[0]);
#endif
        exit(1);
    }

    /*  
     * Get the name of our host 
     */
    p->myhost = (char *) malloc ( MAXHOSTNAMELEN +1 );
    if ( p->myhost == NULL ) {
        perror ( "malloc" );
        exit ( 1 ); 
    }
#ifdef _DEBUG
    p->ipaddr = strdup("* _DEBUG *");
    p->client = p->ipaddr;
#else
    (void) gethostname ( p->myhost, MAXHOSTNAMELEN );
    hp = gethostbyname ( p->myhost );
    if ( hp != NULL ) {
        if ( index ( hp->h_name, '.' ) == NULL ) {         /* FQN not returned */
            /*
             * SVR4 resolver is stupid and returns h_name as whatever
             * you gave gethostbyname.  Thus do a reverse lookup
             * on the first address and hope for the best.
             */
            u_long x = *(u_long *) hp->h_addr_list [ 0 ];
            hp = gethostbyaddr ( (char *) &x, 4, AF_INET );
            if ( hp != NULL ) {
                (void) strncpy ( p->myhost, hp->h_name, MAXHOSTNAMELEN );
                p->myhost [ MAXHOSTNAMELEN ] = '\0';
            }
        } /* index ( hp->h_name, '.' ) == NULL */
        else {
            (void) strncpy ( p->myhost, hp->h_name, MAXHOSTNAMELEN );
            p->myhost [ MAXHOSTNAMELEN ] = '\0';
        }
    }

    /*  
     * Get the address and socket of the client to whom I am speaking 
     */
    len = sizeof(cs);
    if ( getpeername ( sp, (struct sockaddr *) &cs, &len ) < 0 ) {
        pop_log ( p, POP_PRIORITY, HERE,
                  "Unable to obtain socket and address of client: %s (%d)",
                  STRERROR(errno), errno );
        exit(1);
    }

    /*
     * Save the dotted decimal form of the client's IP address 
     * in the POP parameter block 
     */
    p->ipaddr = (char *) strdup ( inet_ntoa ( cs.sin_addr ) );

    /*  
     * Save the client's port 
     */
    p->ipport = ntohs ( cs.sin_port );

    if ( no_rev_lookup )
        p->client = p->ipaddr;
    else {
        /*  
         * Get the canonical name of the host to whom I am speaking 
         */
        ch = gethostbyaddr ( (char *) &cs.sin_addr, sizeof(cs.sin_addr), AF_INET );
        if ( ch == NULL ) {
            pop_log ( p, POP_DEBUG, HERE,
                      "(v%s) Unable to get canonical name of client %s: %s (%d)",
                      VERSION, p->ipaddr, hstrerror(h_errno), h_errno );
            p->client = p->ipaddr;
        }
        /*  
         * Save the cannonical name of the client host in 
         * the POP parameter block 
         */
        else {

#ifndef BIND43
            p->client = (char *) strdup ( ch->h_name );
#else

# ifndef SCOR5
#       include <arpa/nameser.h>
#       include <resolv.h>
# endif

        /*  Distrust distant nameservers */

#if !(defined(BSD) && (BSD >= 199103)) && !defined(OSF1) && !defined(HPUX10)
# if (!defined(__RES)) || (__RES < 19940415)
#  ifdef SCOR5
        extern struct __res_state       _res;
#  else
        extern struct state         _res;
#  endif
# endif
#endif
        struct hostent      *   ch_again;
        char            *   *   addrp;
        char                    h_name[MAXHOSTNAMELEN + 1];

        /*  We already have a fully-qualified name */
#ifdef RES_DEFNAMES
        _res.options &= ~RES_DEFNAMES;
#endif

        strncpy(h_name, ch->h_name, sizeof(h_name));

        /*  See if the name obtained for the client's IP 
            address returns an address */
        if ( ( ch_again = gethostbyname(h_name) ) == NULL ) {
            pop_log (p, POP_PRIORITY, HERE,
                     "Client at \"%s\" resolves to an unknown host name \"%s\"",
                     p->ipaddr, h_name );
            p->client = p->ipaddr;
        }
        else {
            /*  Save the host name (the previous value was 
                destroyed by gethostbyname) */
            p->client = (char *)strdup(ch_again->h_name);

            /*  Look for the client's IP address in the list returned 
                for its name */
            for ( addrp=ch_again->h_addr_list; *addrp; ++addrp )
                if ( bcmp ( *addrp, &(cs.sin_addr), sizeof(cs.sin_addr) ) == 0 ) break;

                if ( !*addrp ) {
                    pop_log ( p, POP_PRIORITY, HERE,
                              "Client address \"%s\" not listed for its host name \"%s\"",
                              p->ipaddr, h_name );
                    p->client = p->ipaddr;
                }
        }

#ifdef RES_DEFNAMES
        /* 
         *  Must restore nameserver options since code in crypt uses
         *  gethostbyname call without fully qualified domain name!
         */
        _res.options |= RES_DEFNAMES;
#endif

#endif /* BIND43 */
                }

    } /* no_rev_lookup */

#endif /* _DEBUG */

    /*  Create input file stream for TCP/IP communication */
    if ( ( p->input = fdopen ( sp, "r" ) ) == NULL ) {
        pop_log ( p, POP_PRIORITY, HERE,
                  "Unable to open communication stream for input: %s (%d)",
                  STRERROR(errno), errno );
        exit (1);
    }

#ifdef _DEBUG
    sp = 1;
#endif
    /*  Create output file stream for TCP/IP communication */
    if ( ( p->output = fdopen ( sp, "w" ) ) == NULL ) {
        pop_log ( p, POP_PRIORITY, HERE,
                  "Unable to open communication stream for output: %s (%d)",\
                  STRERROR(errno), errno);
        exit (1);
    }

    DEBUG_LOG3 ( p, "(v%s) Servicing request from \"%s\" at %s",
                 VERSION, p->client, p->ipaddr );
    return ( kerb_authenticate ( p, &cs ) );
}

