/*
 * Copyright (c) 1998, 1999 QUALCOMM Incorporated. All rights reserved.
 * 
 * Description: 
 *   maillock() and mailunlock() try to emulate the SysV functions
 *   to create the user.lock file.
 *   call touchlock() to update the lock.
 *
 * Caveats:
 *   mailunlock() will only remove the lockfile created from previous
 *   maillock(). maillock() called for different users with out the
 *   intermediate calls for mailunlock() would leave the initial locks.
 *   Process termination would not clean the .lock files.
 * 
 * Revisions:
 *
 *   04/21/00 [rcg]
 *        - Renamed to Qmaillock(), Qmailunlock(), and Qtouchlock().
 *
 *   12/06/99 [rcg]
 *        - Added bDebugging parameter.
 *        - Removed K&R junk.
 *
 *   11/23/99 [rcg]
 *        - File added.
 *
 */




#ifndef _QMAILLOCK_H
#  define   _QMAILLOCK_H


#define L_SUCCESS   0
#define L_NAMELEN   1   /* recipient name > 13 chars */
#define L_TMPLOCK   2   /* problem creating temp lockfile */
#define L_TMPWRITE  3   /* problem writing pid into temp lockfile */
#define L_MAXTRYS   4   /* cannot link to lockfile after N tries */
#define L_ERROR     5   /* Something other than EEXIST happened */
#define L_MANLOCK   6   /* cannot set mandatory lock on temp lockfile */


int Qmaillock   ( char *user, int retrycnt, void *fTrace, int bDebugging );
int Qmailunlock ( void );
int Qtouchlock  ( void );


#endif /* _QMAILLOCK_H */

