/* This file is only used for 16-bit Windows DLL's */

#include <windows.h>
#include "config.h"
#include <time.h>
#include <stdarg.h>
#include <stdlib.h>

void _exit(int status)
{
}

void exit(int status)
{
}

#undef fflush
int Py_fflush(FILE *fp)
{
	if (fp >= 0 && fp <= 2)
		return 0;
	return fflush(fp);
}

#undef fgets
char *Py_fgets(char *string, int n, FILE *stream)
{
	if (stream >= 0 && stream <= 2)
		return 0;
	return fgets(string, n, stream);
}

#undef fileno
int Py_fileno(FILE * fp)
{
	if (fp >= 0 && fp <= 2)
		return (int)fp;
	else
		return fileno(fp);
}

int isatty(int handle)
{
	if (handle >= 0 && handle <= 2)
		return 1;
	return 0;
}


int Py_sscanf(const char *buffer, const char *format, ...)
{
	int i, ret;
	int *pti;
	char *pt, *endptr;
	va_list args;

	va_start (args, format);
	if (!strcmp(format, "%x")){
		if (buffer[0] == '0' && (buffer[1] == 'x' || buffer[1] == 'X'))
			buffer += 2;
		ret = (int)strtol(buffer, &endptr, 16);
		if (buffer == endptr){
			ret = 0;
		}
		else{
			pti = va_arg(args, int*);
			*pti = ret;
			ret = 1;
		}
	}
	else if (!strcmp(format, "%d.%d.%d.%d%c")){
		for (i = 0; i < 4; i++){
			ret = (int)strtol(buffer, &endptr, 10);
			if (buffer != endptr){
				pti = va_arg(args, int*);
				*pti = ret;
			}
			else
				break;
			if (*endptr != '.')
				break;
			buffer = endptr + 1;
		}
		if (i == 4 && *endptr){
			i = 5;
			pt = va_arg(args, char*);
			*pt = *endptr;
		}
		return i;
	}
	else if(!strcmp(format, " vi:set tabsize=%d:")){
		ret = 0;
	}
	else if(!strcmp(format, "%d %d %d")){
		for (i = 0; i < 3; i++){
			ret = (int)strtol(buffer, &endptr, 10);
			if (buffer != endptr){
				pti = va_arg(args, int*);
				*pti = ret;
			}
			else
				break;
			while (*endptr &&  *endptr == ' ')
				endptr++;
			buffer = endptr;
		}
		ret = i;
	}
	else {
		ret = 0;
	}
	va_end(args);
	return ret;
}
