// snglmain.cpp : implementation of the CSnglMainFrame class
//
//Python is Copyright 1991-1997 by Stichting Mathematisch Centrum,
//Amsterdam, The Netherlands.  See their copyright notice.

//This code is copyright 1994-1997 by James C. Ahlstrom.  See the
//copyright notice in "copyrite.jim" or e-mail jim@interet.com.
// NO WARRANTIES AT ALL.  USE AT YOUR OWN RISK.


#include "stdafx.h"
#include "app.h"

#include "snglmain.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSnglMainFrame

IMPLEMENT_DYNCREATE(CSnglMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CSnglMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CSnglMainFrame)
	ON_WM_SYSCOMMAND()
	ON_WM_CREATE()
	ON_WM_SETFOCUS()
	ON_WM_DESTROY()
	ON_WM_KILLFOCUS()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// arrays of IDs used to initialize control bars
	
// toolbar buttons - IDs are command buttons
static UINT BASED_CODE buttons[] =
{
	// same order as in the bitmap 'toolbar.bmp'
	ID_FILE_NEW,
	ID_FILE_OPEN,
	ID_FILE_SAVE,
		ID_SEPARATOR,
	ID_EDIT_CUT,
	ID_EDIT_COPY,
	ID_EDIT_PASTE,
		ID_SEPARATOR,
	ID_FILE_PRINT,
	ID_APP_ABOUT,
};

static UINT BASED_CODE indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CSnglMainFrame construction/destruction

CSnglMainFrame::CSnglMainFrame()
{
#ifndef NETSCAPE_PI	// We are not in a Netscape Plugin
	PyObject *method = PyObject_GetAttrString(theApp.m_python_template, "wpyFrame");
	if (!method){
		PyErr_SetString(PyExc_NameError, "Bad template");
		return;
	}
	PyObject * pyframe = PyEval_CallObject (method, NULL);
	Py_DECREF(method);
	if (!pyframe || pyframe == Py_None) {
		ASSERT(0);
		AfxMessageBox("Can not create frame");
	}
	else
		theApp.RecordObjects(this, pyframe, TRUE);
#endif
}

CSnglMainFrame::~CSnglMainFrame()
{
	CObject *obj;
	POSITION pos = m_DeleteList.GetHeadPosition();
	while (pos){	// Delete all objects on delete list.
		obj = m_DeleteList.GetNext(pos);
		theApp.UnRecordCpp(obj, TRUE);
		delete obj;
	}
	m_DeleteList.RemoveAll();
	theApp.UnRecordCpp(this, TRUE);
}

int CSnglMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

#ifdef WANT_TOOLS	
	if (!m_wndToolBar.Create(this) ||
		!m_wndToolBar.LoadBitmap(IDR_MAINFRAME) ||
		!m_wndToolBar.SetButtons(buttons,
		  sizeof(buttons)/sizeof(UINT)))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}
	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

	// TODO: Remove this if you don't want tool tips
	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY);
#endif

	PyObject * pyframe = theApp.GetPythonObject(this);
	ASSERT(pyframe);
	PyObject *pystatus = Py_None;	
	if(pystatus = PyObject_GetAttrString(pyframe, "wpyStatusLine")) {
		if(pystatus != Py_None){
			if (!m_wndStatusBar.Create(this) ||
				!m_wndStatusBar.SetIndicators(indicators, 1))
				//  sizeof(indicators)/sizeof(UINT)))
			{
				TRACE0("Failed to create status bar\n");
				return -1;      // fail to create
			}
		theApp.RecordObjects(&m_wndStatusBar, pystatus, TRUE);	// This will do the INCREF
		}
		Py_DECREF(pystatus);
	}
	else {
		PyErr_Clear();
	}
	PyObject * args = Py_BuildValue("(O)", Py_None);
	theApp.CallPython(this, "OnCreate", args);
	Py_DECREF(args);
	// Change the title.  MFC Undocumented!
	PyObject * pyobj = theApp.GetPythonObject((CObject*)&theApp);
	ASSERT(pyobj);
	char * title = GetAttrString(pyobj, "wpyMainTitle");
	if (title)
		m_strTitle = title;
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CSnglMainFrame diagnostics

#ifdef _DEBUG
void CSnglMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CSnglMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSnglMainFrame message handlers


void CSnglMainFrame::GetMessageString(UINT id, CString& string) const
{
	if (theApp.WpyGetMessageString(id, string))
		return;
	if (id == AFX_IDS_IDLEMESSAGE){
		string = m_StatusLineText;
		return;
	}
	if (string.LoadString(id)) {
		// first newline terminates actual string
		LPTSTR lpsz = string.GetBuffer(255);
		lpsz = strchr(lpsz, '\n');
		if (lpsz != NULL)
			*lpsz = '\0';
		string.ReleaseBuffer();
	}
	else { // not found
		TRACE1("Warning: no message line prompt for ID 0x%04X.\n", id);
	}
}

void CSnglMainFrame::OnSetFocus(CWnd* pOldWnd) 
{
	CFrameWnd::OnSetFocus(pOldWnd);
	PyObject * pyobj = theApp.GetPythonObject(pOldWnd);
	if (!pyobj)
		pyobj = Py_None;
	pyobj = Py_BuildValue("(O)", pyobj);
	theApp.CallPython(this, "WpyPhysOnSetFocus", pyobj);
	Py_DECREF(pyobj);
}

void CSnglMainFrame::OnDestroy() 
{
	CFrameWnd::OnDestroy();
	theApp.CallPython(this, "WpyPhysOnDestroy");	
}

void CSnglMainFrame::OnKillFocus(CWnd* pNewWnd) 
{
	CFrameWnd::OnKillFocus(pNewWnd);
	PyObject * pyobj = theApp.GetPythonObject(pNewWnd);
	if (!pyobj)
		pyobj = Py_None;
	pyobj = Py_BuildValue("(O)", pyobj);
	theApp.CallPython(this, "WpyPhysOnKillFocus", pyobj);
	Py_DECREF(pyobj);
}

void CSnglMainFrame::OnSysCommand(UINT nID, LPARAM lParam) 
{
	PyObject * args = Py_BuildValue("(ii)", nID, lParam);
	PyObject * pyobj = theApp.CallPythonRet(this, "OnSysCommand", args);
	Py_DECREF(args);
	int dodefault = 1;
	if (pyobj){
		if (PyInt_Check(pyobj) && PyInt_AsLong(pyobj) == 0)
			dodefault = 0;
		Py_DECREF(pyobj);
	}
	if ( dodefault)
		CFrameWnd::OnSysCommand(nID, lParam);
}

BOOL CSnglMainFrame::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	PyObject * attr;
	PyObject * pyobj = theApp.GetPythonObject(this);
	if(pyobj && (attr = PyObject_GetAttrString(pyobj, "OnCreateClient"))) {
		PyObject * v = PyInt_FromLong((long)lpcs);
		PyObject_SetAttrString(pyobj, "wpyphysLpcs", v);
		v = PyInt_FromLong((long)pContext);
		PyObject_SetAttrString(pyobj, "wpyphysPContext", v);
		PyObject * args = Py_BuildValue("(iiii)",(int)lpcs->x,
			(int)lpcs->y, (int)lpcs->cx, (int)lpcs->cy);
		PyObject * pyapp = theApp.GetPythonObject(&theApp);
		PyObject * rect = theApp.CallPythonRet(pyapp, "WpyReturnCRect", args);
		Py_DECREF(args);
		args = Py_BuildValue("(O)", rect);
		int ret = theApp.CallPython(this, "OnCreateClient", args);
		Py_DECREF(rect);
		Py_DECREF(args);
		Py_DECREF(attr);
		return ret;
	}
	else {
		PyErr_Clear();
		return CFrameWnd::OnCreateClient(lpcs, pContext);
	}
}

BOOL CSnglMainFrame::PreCreateWindow(CREATESTRUCT& cs) 
{
	long sizex, sizey, x, y;	// Try to set window size
	PyObject * pyframe = theApp.GetPythonObject(this);
	if (!GetAttrLong(pyframe, "wpySizeX", &sizex))
		sizex = 200;
	if (!GetAttrLong(pyframe, "wpySizeY", &sizey))
		sizey = 200;
	if (!GetAttrLong(pyframe, "wpyLocX", &x))
		x = 0;
	if (!GetAttrLong(pyframe, "wpyLocY", &y))
		y = 0;
	if (x > 0 || y > 0) {
		cs.x = x;
		cs.y = y;
	}
	cs.cx = sizex;
	cs.cy = sizey;
	return CFrameWnd::PreCreateWindow(cs);
}

BOOL CSnglMainFrame::OnCommand(WPARAM wParam, LPARAM lParam) 
{
	if (theApp.PyOnCommand(wParam, lParam))
		return TRUE;
	return CFrameWnd::OnCommand(wParam, lParam);
}
