// multimain.cpp : implementation of the CMultiMainFrame class
//
//Python is Copyright 1991-1997 by Stichting Mathematisch Centrum,
//Amsterdam, The Netherlands.  See their copyright notice.

//This code is copyright 1994-1997 by James C. Ahlstrom.  See the
//copyright notice in "copyrite.jim" or e-mail jim@interet.com.
// NO WARRANTIES AT ALL.  USE AT YOUR OWN RISK.


#include "stdafx.h"
#include "app.h"

#include "multmain.h"
#include "window.h"
#include "globals.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMultiMainFrame

IMPLEMENT_DYNAMIC(CMultiMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMultiMainFrame, CMDIFrameWnd)
	//{{AFX_MSG_MAP(CMultiMainFrame)
	ON_WM_SYSCOMMAND()
	ON_WM_CREATE()
	ON_WM_SETFOCUS()
	ON_WM_DESTROY()
	ON_WM_KILLFOCUS()
	ON_WM_CHAR()
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// arrays of IDs used to initialize control bars
	
// toolbar buttons - IDs are command buttons
static UINT BASED_CODE buttons[] =
{
	// same order as in the bitmap 'toolbar.bmp'
	ID_FILE_NEW,
	ID_FILE_OPEN,
	ID_FILE_SAVE,
		ID_SEPARATOR,
	ID_EDIT_CUT,
	ID_EDIT_COPY,
	ID_EDIT_PASTE,
		ID_SEPARATOR,
	ID_FILE_PRINT,
	ID_APP_ABOUT,
};

static UINT BASED_CODE indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMultiMainFrame construction/destruction

CMultiMainFrame::CMultiMainFrame(PyObject * pyframe, CWpythonWnd * pMDIClient)
{
	m_pMDIClient = pMDIClient;
	theApp.RecordObjects(this, pyframe, TRUE);
}

CMultiMainFrame::~CMultiMainFrame()
{
	theApp.UnRecordCpp(this, TRUE);
}

int CMultiMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	if (!m_pMDIClient->SubclassWindow(m_hWndMDIClient)) {
		TRACE("Failed to subclass MDI client window\n");
		return -1;
	}

#ifdef WANT_TOOLS	
	if (!m_wndToolBar.Create(this) ||
		!m_wndToolBar.LoadBitmap(IDR_MAINFRAME) ||
		!m_wndToolBar.SetButtons(buttons,
		  sizeof(buttons)/sizeof(UINT)))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

	// TODO: Remove this if you don't want tool tips
	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY);
#endif

	PyObject * pyframe = theApp.GetPythonObject(this);
	ASSERT(pyframe);
	PyObject *pystatus = Py_None;	
	if(pystatus = PyObject_GetAttrString(pyframe, "wpyStatusLine")) {
		if(pystatus != Py_None){
			if (!m_wndStatusBar.Create(this) ||
				!m_wndStatusBar.SetIndicators(indicators, 1))
				//  sizeof(indicators)/sizeof(UINT)))
			{
				TRACE0("Failed to create status bar\n");
				return -1;      // fail to create
			}
		theApp.RecordObjects(&m_wndStatusBar, pystatus, TRUE);	// This will do the INCREF
		}
		Py_DECREF(pystatus);
	}
	else {
		PyErr_Clear();
	}
	PyObject * args = Py_BuildValue("(O)", Py_None);
	theApp.CallPython(this, "OnCreate", args);
	Py_DECREF(args);
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CMultiMainFrame diagnostics

#ifdef _DEBUG
void CMultiMainFrame::AssertValid() const
{
	CMDIFrameWnd::AssertValid();
}

void CMultiMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMultiMainFrame message handlers



void CMultiMainFrame::GetMessageString(UINT id, CString& string) const
{
	if (theApp.WpyGetMessageString(id, string))
		return;
	if (id == AFX_IDS_IDLEMESSAGE){
		string = m_StatusLineText;
		return;
	}
	if (string.LoadString(id)) {
		// first newline terminates actual string
		LPTSTR lpsz = string.GetBuffer(255);
		lpsz = strchr(lpsz, '\n');
		if (lpsz != NULL)
			*lpsz = '\0';
		string.ReleaseBuffer();
	}
	else { // not found
		TRACE1("Warning: no message line prompt for ID 0x%04X.\n", id);
	}
}

void CMultiMainFrame::SetDefaultMenu(CMenu * menu) 
{
	m_hMenuDefault = menu->GetSafeHmenu();
}

void CMultiMainFrame::OnSetFocus(CWnd* pOldWnd) 
{
	CMDIFrameWnd::OnSetFocus(pOldWnd);
	PyObject * pyobj = theApp.GetPythonObject(pOldWnd);
	if (!pyobj)
		pyobj = Py_None;
	pyobj = Py_BuildValue("(O)", pyobj);
	theApp.CallPython(this, "WpyPhysOnSetFocus", pyobj);
	Py_DECREF(pyobj);
}

void CMultiMainFrame::OnDestroy() 
{
	CMDIFrameWnd::OnDestroy();
	theApp.CallPython(this, "WpyPhysOnDestroy");	
}

void CMultiMainFrame::OnKillFocus(CWnd* pNewWnd) 
{
	CMDIFrameWnd::OnKillFocus(pNewWnd);
	PyObject * pyobj = theApp.GetPythonObject(pNewWnd);
	if (!pyobj)
		pyobj = Py_None;
	pyobj = Py_BuildValue("(O)", pyobj);
	theApp.CallPython(this, "WpyPhysOnKillFocus", pyobj);
	Py_DECREF(pyobj);
}

void CMultiMainFrame::OnSysCommand(UINT nID, LPARAM lParam) 
{
	PyObject * args = Py_BuildValue("(ii)", nID, lParam);
	PyObject * pyobj = theApp.CallPythonRet(this, "OnSysCommand", args);
	Py_DECREF(args);
	int dodefault = 1;
	if (pyobj){
		if (PyInt_Check(pyobj) && PyInt_AsLong(pyobj) == 0)
			dodefault = 0;
		Py_DECREF(pyobj);
	}
	if ( dodefault)
		CMDIFrameWnd::OnSysCommand(nID, lParam);
}

BOOL CMultiMainFrame::PreCreateWindow(CREATESTRUCT& cs) 
{
	long sizex, sizey, x, y;	// Try to set window size
	PyObject * pyframe = theApp.GetPythonObject(this);
	if (!GetAttrLong(pyframe, "wpySizeX", &sizex))
		sizex = 200;
	if (!GetAttrLong(pyframe, "wpySizeY", &sizey))
		sizey = 200;
	if (!GetAttrLong(pyframe, "wpyLocX", &x))
		x = 0;
	if (!GetAttrLong(pyframe, "wpyLocY", &y))
		y = 0;
	if (x > 0 || y > 0) {
		cs.x = x;
		cs.y = y;
	}
	cs.cx = sizex;
	cs.cy = sizey;
	return CMDIFrameWnd::PreCreateWindow(cs);
}

BOOL CMultiMainFrame::OnCommand(WPARAM wParam, LPARAM lParam) 
{
	if (theApp.PyOnCommand(wParam, lParam))
		return TRUE;
	return CMDIFrameWnd::OnCommand(wParam, lParam);
}
