DECLARE_HANDLE(HDIB);

class CWpyImage : public CObject
{
public:
	CWpyImage(PyObject *);

// Attributes
public:
	HDIB GetHDIB() const
		{ return m_hDIB; }
	CPalette* GetPalette() const
		{ return m_palDIB; }
	CSize GetSize() const
		{ return m_sizeDIB; }

// Operations
public:
	BOOL ReadImageFile(LPCTSTR lpszPathName);
	BOOL ReadImageFileDIB(LPCTSTR lpszPathName);
	BOOL ReadImageFileGIF(LPCTSTR lpszPathName);
	BOOL ReadImageFilePPM(LPCTSTR lpszPathName);
	BOOL PaintDIB(CDC *, CRect&);


// Implementation
public:
	virtual ~CWpyImage();

protected:
	HDIB m_hDIB;
	long m_offsetToBits;
	long m_numColors;
	CPalette* m_palDIB;
	CSize m_sizeDIB;

	int ColorsFromBitCount(int);
	BOOL CreateDIBPalette(HDIB, CPalette *);

};

