// app.h : main header file for the WPYTHON application
//
//Python is Copyright 1991-1997 by Stichting Mathematisch Centrum,
//Amsterdam, The Netherlands.  See their copyright notice.

//This code is copyright 1994-1997 by James C. Ahlstrom.  See the
//copyright notice in "copyrite.jim" or e-mail jim@interet.com.
// NO WARRANTIES AT ALL.  USE AT YOUR OWN RISK.


#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"       // main symbols

/////////////////////////////////////////////////////////////////////////////
// CWpythonApp:
// See app.cpp for the implementation of this class
//

class CWpythonApp : public CWinApp
{
public:
// Members
	CString m_StdOutText;
	CWpythonView * m_pNetscapeView;		// Current Netscape view
	PyObject * m_ModuleWpy;		// Module wpy.py to call for classes
	PyObject * m_python_template;	// Current template
	PyObject * m_python_view;	// Current view to create

// Methods
	CWpythonApp();
 	void OnFileNew() {CWinApp::OnFileNew();}
 	void OnFileOpen() {CWinApp::OnFileOpen();}
	BOOL PyOnCommand(WPARAM, LPARAM);
	void PyOnCommandUI(CCmdUI*);

// Utility methods
	int CallPython(PyObject *, char *);
	int CallPython(PyObject *, char *, PyObject *);
	PyObject * CallPythonRet(PyObject *, char *, PyObject *);
	PyObject * CallPythonRet(CObject *, char *, PyObject *);
	int CallPython(CObject *, char *);
	int CallPython(CObject *, char *, PyObject *);
	int CallPython(UINT, char *);
	int CallPython(UINT, char *, PyObject *);
	BOOL WpyGetMessageString(UINT id, CString& string);
	void AddToDeleteList(CWnd*, CWnd*);
	void Py_abort();
	void FlushMessages();
	void OnListBox(UINT, char *);
	void SetUpDC(CDC *, PyObject *);
	PyObject * WpyResetDC(PyObject *, PyObject *);

// Dictionaries for translating Python objects to/from C++ objects and
// control ID's to objects.
public:
	void RecordObjects(CObject *, PyObject *, int);
	void RecordControl(UINT, PyObject *);
	void UnRecordCpp(CObject *, int);
	PyObject * GetPythonObject(CObject *);
	PyObject * GetPythonControl(UINT);
	CObject * GetCppObject(PyObject *);
	void SetPythonTemplate(PyObject *);
	PyObject * GetPythonTemplate();

private:
 	CMapPtrToPtr	m_PythonToCpp;
	CMapPtrToPtr	m_CppToPython;
	CMapWordToPtr	m_ControlToPython;
	CMapPtrToWord	m_PythonToControl;
// End of dictionary methods and variables
	int m_run_interactive;

public:
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWpythonApp)
	public:
	virtual BOOL InitInstance();
	virtual int ExitInstance();
	virtual BOOL OnIdle(LONG lCount);
	virtual BOOL OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo);
	virtual void WinHelp(DWORD, UINT);
	//}}AFX_VIRTUAL

// Implementation

	//{{AFX_MSG(CWpythonApp)
	afx_msg void OnAppAbout();
	afx_msg void OnFilePrintSetup();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


/////////////////////////////////////////////////////////////////////////////
