(* WARNING!! THRERE IS A BUG IN THIS CODE: OCAML PROVIDES NO WAY TO CREATE
   AN UNINITIALISED ARRAY, AND NO WAY TO DESTROY AN OBJECT IN AN ARRAY

   THIS CAN BE FIXED BY RECODING THIS STUFF IN C, OR BY USING
   A HACK: A FUNCTOR IN WHICH THE CLIENT SUPPLIES A DUMMY NULL VALUE
*)

exception Found
exception True
exception False

type 'a varray_t = { mutable used: int;  mutable data: 'a array}

let block = ref 32
let hysteresis = ref (!block * 2)

let rec alloc request avail used =
  if request > avail then (request + (!block -1)) / !block * !block 
  else if request = 0 then 0 
  else if request < used - !hysteresis
  then (request + !block - 1) / !block * !block
  else avail

and get_storage x = x.data
and set_storage x a = x.data <- a
and set_length x n = x.used <- n
and assign x y = x.used <- y.used; x.data <- y.data
and length x = x.used
and of_list x = { used = List.length x; data = Array.of_list x}
and of_array x = { used = Array.length x; data = Array.copy x}
and to_list x = Array.to_list (Array.sub x.data 0 x.used)
and to_array x = Array.sub x.data 0 x.used
and get x i = x.data.(i)
and set x i v = x.data.(i) <- v
and empty () = { used = 0; data = [| |] }

(* append element to x *)
and append_element x e = 
  let n = x.used in
  let avail = Array.length x.data in
  let toalloc = alloc (n+1) avail n in
  if toalloc <> avail
  then begin
   let y = Array.create toalloc e 
   in 
     Array.blit x.data 0 y 0 n;
     x.data <- y
   end else x.data.(n) <- e;
   x.used <- n+1

(* append y to x *)
and append x y = 
  let request = x.used + y.used in
  let toalloc = alloc request (Array.length x.data) x.used 
  in
    if toalloc = 0 
    then x.data <- [| |]
    else if toalloc <> length x
    then 
      let dummy = if (length x) > 0 then x.data.(0) else y.data.(0)
      in x.data <- Array.concat 
        [
          Array.sub x.data 0 x.used;
          Array.sub y.data 0 y.used;
          Array.create (toalloc - x.used - y.used) dummy
        ];
    else Array.blit x.data x.used y.data 0 y.used;
    x.used <- request

(* this is inefficient, because it copies the subarrays *)
and concat ls = 
  let rec mk ls' = match ls' with
  | h :: t -> Array.sub h.data 0 h.used :: mk t
  | [] -> []
  in let a = Array.concat (mk ls) 
  in { used = Array.length a; data = a }

and iter f a = for i = 0 to a.used-1 do f a.data.(i) done
and iiter f a = for i = 0 to a.used-1 do f i a.data.(i) done

and mem e a = 
  try 
    for i = 0 to a.used-1 do if a.data.(i) = e then raise Found done;
    false
  with Found -> true

and sub a start n = 
  { used = n; data = Array.sub a.data start n }

and ref_array a = { used = Array.length a; data = a }

and del x i = 
  Array.blit x.data  (i+1) x.data i (x.used - i - 1); 
  x.used <- x.used - 1

and del_range x i n = 
  Array.blit x.data  (i+n) x.data i (x.used - i - n); 
  x.used <- x.used - n

and insert (x:'a varray_t) (i:int) (v:'a) =
  let n = x.used in
  let avail = Array.length x.data in
  let toalloc = alloc (n+1) avail n in
  if toalloc <> avail
  then begin
   let y = Array.create toalloc v 
   in 
     Array.blit x.data 0 y 0 i;
     (* x.data.(i) <-  v *)
     Array.blit x.data i y (i+1) (n-i);
     x.data <- y
   end else begin
     Array.blit x.data i x.data (i+1) (n-i); (* shift down 1 *)
     x.data.(i) <- v;
  end
  ;
  x.used <- n+1

and copy x = ref_array (Array.sub x.data 0 x.used)

(* WARNING: THIS FUNCTION DOES NOT DESTROY TRAILING OBJECTS 
   I DO THIS FOR EFFICIENCY, THE ALTERNTATIVE IS TO COPY THE ARRAY
   A THIRD TIME!
*)

and filter f x =
  let y = copy x in
  let j = ref 0 in
  for i=0 to x.used - 1 do
    if f x.data.(i) 
    then begin y.data.(!j) <- x.data.(i); incr j
    end 
  done;
  y.used <- !j;
  y

and less lt x y = 
  try 
    for i=0 to (min x.used y.used) - 1 do
      let a = x.data.(i) and b = y.data.(i) in
      if lt a b then raise True
      else if lt b a then raise False
    done;
    x.used < y.used
  with True -> true | False -> false

and equal eq x y = 
  try 
    for i=0 to (min x.used y.used) - 1 do
      let a = x.data.(i) and b = y.data.(i) in
      if not (eq a b) then raise False
    done;
    x.used = y.used
  with False -> false

and sort less x =
  x.data <- to_array x;
  Sort.array less x.data

(* eof *)

