print "Test builtin attributes"

print "Module environment attributes"
print "__name__", __name__
print "__file__", __file__
print "__directory__", __file__

#print "Module attributes --"
#import sys 
#print sys.__dict__["__name__"]

print
print "Class attributes -------"
class X: pass
class Y(X): pass
print "__name__",X.__name__
print "__bases__",X.__bases__

class special:
  def __init__(self):
    self.seq = [0,1,2,3,4,5,6,7]
  # accessors
  def __nonzero__(self):  
    return 0 # false
  def __len__(self): 
    return 20
  def __getitem__(self,index): 
    return 42
  def __getslice__(self,start, stop): 
    return "slice(" + str(start)+","+str(stop)+")"
  def __getattr__(self,key): 
    return "attr " + key
  def __str__(self):
    return "Str of the instance"
  def __repr__(self):
    return "Repr of the instance"
  def __erepr__(self):
    return "Erepr of the instance"

  # mutators
  def __setattr__(self,key,value): 
    if key == 'seq': # this case is needed to make setslice work
      self.__dict__['seq']=value
    else:
      self.__dict__[key] = value + 1000
  def __setitem__(self,key,value): 
    self.__dict__[key] = value + 10000 
  def __setslice__(self,first,last,value): 
    self.seq[first:last]=value
    
print "Special methods"
x = special()
print "nonzero"
assert not x

print "len"
assert len(x) == 20

print "getitem"
assert x[1] == 42

print "getslice"
assert x[1:3] == "slice(1,3)"

print "getattr"
assert x.y == "attr y"

print "setattr"
x.y = 1
assert x.y == 1001

print "setitem"
x['y']=1
assert x.y == 10001

print "setslice"
x[2:4] = [22,33]
assert x.seq == [0,1,22,33,4,5,6,7]

print "str"
assert str(x) == "Str of the instance"

print "repr"
assert repr(x) == "Repr of the instance"

print "erepr"
assert erepr(x) == "Erepr of the instance"


