open Py_types
open Py_exceptions
open Py_datum
exception FoundIt

let module_of_dictionary name directory filename dict (env:environment_t option) = 
  ((new Py_module.py_module 
    name 
    directory
    filename
    dict 
    [| |] 
    Py_mtypes.VarMap.empty 
    env )
    :> module_t )
;;

let dictionary_of_list l = 
  let d = new Py_dict.py_dictionary in
  List.iter 
  (fun x -> ignore (d#set_item (fst x) (snd x)))
  l;
  d

let list_of_string s = 
  let l = ref [] 
  and n = String.length s 
  in for i=0 to (n-1) do l := (String.get s i) :: !l done;
  List.map (fun x -> PyString (String.make 1 x)) (List.rev !l)

let string_of_list l =
  let l' = 
    List.map 
    begin fun x -> match x with 
      | PyString s -> s 
      | _ -> raise (TypeError "List of strings required")
    end
    l
  in String.concat "" l'

let list_of_sequence expr = 
  match expr with
  | PyTuple rhs -> rhs
  | PyList rhs -> rhs
  | PyMutableList rhs -> Varray.to_list rhs 
  | PyString s -> list_of_string s
  | IntRange (start,stop,step) ->
    let l = ref [] 
    and first = ref start 
    in if step > 0 
    then while !first < stop do 
      l := !l @ [PyInt !first]; 
      first := !first + step 
    done
    else if step < 0 
    then while !first > stop do 
      l := !l @ [PyInt !first]; 
      first := !first + step 
    done
    else raise (TypeError "Step is 0 in xrange");
    !l
  | _ -> raise NonSequence

let array_of_sequence expr = Array.of_list (list_of_sequence expr)


let list_of_lvalue_sequence expr = 
  match expr with
  | PyTuple rhs -> rhs
  | PyList rhs -> rhs
  | _ -> raise NonSequence

(* ------------------------------------------------------------------*)
let rec isbaseof cls1 cls2 = 
  if cls1 = cls2 then true
  else begin
    try 
      List.iter
      begin fun base -> if isbaseof cls1 base then raise FoundIt end
      cls2#get_bases;
      false
    with FoundIt -> true
  end
;;

let rec xcompat (x:py_exception) (e:expr_t) : bool =
  match e with 
  | PyTuple ls ->
    begin try 
      List.iter
      begin fun elt -> if xcompat x elt then raise FoundIt end
      ls;
      false
    with FoundIt -> true
    end
  | PyClass cls -> 
    begin match x with 
    | PyInstanceException i -> isbaseof i#get_class cls
    | _ -> false
    end
  | PyString s -> (* match string exceptions by value! *)
    begin match x with
    | PyStringException (s',_) -> s = s'
    | _ -> false
    end
  | _ -> raise (SystemError "in xcompat")
;;


