(* depends on Py_pretok *)

let print_tokens ts = 
  let lineno = ref 0 in
  let indent = ref 0 in
  let emit t = 
    print_string ((Py_pretok.string_of_token t) ^ " ") 
  and emit_eol t = 
    print_endline t;
    let s' = "    " ^ (string_of_int !lineno) in
    let n = String.length s' in
    print_string ((String.sub s' (n-4) 4) ^ ": ");
    for i=0 to !indent -1 do print_string "  " done
  in
  let print_token t =  
    begin match t with
    | Py_parse.NEWLINE (count,f) -> 
      lineno := count; emit_eol ("#")
    | Py_parse.INDENT -> 
      incr indent;
      emit_eol "  #->" 
    | Py_parse.DEDENT -> 
      decr indent;
      emit_eol "#<-" 
    | Py_parse.ENDMARKER -> emit_eol "#<<EOF>>"
    | _ -> emit t
    end;
    flush stdout
  in 
    List.iter print_token ts
;;

class tokeniser t = 
object
  val mutable tokens = []
  val mutable tokens_copy = []
  val mutable current_token_index = 0
  initializer tokens  <- t; tokens_copy <- t

  method token_src (dummy:Lexing.lexbuf) =
    let tmp = List.hd tokens in
    tokens <- List.tl tokens;
    current_token_index <- current_token_index + 1;
    tmp

  method report_syntax_error = 
    print_endline "";
    print_endline "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!";
    let n = List.length tokens_copy in
    let first = max 0 (current_token_index - 20)
    and last = min (n-1) (current_token_index + 20)
    and slist = ref [] in
    for i = first to current_token_index-1 do
      slist := List.concat [!slist; [List.nth tokens_copy i]]
    done;
    print_tokens !slist;
    print_endline "";
    
    print_string "Syntax Error before token ";
    print_endline (string_of_int current_token_index);
    
    slist := [];
    for i = current_token_index to last do
      slist := List.concat [!slist; [List.nth tokens_copy i]]
    done;
    print_tokens !slist;
    print_endline "";
    print_endline "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!";
    flush stdout
end
;;


