open Py_types

let mk_sys (lookup_path: string list) : module_t = 

  (* create the "sys" module *)
  let sysdict = new Py_dict.py_dictionary in
  let sys' = Py_util.module_of_dictionary ["sys"] "[builtin]" "[builtin]" sysdict None in

  (* create a dictionary of builtin modules *)
  let builtin_modules = new Py_dict.py_dictionary in
  ignore (builtin_modules # set_item (PyString "sys") (PyModule sys'))
  ;

  let set k v = if not (sysdict#set_item (PyString k) v)
  then raise (Failure "Set item into sys dict")
  in

  (* __name__ *)
  set 
    ("__name__") 
    (PyString "sys")
  ;


  (* argv *)
  let argv = Sys.argv in
  let n = Array.length argv in
  let py_argv = Array.sub argv 1 (n-1) in
  set "argv" (
    PyMutableList (
      Varray.of_array (
        Array.map (
          fun x -> PyString x
        ) py_argv
      )
    )
  );
  
  (* add the dictionary of builtin modules to the sys module *)
  set ("builtin_modules") (PyDictionary builtin_modules);

  (* now add the standard attributes to the sys module  *)
  (* NOTE: UNLIKE PYTHON, pcre, et al are not built in *)
  set ("builtin_module_names") (PyTuple [
    PyString "__builtin__"; 
    PyString "sys"; 
  ]);

  set ("copyright") (PyString "Maxtal P/L, John Skaller, Australia, 1999");


  (* exc_info: MUST be set by main routine! *)

  (* exec_prefix *)
  set 
    ("executable") 
    (PyString Sys.argv.(0))
  ;

  (* exit n *)
  set ("exit")
    (PyNativeFunction ("exit", Py_builtins.py_exit))
  ;
  (* exitfunc *)
  (* getrefcount *)
  (* last_type *)
  (* last_value *)
  (* last_traceback *)
  (* maxint *)
  
  
  (* imported modules _excludes_ builtins *)
  set ("modules") (PyDictionary (new Py_dict.py_dictionary ))
  ;

  (* path *)
  set ("path") (PyMutableList 
    (Varray.of_list (List.map (fun x-> PyString x) lookup_path))
  )
  ;

  (* platform *)
  set ("platform") (PyString "unknown")
  ;
  
  (* prefix *)
  set ("prefix") (PyString ".")
  ;
  
  (* ps1 *)
  set ("ps1") (PyString ">>>")
  ;
  
  (* ps2 *)
  set ("ps2") (PyString "...")
  ;

  (* setcheckinterval *)
  (* setprofile *)
  (* settrace *)

  (* stdin *)
  (* stdout *)
  (* stderr *)
  (* stdlog [Viper extension] *)

  (* __stdin__ *)
  (* __stdout__ *)
  (* __stderr__ *)
  (* __stdlog__ [Viper extension] *)

  (* version *)
  set ("version") (PyString "2.0.1")
  ;

  sys'
;;

