type token =
    NONE
  | ENDMARKER
  | NAME of (string)
  | INTEGER of (int)
  | LONG of (Big_int.big_int)
  | FLOAT of (float)
  | COMPLEX of (float * float)
  | STRING of (string)
  | NEWLINE of (int * string)
  | SETLINE of (int * string)
  | INDENT
  | DEDENT
  | LPAR
  | RPAR
  | LSQB
  | RSQB
  | COLON
  | COMMA
  | SEMI
  | PLUS
  | MINUS
  | STAR
  | SLASH
  | VBAR
  | AMPER
  | LESS
  | GREATER
  | EQUAL
  | DOT
  | PERCENT
  | BACKQUOTE
  | LBRACE
  | RBRACE
  | EQEQUAL
  | NOTEQUAL
  | LESSEQUAL
  | GREATEREQUAL
  | TILDE
  | CIRCUMFLEX
  | LEFTSHIFT
  | RIGHTSHIFT
  | DOUBLESTAR
  | TRAILING_COMMA
  | POWER
  | PLUSPLUS
  | MINUSMINUS
  | PLUSEQUAL
  | MINUSEQUAL
  | STAREQUAL
  | SLASHEQUAL
  | PERCENTEQUAL
  | CARETEQUAL
  | VBAREQUAL
  | AMPEREQUAL
  | TILDEEQUAL
  | COLONEQUAL
  | LEFTSHIFTEQUAL
  | RIGHTSHIFTEQUAL
  | LEFTARROW
  | RIGHTARROW
  | KEYVALSEP
  | SLICESEP
  | CTRL
  | LOC of (Py_types.sref)
  | RARR
  | AND
  | ASSERT
  | BREAK
  | CLASS
  | CONTINUE
  | DEF
  | DEL
  | ELIF
  | ELSE
  | EXCEPT
  | EXEC
  | FINALLY
  | FOR
  | FROM
  | GLOBAL
  | IF
  | IMPORT
  | IN
  | IS
  | LAMBDA
  | NOT
  | OR
  | PASS
  | PRINT
  | RAISE
  | RETURN
  | TRY
  | WHILE
  | LOC_ELIF of (Py_types.sref)
  | LOC_ELSE of (Py_types.sref)
  | LOC_FINALLY of (Py_types.sref)
  | LOC_EXCEPT of (Py_types.sref)
  | LOC_IF of (Py_types.sref)
  | SLOSH
  | BLANK_LINE
  | COMMENT of (string)
  | COMMENT_NEWLINE of ((int * string) * string)
  | WHITE of (int)
  | ERRORTOKEN of (string)

open Parsing
# 2 "py_parse.mly"
exception EndOfInput
open Py_types

type testlist_t = 
  ListWithComma of expr_t list 
  | ListWithoutComma of expr_t list

let parse_error (s:string) = 
  raise (Py_exceptions.ParseError "Error parsing input")
(* Line 13, file py_parse.ml *)
let yytransl_const = [|
  257 (* NONE *);
  258 (* ENDMARKER *);
  267 (* INDENT *);
  268 (* DEDENT *);
  269 (* LPAR *);
  270 (* RPAR *);
  271 (* LSQB *);
  272 (* RSQB *);
  273 (* COLON *);
  274 (* COMMA *);
  275 (* SEMI *);
  276 (* PLUS *);
  277 (* MINUS *);
  278 (* STAR *);
  279 (* SLASH *);
  280 (* VBAR *);
  281 (* AMPER *);
  282 (* LESS *);
  283 (* GREATER *);
  284 (* EQUAL *);
  285 (* DOT *);
  286 (* PERCENT *);
  287 (* BACKQUOTE *);
  288 (* LBRACE *);
  289 (* RBRACE *);
  290 (* EQEQUAL *);
  291 (* NOTEQUAL *);
  292 (* LESSEQUAL *);
  293 (* GREATEREQUAL *);
  294 (* TILDE *);
  295 (* CIRCUMFLEX *);
  296 (* LEFTSHIFT *);
  297 (* RIGHTSHIFT *);
  298 (* DOUBLESTAR *);
  299 (* TRAILING_COMMA *);
  300 (* POWER *);
  301 (* PLUSPLUS *);
  302 (* MINUSMINUS *);
  303 (* PLUSEQUAL *);
  304 (* MINUSEQUAL *);
  305 (* STAREQUAL *);
  306 (* SLASHEQUAL *);
  307 (* PERCENTEQUAL *);
  308 (* CARETEQUAL *);
  309 (* VBAREQUAL *);
  310 (* AMPEREQUAL *);
  311 (* TILDEEQUAL *);
  312 (* COLONEQUAL *);
  313 (* LEFTSHIFTEQUAL *);
  314 (* RIGHTSHIFTEQUAL *);
  315 (* LEFTARROW *);
  316 (* RIGHTARROW *);
  317 (* KEYVALSEP *);
  318 (* SLICESEP *);
  319 (* CTRL *);
  321 (* RARR *);
  322 (* AND *);
  323 (* ASSERT *);
  324 (* BREAK *);
  325 (* CLASS *);
  326 (* CONTINUE *);
  327 (* DEF *);
  328 (* DEL *);
  329 (* ELIF *);
  330 (* ELSE *);
  331 (* EXCEPT *);
  332 (* EXEC *);
  333 (* FINALLY *);
  334 (* FOR *);
  335 (* FROM *);
  336 (* GLOBAL *);
  337 (* IF *);
  338 (* IMPORT *);
  339 (* IN *);
  340 (* IS *);
  341 (* LAMBDA *);
  342 (* NOT *);
  343 (* OR *);
  344 (* PASS *);
  345 (* PRINT *);
  346 (* RAISE *);
  347 (* RETURN *);
  348 (* TRY *);
  349 (* WHILE *);
  355 (* SLOSH *);
  356 (* BLANK_LINE *);
    0|]

let yytransl_block = [|
  259 (* NAME *);
  260 (* INTEGER *);
  261 (* LONG *);
  262 (* FLOAT *);
  263 (* COMPLEX *);
  264 (* STRING *);
  265 (* NEWLINE *);
  266 (* SETLINE *);
  320 (* LOC *);
  350 (* LOC_ELIF *);
  351 (* LOC_ELSE *);
  352 (* LOC_FINALLY *);
  353 (* LOC_EXCEPT *);
  354 (* LOC_IF *);
  357 (* COMMENT *);
  358 (* COMMENT_NEWLINE *);
  359 (* WHITE *);
  360 (* ERRORTOKEN *);
    0|]

let yylhs = "\255\255\
\029\000\029\000\031\000\031\000\002\000\002\000\003\000\018\000\
\032\000\032\000\032\000\034\000\034\000\034\000\036\000\036\000\
\036\000\036\000\036\000\037\000\037\000\037\000\038\000\038\000\
\039\000\039\000\035\000\035\000\030\000\030\000\043\000\043\000\
\041\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\045\000\045\000\045\000\045\000\044\000\
\044\000\044\000\044\000\044\000\044\000\044\000\044\000\044\000\
\044\000\044\000\044\000\044\000\044\000\044\000\044\000\020\000\
\046\000\046\000\047\000\047\000\048\000\049\000\049\000\005\000\
\005\000\004\000\021\000\021\000\022\000\023\000\024\000\024\000\
\024\000\024\000\050\000\051\000\052\000\052\000\053\000\053\000\
\053\000\053\000\025\000\025\000\025\000\055\000\055\000\054\000\
\054\000\056\000\056\000\026\000\027\000\027\000\027\000\028\000\
\028\000\042\000\042\000\042\000\042\000\042\000\042\000\057\000\
\058\000\059\000\060\000\060\000\061\000\061\000\014\000\014\000\
\015\000\015\000\016\000\016\000\017\000\017\000\017\000\017\000\
\063\000\063\000\063\000\064\000\062\000\062\000\033\000\033\000\
\065\000\065\000\040\000\040\000\040\000\067\000\067\000\066\000\
\066\000\070\000\070\000\069\000\069\000\071\000\071\000\072\000\
\072\000\073\000\073\000\073\000\073\000\073\000\073\000\073\000\
\073\000\073\000\073\000\006\000\006\000\074\000\074\000\075\000\
\075\000\007\000\007\000\076\000\076\000\008\000\008\000\077\000\
\077\000\078\000\078\000\009\000\009\000\079\000\079\000\080\000\
\080\000\010\000\010\000\081\000\081\000\081\000\082\000\082\000\
\011\000\011\000\012\000\012\000\012\000\012\000\083\000\085\000\
\085\000\013\000\013\000\086\000\086\000\084\000\084\000\089\000\
\089\000\088\000\088\000\088\000\088\000\088\000\088\000\088\000\
\088\000\088\000\088\000\088\000\088\000\088\000\088\000\088\000\
\088\000\088\000\068\000\068\000\068\000\068\000\087\000\087\000\
\087\000\087\000\087\000\087\000\093\000\093\000\092\000\092\000\
\094\000\094\000\094\000\094\000\094\000\094\000\094\000\094\000\
\094\000\094\000\094\000\094\000\094\000\094\000\095\000\090\000\
\090\000\019\000\019\000\091\000\091\000\096\000\096\000\000\000\
\000\000"

let yylen = "\002\000\
\001\000\001\000\002\000\001\000\002\000\001\000\002\000\005\000\
\003\000\004\000\002\000\003\000\001\000\001\000\006\000\005\000\
\002\000\003\000\002\000\001\000\003\000\004\000\003\000\001\000\
\003\000\001\000\003\000\001\000\001\000\001\000\003\000\001\000\
\002\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\003\000\003\000\003\000\003\000\002\000\
\004\000\004\000\004\000\004\000\004\000\004\000\004\000\004\000\
\004\000\004\000\004\000\003\000\003\000\003\000\003\000\002\000\
\003\000\001\000\002\000\001\000\001\000\003\000\001\000\002\000\
\001\000\001\000\003\000\002\000\003\000\002\000\001\000\001\000\
\001\000\001\000\002\000\002\000\003\000\002\000\007\000\005\000\
\003\000\002\000\003\000\005\000\005\000\003\000\001\000\003\000\
\001\000\003\000\001\000\003\000\007\000\005\000\003\000\005\000\
\003\000\001\000\001\000\001\000\001\000\001\000\001\000\003\000\
\002\000\003\000\002\000\001\000\002\000\001\000\002\000\001\000\
\006\000\004\000\008\000\006\000\006\000\004\000\005\000\005\000\
\004\000\002\000\001\000\002\000\002\000\001\000\002\000\005\000\
\002\000\001\000\002\000\001\000\001\000\003\000\002\000\002\000\
\001\000\003\000\002\000\002\000\001\000\002\000\001\000\002\000\
\001\000\002\000\002\000\002\000\002\000\002\000\002\000\002\000\
\003\000\002\000\003\000\002\000\001\000\003\000\002\000\003\000\
\002\000\002\000\001\000\003\000\002\000\002\000\001\000\002\000\
\002\000\002\000\001\000\002\000\001\000\002\000\002\000\002\000\
\001\000\002\000\001\000\002\000\002\000\002\000\002\000\001\000\
\002\000\001\000\002\000\002\000\002\000\001\000\002\000\002\000\
\001\000\002\000\001\000\002\000\001\000\002\000\001\000\002\000\
\001\000\002\000\004\000\003\000\002\000\004\000\003\000\002\000\
\003\000\004\000\003\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\004\000\005\000\003\000\004\000\002\000\003\000\
\004\000\003\000\004\000\002\000\003\000\002\000\002\000\001\000\
\003\000\005\000\004\000\004\000\004\000\003\000\003\000\003\000\
\002\000\003\000\002\000\002\000\001\000\001\000\003\000\003\000\
\001\000\007\000\004\000\003\000\001\000\003\000\001\000\002\000\
\002\000"

let yydefred = "\000\000\
\000\000\000\000\000\000\006\000\001\000\000\000\000\000\000\000\
\008\001\106\000\107\000\108\000\109\000\110\000\111\000\035\000\
\036\000\037\000\038\000\039\000\040\000\041\000\042\000\043\000\
\000\000\002\000\000\000\029\000\030\000\000\000\034\000\079\000\
\080\000\081\000\082\000\000\000\000\000\221\000\220\000\222\000\
\224\000\223\000\225\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\009\001\000\000\074\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\198\000\
\071\000\000\000\000\000\141\000\000\000\149\000\000\000\000\000\
\226\000\000\000\000\000\000\000\083\000\000\000\084\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\078\000\000\000\
\000\000\000\000\000\000\000\000\000\000\048\000\000\000\000\000\
\003\000\005\000\033\000\000\000\000\000\117\000\000\000\119\000\
\208\000\210\000\000\000\213\000\000\000\195\000\196\000\000\000\
\216\000\000\000\000\000\000\000\197\000\020\000\000\000\000\000\
\000\000\000\000\000\000\000\000\014\000\000\000\028\000\148\000\
\007\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\150\000\000\000\000\000\164\000\000\000\170\000\
\000\000\174\000\000\000\000\000\000\000\180\000\000\000\000\000\
\000\000\186\000\000\000\000\000\000\000\000\000\193\000\000\000\
\072\000\000\000\139\000\000\000\144\000\000\000\000\000\202\000\
\000\000\000\000\000\000\206\000\000\000\061\000\063\000\000\000\
\000\000\000\000\077\000\000\000\066\000\000\000\069\000\000\000\
\000\000\000\000\000\000\100\000\091\000\000\000\075\000\000\000\
\085\000\000\000\000\000\000\000\000\000\060\000\062\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\114\000\000\000\031\000\000\000\115\000\113\000\
\212\000\000\000\215\000\000\000\219\000\000\000\217\000\000\000\
\000\000\000\000\000\000\000\000\000\000\019\000\000\000\229\000\
\000\000\000\000\000\000\154\000\155\000\156\000\159\000\158\000\
\157\000\160\000\000\000\162\000\000\000\152\000\000\000\000\000\
\000\000\176\000\177\000\178\000\182\000\183\000\184\000\188\000\
\189\000\190\000\191\000\070\000\000\000\000\000\199\000\200\000\
\000\000\231\000\007\001\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\236\000\204\000\000\000\000\000\003\001\000\000\
\000\000\000\000\000\000\067\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\135\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\044\000\049\000\050\000\051\000\
\052\000\055\000\056\000\054\000\053\000\057\000\058\000\059\000\
\112\000\211\000\214\000\255\000\218\000\000\001\000\000\021\000\
\000\000\000\000\018\000\230\000\000\000\227\000\012\000\027\000\
\025\000\163\000\161\000\166\000\168\000\172\000\142\000\146\000\
\000\000\232\000\000\000\000\000\000\000\000\000\000\000\000\000\
\234\000\000\000\000\000\239\000\104\000\000\000\011\000\000\000\
\008\000\000\000\065\000\000\000\094\000\093\000\092\000\098\000\
\096\000\000\000\000\000\127\000\128\000\000\000\000\000\132\000\
\133\000\000\000\023\000\022\000\000\000\000\000\228\000\006\001\
\233\000\004\001\241\000\248\000\000\000\000\000\000\000\235\000\
\000\000\000\000\009\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\125\000\121\000\000\000\016\000\245\000\244\000\
\000\000\237\000\002\001\010\000\101\000\000\000\087\000\137\000\
\136\000\129\000\015\000\242\000\123\000"

let yydgoto = "\003\000\
\008\000\009\000\054\000\093\000\056\000\057\000\058\000\059\000\
\060\000\061\000\062\000\063\000\064\000\010\000\011\000\012\000\
\013\000\014\000\015\000\016\000\017\000\018\000\019\000\020\000\
\021\000\022\000\023\000\024\000\025\000\026\000\027\000\025\001\
\195\000\123\000\124\000\125\000\126\000\227\000\127\000\065\000\
\028\000\029\000\030\000\031\000\094\000\182\000\183\000\184\000\
\066\000\032\000\033\000\034\000\035\000\189\000\190\000\188\000\
\101\000\104\000\036\000\102\000\037\000\040\001\041\001\042\001\
\137\001\067\000\163\000\068\000\069\000\165\000\070\000\139\000\
\140\000\142\000\144\000\146\000\149\000\150\000\153\000\154\000\
\158\000\159\000\167\000\071\000\168\000\172\000\173\000\072\000\
\073\000\115\000\012\001\017\001\092\001\018\001\116\000\013\001"

let yysindex = "\028\000\
\031\255\161\007\000\000\000\000\000\000\065\000\161\007\248\254\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\254\254\000\000\071\255\000\000\000\000\057\255\000\000\000\000\
\000\000\000\000\000\000\242\254\069\255\000\000\000\000\000\000\
\000\000\000\000\000\000\151\255\137\255\044\000\186\008\186\008\
\161\007\229\006\186\008\009\255\228\007\000\000\177\255\000\000\
\175\255\157\255\147\255\183\255\064\255\156\255\072\000\000\000\
\000\000\024\255\127\255\000\000\159\255\000\000\199\255\167\255\
\000\000\161\007\161\007\161\007\000\000\214\255\000\000\217\255\
\161\007\186\008\186\008\245\255\001\000\245\255\000\000\161\007\
\161\007\161\007\200\255\161\007\180\008\000\000\200\255\202\255\
\000\000\000\000\000\000\161\007\242\254\000\000\200\255\000\000\
\000\000\000\000\118\255\000\000\068\255\000\000\000\000\237\255\
\000\000\221\255\241\254\017\000\000\000\000\000\218\255\168\255\
\039\000\011\007\239\255\026\000\000\000\025\000\000\000\000\000\
\000\000\186\008\186\008\186\008\186\008\186\008\186\008\186\008\
\249\007\231\255\000\000\175\255\186\008\000\000\186\008\000\000\
\186\008\000\000\186\008\186\008\064\255\000\000\186\008\186\008\
\156\255\000\000\186\008\186\008\186\008\072\000\000\000\161\007\
\000\000\228\007\000\000\228\007\000\000\102\002\199\255\000\000\
\032\007\193\006\052\000\000\000\167\255\000\000\000\000\045\000\
\253\254\054\000\000\000\018\000\000\000\060\255\000\000\029\000\
\058\000\031\000\086\000\000\000\000\000\096\000\000\000\097\000\
\000\000\255\254\010\000\200\255\161\007\000\000\000\000\161\007\
\161\007\161\007\161\007\161\007\161\007\161\007\161\007\161\007\
\161\007\161\007\000\000\158\000\000\000\200\255\000\000\000\000\
\000\000\102\000\000\000\101\000\000\000\161\007\000\000\087\000\
\161\007\103\000\051\255\104\000\120\000\000\000\161\007\000\000\
\073\007\185\255\161\007\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\186\008\000\000\186\008\000\000\157\255\147\255\
\183\255\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\127\255\159\255\000\000\000\000\
\099\000\000\000\000\000\054\255\106\000\110\000\118\007\063\000\
\034\255\122\000\000\000\000\000\161\007\161\007\000\000\171\255\
\200\255\161\007\186\008\000\000\161\007\245\255\227\255\001\000\
\245\255\161\007\131\000\000\000\200\255\200\255\161\007\051\000\
\200\255\055\000\053\000\121\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\218\255\000\000\
\146\000\019\255\000\000\000\000\161\007\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\161\007\000\000\153\000\207\007\140\000\161\007\108\000\140\007\
\000\000\156\000\193\006\000\000\000\000\160\000\000\000\105\255\
\000\000\159\000\000\000\200\255\000\000\000\000\000\000\000\000\
\000\000\163\000\228\254\000\000\000\000\164\000\200\255\000\000\
\000\000\200\255\000\000\000\000\154\000\180\000\000\000\000\000\
\000\000\000\000\000\000\000\000\161\007\161\007\124\000\000\000\
\122\000\200\255\000\000\170\000\161\007\092\000\161\007\228\254\
\176\000\161\007\000\000\000\000\188\000\000\000\000\000\000\000\
\161\007\000\000\000\000\000\000\000\000\200\255\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000"

let yyrindex = "\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\183\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\191\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\023\255\011\255\000\000\000\000\000\000\
\000\000\000\000\000\000\243\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\213\005\089\005\207\004\055\004\159\003\007\003\111\002\000\000\
\000\000\166\000\066\008\000\000\073\006\000\000\215\001\063\001\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\246\255\
\248\255\004\000\000\000\000\000\009\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\035\255\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\247\255\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\065\255\000\000\074\255\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\015\006\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\235\003\000\000\000\000\000\000\
\083\003\000\000\000\000\000\000\000\000\187\002\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\035\002\000\000\
\000\000\000\000\000\000\000\000\139\001\000\000\000\000\020\000\
\000\000\000\000\000\000\021\000\000\000\112\000\000\000\000\000\
\008\255\000\000\022\000\000\000\000\000\024\000\000\000\074\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\135\255\000\000\084\255\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\151\005\027\005\
\131\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\123\008\130\006\000\000\000\000\
\020\008\000\000\000\000\000\000\140\255\000\000\073\255\154\255\
\000\000\096\255\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\135\000\012\255\
\000\000\036\255\037\255\079\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\173\255\176\255\228\255\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\080\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\081\000\000\000\000\000\000\000\136\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\229\255\234\255\235\255\000\000\
\130\255\000\000\000\000\000\000\000\000\062\255\000\000\189\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\238\255\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000"

let yygindex = "\000\000\
\000\000\000\000\000\000\032\000\112\001\178\255\061\001\062\001\
\064\001\008\000\142\000\224\255\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\059\255\181\001\000\000\
\162\255\184\000\000\000\229\000\143\255\147\000\249\000\249\255\
\027\001\000\000\135\001\000\000\035\001\000\000\000\000\000\000\
\046\001\000\000\000\000\000\000\000\000\200\000\174\255\077\000\
\000\000\000\000\000\000\134\001\000\000\194\000\000\000\000\000\
\105\000\077\001\237\000\000\000\206\255\244\000\000\000\111\001\
\000\000\006\001\007\001\005\001\000\000\126\001\000\000\107\001\
\000\000\123\001\000\000\119\001\131\001\129\001\000\000\000\000\
\003\002\082\001\224\000\000\000\181\000\220\000\000\000\000\000"

let yytablesize = 2542
let yytable = "\095\000\
\211\000\186\000\128\000\180\000\181\000\226\000\005\000\035\001\
\216\000\022\001\096\000\118\000\120\000\126\000\110\000\111\000\
\095\000\223\000\117\000\120\000\126\000\119\000\120\000\126\000\
\118\000\095\000\095\000\224\000\001\000\002\000\120\000\118\000\
\004\000\055\000\118\000\006\000\116\000\134\000\122\000\005\000\
\117\001\160\000\114\000\116\000\134\000\122\000\116\000\134\000\
\122\000\089\001\121\000\236\000\237\000\238\000\239\000\240\000\
\241\000\242\000\244\000\194\000\118\001\006\000\212\000\124\000\
\064\001\099\000\161\000\082\001\176\000\007\000\124\000\122\000\
\098\000\124\000\120\000\126\000\090\001\027\001\013\000\100\000\
\112\000\192\000\023\001\219\000\196\000\160\000\118\000\026\000\
\253\000\095\000\253\000\026\000\214\000\065\001\006\000\007\000\
\083\001\017\000\116\000\134\000\122\000\043\001\028\001\147\000\
\148\000\174\000\175\000\013\000\120\000\126\000\220\000\240\000\
\179\000\006\001\232\000\253\000\026\000\118\000\131\001\057\001\
\118\000\193\000\000\001\001\001\002\001\124\000\017\000\013\000\
\007\000\116\000\134\000\217\000\116\000\134\000\122\000\160\000\
\026\000\038\000\240\000\039\000\040\000\041\000\042\000\043\000\
\044\000\238\000\017\000\132\001\024\000\045\000\106\000\046\000\
\004\001\005\001\250\000\251\000\047\000\048\000\044\000\124\000\
\218\000\011\001\016\001\103\000\074\001\136\001\075\001\049\000\
\050\000\254\000\228\000\254\000\238\000\118\000\051\000\151\000\
\152\000\024\000\129\000\169\000\141\000\170\000\005\001\119\000\
\095\001\143\000\097\001\118\000\249\000\229\000\249\000\252\000\
\120\000\252\000\136\001\171\000\254\000\119\000\108\001\109\001\
\130\000\131\000\112\001\101\001\099\001\226\000\120\000\145\000\
\132\000\133\000\134\000\135\000\121\000\162\000\060\001\249\000\
\177\000\114\000\252\000\178\000\118\000\052\000\053\000\068\001\
\164\000\070\001\121\000\073\001\044\001\187\000\119\000\046\001\
\047\001\048\001\049\001\050\001\051\001\052\001\053\001\054\001\
\055\001\056\001\166\000\251\000\247\000\251\000\247\000\185\000\
\102\001\246\000\250\000\246\000\250\000\243\000\076\000\243\000\
\090\000\136\000\137\000\187\000\138\000\134\001\194\000\087\001\
\076\000\212\000\090\000\221\000\086\000\093\001\251\000\247\000\
\139\001\064\000\098\001\140\001\246\000\250\000\086\000\001\001\
\243\000\222\000\106\001\064\000\105\000\103\000\099\000\110\001\
\097\000\001\001\225\000\147\001\253\000\254\000\105\000\103\000\
\099\000\230\000\097\000\234\000\038\000\233\000\039\000\040\000\
\041\000\042\000\043\000\044\000\235\000\094\001\019\001\157\001\
\045\000\245\000\046\000\108\000\100\001\119\001\021\001\047\000\
\048\000\038\000\024\001\039\000\040\000\041\000\042\000\043\000\
\044\000\120\001\049\000\050\000\011\001\045\000\124\001\046\000\
\127\001\051\000\089\000\016\001\047\000\048\000\030\001\045\000\
\102\000\088\000\107\000\109\000\089\000\155\000\156\000\049\000\
\050\000\045\000\102\000\088\000\026\001\157\000\051\000\032\001\
\037\001\038\001\039\001\103\001\104\001\074\000\075\000\029\001\
\031\001\033\001\034\001\058\001\059\001\143\001\144\001\061\001\
\063\001\066\001\067\001\084\001\088\001\149\001\081\001\151\001\
\052\000\053\000\154\001\076\000\077\000\078\000\079\000\080\000\
\081\000\156\001\085\001\091\001\082\000\107\001\083\000\084\000\
\085\000\111\001\086\000\114\001\197\000\052\000\053\000\039\001\
\087\000\088\000\089\000\090\000\091\000\092\000\038\000\116\001\
\039\000\040\000\041\000\042\000\043\000\044\000\121\001\073\000\
\123\001\125\001\045\000\128\001\046\000\130\001\073\000\141\001\
\133\001\047\000\048\000\073\000\135\001\138\001\142\001\148\001\
\073\000\145\001\150\001\153\001\049\000\050\000\155\001\032\000\
\004\000\073\000\068\000\051\000\073\000\131\000\130\000\191\000\
\138\000\247\000\074\000\075\000\248\000\097\000\071\001\096\001\
\249\000\115\001\073\000\073\000\073\000\073\000\073\000\073\000\
\073\000\073\000\073\000\073\000\036\001\073\000\073\000\073\000\
\076\000\077\000\072\001\079\000\073\000\081\000\213\000\045\001\
\105\001\082\000\215\000\113\001\084\000\085\000\005\001\086\000\
\152\001\079\001\052\000\053\000\209\000\087\000\088\000\089\000\
\090\000\080\001\246\000\209\000\076\001\078\001\077\001\209\000\
\209\000\209\000\209\000\255\000\209\000\209\000\209\000\209\000\
\209\000\209\000\209\000\209\000\209\000\209\000\209\000\209\000\
\209\000\209\000\252\000\209\000\209\000\209\000\209\000\209\000\
\003\001\209\000\209\000\209\000\007\001\209\000\209\000\209\000\
\209\000\209\000\209\000\209\000\209\000\209\000\209\000\209\000\
\209\000\008\001\209\000\209\000\209\000\020\001\105\000\209\000\
\209\000\209\000\062\001\122\001\209\000\146\001\129\001\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\207\000\000\000\000\000\000\000\000\000\209\000\209\000\207\000\
\209\000\209\000\000\000\000\000\207\000\000\000\207\000\000\000\
\207\000\207\000\207\000\207\000\207\000\207\000\207\000\207\000\
\207\000\207\000\207\000\000\000\207\000\207\000\000\000\207\000\
\207\000\207\000\207\000\207\000\000\000\207\000\207\000\207\000\
\000\000\207\000\207\000\207\000\207\000\207\000\207\000\207\000\
\207\000\207\000\207\000\207\000\207\000\000\000\207\000\207\000\
\207\000\000\000\000\000\207\000\207\000\207\000\000\000\000\000\
\207\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\205\000\000\000\000\000\000\000\
\000\000\207\000\207\000\205\000\207\000\207\000\000\000\000\000\
\205\000\000\000\205\000\000\000\205\000\205\000\205\000\205\000\
\205\000\205\000\205\000\205\000\205\000\205\000\205\000\000\000\
\205\000\205\000\000\000\205\000\205\000\205\000\205\000\205\000\
\000\000\205\000\205\000\205\000\000\000\205\000\205\000\205\000\
\205\000\205\000\205\000\205\000\205\000\205\000\205\000\205\000\
\205\000\000\000\205\000\205\000\205\000\000\000\000\000\205\000\
\205\000\205\000\000\000\000\000\205\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\203\000\000\000\000\000\000\000\000\000\205\000\205\000\203\000\
\205\000\205\000\000\000\000\000\203\000\000\000\203\000\000\000\
\203\000\203\000\203\000\203\000\203\000\203\000\203\000\203\000\
\203\000\203\000\203\000\000\000\203\000\203\000\000\000\203\000\
\203\000\203\000\203\000\203\000\000\000\203\000\203\000\203\000\
\000\000\203\000\000\000\203\000\203\000\203\000\203\000\203\000\
\203\000\203\000\203\000\203\000\203\000\000\000\203\000\203\000\
\203\000\000\000\000\000\203\000\203\000\203\000\000\000\000\000\
\203\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\201\000\000\000\000\000\000\000\
\000\000\203\000\203\000\201\000\203\000\203\000\000\000\000\000\
\201\000\000\000\201\000\000\000\201\000\201\000\201\000\201\000\
\201\000\201\000\201\000\201\000\201\000\201\000\201\000\000\000\
\201\000\201\000\000\000\201\000\201\000\201\000\201\000\201\000\
\000\000\201\000\201\000\201\000\000\000\201\000\000\000\201\000\
\201\000\201\000\201\000\201\000\201\000\201\000\201\000\201\000\
\201\000\000\000\201\000\201\000\201\000\000\000\000\000\201\000\
\201\000\201\000\000\000\000\000\201\000\000\000\038\000\000\000\
\039\000\040\000\041\000\042\000\043\000\044\000\000\000\000\000\
\194\000\000\000\045\000\000\000\046\000\201\000\201\000\194\000\
\201\000\201\000\000\000\000\000\194\000\000\000\194\000\000\000\
\194\000\194\000\194\000\194\000\049\000\050\000\194\000\194\000\
\194\000\194\000\194\000\000\000\000\000\194\000\000\000\194\000\
\194\000\194\000\194\000\194\000\000\000\194\000\194\000\194\000\
\000\000\194\000\000\000\194\000\194\000\194\000\194\000\194\000\
\194\000\194\000\194\000\194\000\194\000\000\000\194\000\194\000\
\194\000\000\000\000\000\194\000\194\000\194\000\000\000\000\000\
\194\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\192\000\000\000\000\000\000\000\
\000\000\194\000\194\000\192\000\194\000\194\000\000\000\000\000\
\192\000\000\000\192\000\000\000\192\000\192\000\192\000\192\000\
\000\000\000\000\192\000\192\000\192\000\192\000\192\000\000\000\
\000\000\192\000\000\000\192\000\192\000\192\000\192\000\192\000\
\000\000\192\000\192\000\192\000\000\000\192\000\000\000\192\000\
\192\000\192\000\192\000\192\000\192\000\192\000\192\000\192\000\
\192\000\000\000\192\000\192\000\192\000\000\000\000\000\192\000\
\192\000\192\000\000\000\000\000\192\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\187\000\000\000\000\000\000\000\000\000\192\000\192\000\187\000\
\192\000\192\000\000\000\000\000\187\000\000\000\187\000\000\000\
\187\000\187\000\000\000\000\000\000\000\000\000\187\000\187\000\
\187\000\187\000\187\000\000\000\000\000\187\000\000\000\187\000\
\187\000\187\000\187\000\187\000\000\000\187\000\187\000\187\000\
\000\000\187\000\000\000\187\000\187\000\187\000\187\000\187\000\
\187\000\187\000\187\000\187\000\187\000\000\000\187\000\187\000\
\187\000\000\000\000\000\187\000\187\000\187\000\000\000\000\000\
\187\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\185\000\000\000\000\000\000\000\
\000\000\187\000\187\000\185\000\187\000\187\000\000\000\000\000\
\185\000\000\000\185\000\000\000\185\000\185\000\000\000\000\000\
\000\000\000\000\185\000\185\000\185\000\185\000\185\000\000\000\
\000\000\185\000\000\000\185\000\185\000\185\000\185\000\185\000\
\000\000\185\000\185\000\185\000\000\000\185\000\000\000\185\000\
\185\000\185\000\185\000\185\000\185\000\185\000\185\000\185\000\
\185\000\000\000\185\000\185\000\185\000\000\000\000\000\185\000\
\185\000\185\000\000\000\000\000\185\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\181\000\000\000\000\000\000\000\000\000\185\000\185\000\181\000\
\185\000\185\000\000\000\000\000\181\000\000\000\181\000\000\000\
\181\000\181\000\000\000\000\000\000\000\000\000\181\000\181\000\
\181\000\181\000\181\000\000\000\000\000\181\000\000\000\181\000\
\181\000\181\000\181\000\181\000\000\000\181\000\000\000\000\000\
\000\000\181\000\000\000\181\000\181\000\181\000\181\000\181\000\
\181\000\181\000\181\000\181\000\181\000\000\000\181\000\181\000\
\181\000\000\000\000\000\181\000\181\000\181\000\000\000\000\000\
\181\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\179\000\000\000\000\000\000\000\
\000\000\181\000\181\000\179\000\181\000\181\000\000\000\000\000\
\179\000\000\000\179\000\000\000\179\000\179\000\000\000\000\000\
\000\000\000\000\179\000\179\000\179\000\179\000\179\000\000\000\
\000\000\179\000\000\000\179\000\179\000\179\000\179\000\179\000\
\000\000\179\000\000\000\000\000\000\000\179\000\000\000\179\000\
\179\000\179\000\179\000\179\000\179\000\179\000\179\000\179\000\
\179\000\000\000\179\000\179\000\179\000\000\000\000\000\179\000\
\179\000\179\000\000\000\000\000\179\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\175\000\000\000\000\000\000\000\000\000\179\000\179\000\175\000\
\179\000\179\000\000\000\000\000\175\000\000\000\175\000\000\000\
\175\000\175\000\000\000\000\000\000\000\000\000\175\000\000\000\
\175\000\175\000\175\000\000\000\000\000\175\000\000\000\175\000\
\175\000\175\000\175\000\175\000\000\000\175\000\000\000\000\000\
\000\000\175\000\000\000\175\000\175\000\175\000\175\000\175\000\
\175\000\175\000\175\000\175\000\175\000\000\000\175\000\175\000\
\175\000\000\000\000\000\175\000\175\000\175\000\000\000\000\000\
\175\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\173\000\000\000\000\000\000\000\
\000\000\175\000\175\000\173\000\175\000\175\000\000\000\000\000\
\173\000\000\000\173\000\000\000\173\000\173\000\000\000\000\000\
\000\000\000\000\173\000\000\000\173\000\173\000\173\000\000\000\
\000\000\173\000\000\000\173\000\173\000\173\000\173\000\173\000\
\000\000\173\000\000\000\000\000\000\000\173\000\000\000\173\000\
\173\000\173\000\173\000\173\000\173\000\173\000\173\000\173\000\
\173\000\000\000\173\000\173\000\173\000\000\000\000\000\173\000\
\173\000\173\000\000\000\000\000\173\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\171\000\000\000\000\000\000\000\000\000\173\000\173\000\171\000\
\173\000\173\000\000\000\000\000\171\000\000\000\171\000\000\000\
\171\000\171\000\000\000\000\000\000\000\000\000\171\000\000\000\
\171\000\171\000\171\000\000\000\000\000\171\000\000\000\171\000\
\171\000\171\000\171\000\171\000\000\000\000\000\000\000\000\000\
\000\000\171\000\000\000\171\000\171\000\171\000\171\000\171\000\
\171\000\171\000\171\000\171\000\171\000\000\000\171\000\171\000\
\171\000\000\000\000\000\171\000\171\000\171\000\000\000\000\000\
\171\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\169\000\000\000\000\000\000\000\
\000\000\171\000\171\000\169\000\171\000\171\000\000\000\000\000\
\169\000\000\000\169\000\000\000\169\000\169\000\000\000\000\000\
\000\000\000\000\169\000\000\000\169\000\169\000\169\000\000\000\
\000\000\169\000\000\000\169\000\169\000\169\000\169\000\169\000\
\000\000\000\000\000\000\000\000\000\000\169\000\000\000\169\000\
\169\000\169\000\169\000\169\000\169\000\169\000\169\000\169\000\
\169\000\000\000\169\000\169\000\169\000\000\000\000\000\169\000\
\169\000\169\000\165\000\000\000\169\000\000\000\000\000\000\000\
\000\000\165\000\000\000\000\000\000\000\000\000\165\000\000\000\
\165\000\000\000\165\000\165\000\000\000\169\000\169\000\000\000\
\169\000\169\000\165\000\165\000\165\000\000\000\000\000\165\000\
\000\000\165\000\165\000\165\000\165\000\165\000\000\000\000\000\
\000\000\000\000\000\000\165\000\000\000\165\000\165\000\165\000\
\165\000\165\000\165\000\165\000\165\000\165\000\165\000\000\000\
\165\000\165\000\165\000\000\000\000\000\165\000\165\000\165\000\
\167\000\000\000\165\000\000\000\000\000\000\000\000\000\167\000\
\000\000\000\000\000\000\000\000\167\000\000\000\167\000\000\000\
\167\000\167\000\000\000\165\000\165\000\000\000\165\000\165\000\
\167\000\167\000\167\000\000\000\000\000\167\000\000\000\167\000\
\167\000\167\000\167\000\167\000\000\000\000\000\000\000\000\000\
\000\000\167\000\000\000\167\000\167\000\167\000\167\000\167\000\
\167\000\167\000\167\000\167\000\167\000\000\000\167\000\167\000\
\167\000\000\000\000\000\167\000\167\000\167\000\151\000\000\000\
\167\000\000\000\000\000\000\000\000\000\151\000\000\000\000\000\
\000\000\000\000\151\000\000\000\151\000\000\000\151\000\151\000\
\000\000\167\000\167\000\000\000\167\000\167\000\000\000\000\000\
\151\000\000\000\000\000\151\000\000\000\151\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\151\000\
\000\000\151\000\151\000\151\000\151\000\151\000\151\000\151\000\
\151\000\151\000\151\000\000\000\151\000\151\000\151\000\000\000\
\153\000\151\000\151\000\151\000\000\000\000\000\151\000\153\000\
\000\000\000\000\000\000\000\000\153\000\000\000\153\000\000\000\
\153\000\153\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\153\000\151\000\000\000\153\000\000\000\153\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\153\000\000\000\153\000\153\000\153\000\153\000\153\000\
\153\000\153\000\153\000\153\000\153\000\000\000\153\000\153\000\
\153\000\000\000\145\000\153\000\153\000\153\000\000\000\000\000\
\153\000\145\000\000\000\000\000\000\000\000\000\145\000\000\000\
\145\000\000\000\145\000\145\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\145\000\153\000\000\000\145\000\
\000\000\145\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\145\000\000\000\145\000\145\000\145\000\
\145\000\145\000\145\000\145\000\145\000\145\000\145\000\000\000\
\145\000\145\000\145\000\147\000\000\000\145\000\145\000\145\000\
\000\000\000\000\147\000\000\000\000\000\000\000\000\000\147\000\
\000\000\147\000\000\000\147\000\147\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\147\000\000\000\145\000\
\147\000\000\000\147\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\147\000\000\000\147\000\147\000\
\147\000\147\000\147\000\147\000\147\000\147\000\147\000\147\000\
\000\000\147\000\147\000\147\000\000\000\000\000\147\000\147\000\
\147\000\038\000\000\000\039\000\040\000\041\000\042\000\043\000\
\044\000\000\000\000\000\000\000\000\000\045\000\000\000\046\000\
\000\000\000\000\000\000\000\000\047\000\048\000\000\000\000\000\
\147\000\000\000\000\000\000\000\000\000\014\001\000\000\049\000\
\050\000\000\000\000\000\000\000\000\000\038\000\051\000\039\000\
\040\000\041\000\042\000\043\000\044\000\000\000\000\000\000\000\
\000\000\045\000\000\000\046\000\000\000\000\000\000\000\000\000\
\047\000\048\000\000\000\000\000\000\000\000\000\015\001\000\000\
\000\000\000\000\000\000\049\000\050\000\113\000\000\000\000\000\
\000\000\000\000\051\000\038\000\000\000\039\000\040\000\041\000\
\042\000\043\000\044\000\000\000\000\000\052\000\053\000\045\000\
\000\000\046\000\000\000\000\000\000\000\000\000\047\000\048\000\
\038\000\000\000\009\001\040\000\041\000\042\000\043\000\044\000\
\000\000\049\000\050\000\000\000\045\000\010\001\046\000\000\000\
\051\000\000\000\000\000\047\000\048\000\000\000\000\000\000\000\
\000\000\052\000\053\000\000\000\000\000\000\000\049\000\050\000\
\000\000\000\000\000\000\000\000\000\000\051\000\000\000\000\000\
\000\000\038\000\231\000\039\000\040\000\041\000\042\000\043\000\
\044\000\000\000\000\000\000\000\000\000\045\000\000\000\046\000\
\000\000\000\000\000\000\000\000\047\000\048\000\000\000\052\000\
\053\000\000\000\000\000\000\000\000\000\000\000\000\000\049\000\
\050\000\000\000\000\000\000\000\000\000\000\000\051\000\000\000\
\000\000\000\000\000\000\000\000\052\000\053\000\038\000\000\000\
\039\000\040\000\041\000\042\000\043\000\044\000\000\000\000\000\
\000\000\000\000\045\000\000\000\046\000\000\000\000\000\000\000\
\069\001\047\000\048\000\000\000\038\000\000\000\039\000\040\000\
\041\000\042\000\043\000\044\000\049\000\050\000\000\000\000\000\
\045\000\000\000\046\000\051\000\000\000\052\000\053\000\047\000\
\048\000\038\000\000\000\039\000\040\000\041\000\042\000\043\000\
\044\000\000\000\049\000\050\000\000\000\045\000\000\000\046\000\
\000\000\051\000\000\000\086\001\047\000\048\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\049\000\
\050\000\000\000\000\000\000\000\000\000\000\000\051\000\000\000\
\000\000\126\001\052\000\053\000\000\000\000\000\000\000\038\000\
\000\000\009\001\040\000\041\000\042\000\043\000\044\000\000\000\
\000\000\000\000\000\000\045\000\000\000\046\000\000\000\000\000\
\052\000\053\000\047\000\048\000\038\000\000\000\039\000\040\000\
\041\000\042\000\043\000\044\000\000\000\049\000\050\000\000\000\
\045\000\000\000\046\000\000\000\051\000\052\000\053\000\047\000\
\048\000\038\000\000\000\039\000\040\000\041\000\042\000\043\000\
\044\000\000\000\049\000\050\000\000\000\045\000\000\000\046\000\
\000\000\051\000\000\000\000\000\047\000\048\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\049\000\
\050\000\000\000\000\000\000\000\000\000\000\000\051\000\000\000\
\220\000\220\000\220\000\052\000\053\000\220\000\000\000\220\000\
\220\000\220\000\220\000\220\000\220\000\220\000\220\000\000\000\
\220\000\220\000\000\000\000\000\000\000\220\000\220\000\220\000\
\220\000\053\000\220\000\220\000\220\000\000\000\220\000\220\000\
\000\000\000\000\000\000\140\000\000\000\000\000\000\000\000\000\
\000\000\000\000\140\000\000\000\000\000\000\000\243\000\140\000\
\000\000\140\000\000\000\140\000\140\000\220\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\140\000\000\000\000\000\
\140\000\000\000\140\000\000\000\000\000\000\000\220\000\220\000\
\000\000\220\000\220\000\000\000\140\000\000\000\140\000\140\000\
\140\000\140\000\140\000\140\000\140\000\140\000\140\000\140\000\
\000\000\140\000\140\000\140\000\143\000\000\000\140\000\140\000\
\140\000\000\000\000\000\143\000\000\000\000\000\000\000\000\000\
\143\000\000\000\143\000\000\000\143\000\143\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\143\000\000\000\
\000\000\143\000\000\000\143\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\143\000\000\000\143\000\
\143\000\143\000\143\000\143\000\143\000\143\000\143\000\143\000\
\143\000\000\000\143\000\143\000\143\000\000\000\000\000\143\000\
\143\000\143\000\038\000\000\000\039\000\040\000\041\000\042\000\
\043\000\044\000\000\000\000\000\000\000\000\000\045\000\000\000\
\046\000\000\000\000\000\000\000\000\000\047\000\048\000\197\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\049\000\050\000\000\000\000\000\000\000\000\000\000\000\051\000\
\198\000\199\000\200\000\201\000\202\000\203\000\204\000\205\000\
\206\000\207\000\000\000\208\000\209\000\210\000"

let yycheck = "\007\000\
\095\000\084\000\053\000\082\000\083\000\119\000\009\001\009\001\
\103\000\013\001\019\001\003\001\002\001\002\001\047\000\048\000\
\009\001\033\001\051\000\009\001\009\001\013\001\012\001\012\001\
\002\001\018\001\019\001\043\001\001\000\002\000\022\001\009\001\
\002\001\002\000\012\001\064\001\002\001\002\001\002\001\009\001\
\022\001\018\001\050\000\009\001\009\001\009\001\012\001\012\001\
\012\001\016\001\042\001\130\000\131\000\132\000\133\000\134\000\
\135\000\136\000\137\000\063\001\042\001\064\001\064\001\002\001\
\014\001\009\001\043\001\014\001\076\000\098\001\009\001\063\001\
\002\001\012\001\064\001\064\001\043\001\018\001\014\001\094\001\
\049\000\089\000\177\000\016\001\092\000\018\001\064\001\014\001\
\016\001\082\001\018\001\018\001\100\000\043\001\064\001\098\001\
\043\001\014\001\064\001\064\001\064\001\196\000\043\001\040\001\
\041\001\074\000\075\000\043\001\098\001\098\001\043\001\016\001\
\081\000\164\000\122\000\043\001\043\001\095\001\014\001\214\000\
\098\001\090\000\155\000\156\000\157\000\064\001\043\001\063\001\
\098\001\095\001\095\001\014\001\098\001\098\001\098\001\018\001\
\063\001\001\001\043\001\003\001\004\001\005\001\006\001\007\001\
\008\001\016\001\063\001\043\001\014\001\013\001\014\001\015\001\
\160\000\014\001\147\000\148\000\020\001\021\001\008\001\098\001\
\043\001\169\000\170\000\095\001\243\000\107\001\245\000\031\001\
\032\001\016\001\003\001\018\001\043\001\003\001\038\001\020\001\
\021\001\043\001\002\001\013\001\024\001\015\001\043\001\013\001\
\014\001\039\001\025\001\003\001\016\001\022\001\018\001\016\001\
\022\001\018\001\136\001\029\001\043\001\013\001\037\001\038\001\
\026\001\027\001\041\001\030\001\027\001\063\001\022\001\025\001\
\034\001\035\001\036\001\037\001\042\001\087\001\222\000\043\001\
\003\001\225\000\043\001\003\001\003\001\085\001\086\001\231\000\
\066\001\233\000\042\001\235\000\197\000\003\001\013\001\200\000\
\201\000\202\000\203\000\204\000\205\000\206\000\207\000\208\000\
\209\000\210\000\044\001\016\001\016\001\018\001\018\001\003\001\
\022\001\016\001\016\001\018\001\018\001\016\001\009\001\018\001\
\009\001\083\001\084\001\003\001\086\001\100\001\063\001\015\001\
\019\001\064\001\019\001\031\001\009\001\021\001\043\001\043\001\
\111\001\009\001\026\001\114\001\043\001\043\001\019\001\033\001\
\043\001\061\001\034\001\019\001\009\001\009\001\009\001\039\001\
\009\001\043\001\018\001\130\001\151\000\152\000\019\001\019\001\
\019\001\003\001\019\001\018\001\001\001\063\001\003\001\004\001\
\005\001\006\001\007\001\008\001\028\001\022\001\003\001\150\001\
\013\001\083\001\015\001\016\001\029\001\069\001\018\001\020\001\
\021\001\001\001\013\001\003\001\004\001\005\001\006\001\007\001\
\008\001\081\001\031\001\032\001\084\001\013\001\086\001\015\001\
\088\001\038\001\009\001\091\001\020\001\021\001\029\001\009\001\
\009\001\009\001\045\000\046\000\019\001\022\001\023\001\031\001\
\032\001\019\001\019\001\019\001\083\001\030\001\038\001\018\001\
\095\001\096\001\097\001\031\001\032\001\045\001\046\001\083\001\
\082\001\018\001\018\001\014\001\016\001\125\001\126\001\033\001\
\018\001\018\001\003\001\018\001\062\001\133\001\028\001\135\001\
\085\001\086\001\138\001\067\001\068\001\069\001\070\001\071\001\
\072\001\145\001\029\001\018\001\076\001\011\001\078\001\079\001\
\080\001\095\001\082\001\095\001\028\001\085\001\086\001\097\001\
\088\001\089\001\090\001\091\001\092\001\093\001\001\001\014\001\
\003\001\004\001\005\001\006\001\007\001\008\001\014\001\002\001\
\029\001\062\001\013\001\016\001\015\001\014\001\009\001\022\001\
\018\001\020\001\021\001\014\001\018\001\018\001\003\001\014\001\
\019\001\062\001\095\001\012\001\031\001\032\001\003\001\009\001\
\002\001\028\001\083\001\038\001\031\001\063\001\063\001\088\000\
\012\001\141\000\045\001\046\001\143\000\025\000\234\000\024\001\
\145\000\063\001\045\001\046\001\047\001\048\001\049\001\050\001\
\051\001\052\001\053\001\054\001\194\000\056\001\057\001\058\001\
\067\001\068\001\234\000\070\001\063\001\072\001\096\000\197\000\
\033\001\076\001\101\000\042\001\079\001\080\001\162\000\082\001\
\136\001\005\001\085\001\086\001\002\001\088\001\089\001\090\001\
\091\001\006\001\140\000\009\001\247\000\249\000\248\000\013\001\
\014\001\015\001\016\001\153\000\018\001\019\001\020\001\021\001\
\022\001\023\001\024\001\025\001\026\001\027\001\028\001\029\001\
\030\001\031\001\149\000\033\001\034\001\035\001\036\001\037\001\
\158\000\039\001\040\001\041\001\166\000\043\001\044\001\045\001\
\046\001\047\001\048\001\049\001\050\001\051\001\052\001\053\001\
\054\001\167\000\056\001\057\001\058\001\173\000\044\000\061\001\
\062\001\063\001\225\000\084\001\066\001\129\001\091\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\002\001\255\255\255\255\255\255\255\255\083\001\084\001\009\001\
\086\001\087\001\255\255\255\255\014\001\255\255\016\001\255\255\
\018\001\019\001\020\001\021\001\022\001\023\001\024\001\025\001\
\026\001\027\001\028\001\255\255\030\001\031\001\255\255\033\001\
\034\001\035\001\036\001\037\001\255\255\039\001\040\001\041\001\
\255\255\043\001\044\001\045\001\046\001\047\001\048\001\049\001\
\050\001\051\001\052\001\053\001\054\001\255\255\056\001\057\001\
\058\001\255\255\255\255\061\001\062\001\063\001\255\255\255\255\
\066\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\002\001\255\255\255\255\255\255\
\255\255\083\001\084\001\009\001\086\001\087\001\255\255\255\255\
\014\001\255\255\016\001\255\255\018\001\019\001\020\001\021\001\
\022\001\023\001\024\001\025\001\026\001\027\001\028\001\255\255\
\030\001\031\001\255\255\033\001\034\001\035\001\036\001\037\001\
\255\255\039\001\040\001\041\001\255\255\043\001\044\001\045\001\
\046\001\047\001\048\001\049\001\050\001\051\001\052\001\053\001\
\054\001\255\255\056\001\057\001\058\001\255\255\255\255\061\001\
\062\001\063\001\255\255\255\255\066\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\002\001\255\255\255\255\255\255\255\255\083\001\084\001\009\001\
\086\001\087\001\255\255\255\255\014\001\255\255\016\001\255\255\
\018\001\019\001\020\001\021\001\022\001\023\001\024\001\025\001\
\026\001\027\001\028\001\255\255\030\001\031\001\255\255\033\001\
\034\001\035\001\036\001\037\001\255\255\039\001\040\001\041\001\
\255\255\043\001\255\255\045\001\046\001\047\001\048\001\049\001\
\050\001\051\001\052\001\053\001\054\001\255\255\056\001\057\001\
\058\001\255\255\255\255\061\001\062\001\063\001\255\255\255\255\
\066\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\002\001\255\255\255\255\255\255\
\255\255\083\001\084\001\009\001\086\001\087\001\255\255\255\255\
\014\001\255\255\016\001\255\255\018\001\019\001\020\001\021\001\
\022\001\023\001\024\001\025\001\026\001\027\001\028\001\255\255\
\030\001\031\001\255\255\033\001\034\001\035\001\036\001\037\001\
\255\255\039\001\040\001\041\001\255\255\043\001\255\255\045\001\
\046\001\047\001\048\001\049\001\050\001\051\001\052\001\053\001\
\054\001\255\255\056\001\057\001\058\001\255\255\255\255\061\001\
\062\001\063\001\255\255\255\255\066\001\255\255\001\001\255\255\
\003\001\004\001\005\001\006\001\007\001\008\001\255\255\255\255\
\002\001\255\255\013\001\255\255\015\001\083\001\084\001\009\001\
\086\001\087\001\255\255\255\255\014\001\255\255\016\001\255\255\
\018\001\019\001\020\001\021\001\031\001\032\001\024\001\025\001\
\026\001\027\001\028\001\255\255\255\255\031\001\255\255\033\001\
\034\001\035\001\036\001\037\001\255\255\039\001\040\001\041\001\
\255\255\043\001\255\255\045\001\046\001\047\001\048\001\049\001\
\050\001\051\001\052\001\053\001\054\001\255\255\056\001\057\001\
\058\001\255\255\255\255\061\001\062\001\063\001\255\255\255\255\
\066\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\002\001\255\255\255\255\255\255\
\255\255\083\001\084\001\009\001\086\001\087\001\255\255\255\255\
\014\001\255\255\016\001\255\255\018\001\019\001\020\001\021\001\
\255\255\255\255\024\001\025\001\026\001\027\001\028\001\255\255\
\255\255\031\001\255\255\033\001\034\001\035\001\036\001\037\001\
\255\255\039\001\040\001\041\001\255\255\043\001\255\255\045\001\
\046\001\047\001\048\001\049\001\050\001\051\001\052\001\053\001\
\054\001\255\255\056\001\057\001\058\001\255\255\255\255\061\001\
\062\001\063\001\255\255\255\255\066\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\002\001\255\255\255\255\255\255\255\255\083\001\084\001\009\001\
\086\001\087\001\255\255\255\255\014\001\255\255\016\001\255\255\
\018\001\019\001\255\255\255\255\255\255\255\255\024\001\025\001\
\026\001\027\001\028\001\255\255\255\255\031\001\255\255\033\001\
\034\001\035\001\036\001\037\001\255\255\039\001\040\001\041\001\
\255\255\043\001\255\255\045\001\046\001\047\001\048\001\049\001\
\050\001\051\001\052\001\053\001\054\001\255\255\056\001\057\001\
\058\001\255\255\255\255\061\001\062\001\063\001\255\255\255\255\
\066\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\002\001\255\255\255\255\255\255\
\255\255\083\001\084\001\009\001\086\001\087\001\255\255\255\255\
\014\001\255\255\016\001\255\255\018\001\019\001\255\255\255\255\
\255\255\255\255\024\001\025\001\026\001\027\001\028\001\255\255\
\255\255\031\001\255\255\033\001\034\001\035\001\036\001\037\001\
\255\255\039\001\040\001\041\001\255\255\043\001\255\255\045\001\
\046\001\047\001\048\001\049\001\050\001\051\001\052\001\053\001\
\054\001\255\255\056\001\057\001\058\001\255\255\255\255\061\001\
\062\001\063\001\255\255\255\255\066\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\002\001\255\255\255\255\255\255\255\255\083\001\084\001\009\001\
\086\001\087\001\255\255\255\255\014\001\255\255\016\001\255\255\
\018\001\019\001\255\255\255\255\255\255\255\255\024\001\025\001\
\026\001\027\001\028\001\255\255\255\255\031\001\255\255\033\001\
\034\001\035\001\036\001\037\001\255\255\039\001\255\255\255\255\
\255\255\043\001\255\255\045\001\046\001\047\001\048\001\049\001\
\050\001\051\001\052\001\053\001\054\001\255\255\056\001\057\001\
\058\001\255\255\255\255\061\001\062\001\063\001\255\255\255\255\
\066\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\002\001\255\255\255\255\255\255\
\255\255\083\001\084\001\009\001\086\001\087\001\255\255\255\255\
\014\001\255\255\016\001\255\255\018\001\019\001\255\255\255\255\
\255\255\255\255\024\001\025\001\026\001\027\001\028\001\255\255\
\255\255\031\001\255\255\033\001\034\001\035\001\036\001\037\001\
\255\255\039\001\255\255\255\255\255\255\043\001\255\255\045\001\
\046\001\047\001\048\001\049\001\050\001\051\001\052\001\053\001\
\054\001\255\255\056\001\057\001\058\001\255\255\255\255\061\001\
\062\001\063\001\255\255\255\255\066\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\002\001\255\255\255\255\255\255\255\255\083\001\084\001\009\001\
\086\001\087\001\255\255\255\255\014\001\255\255\016\001\255\255\
\018\001\019\001\255\255\255\255\255\255\255\255\024\001\255\255\
\026\001\027\001\028\001\255\255\255\255\031\001\255\255\033\001\
\034\001\035\001\036\001\037\001\255\255\039\001\255\255\255\255\
\255\255\043\001\255\255\045\001\046\001\047\001\048\001\049\001\
\050\001\051\001\052\001\053\001\054\001\255\255\056\001\057\001\
\058\001\255\255\255\255\061\001\062\001\063\001\255\255\255\255\
\066\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\002\001\255\255\255\255\255\255\
\255\255\083\001\084\001\009\001\086\001\087\001\255\255\255\255\
\014\001\255\255\016\001\255\255\018\001\019\001\255\255\255\255\
\255\255\255\255\024\001\255\255\026\001\027\001\028\001\255\255\
\255\255\031\001\255\255\033\001\034\001\035\001\036\001\037\001\
\255\255\039\001\255\255\255\255\255\255\043\001\255\255\045\001\
\046\001\047\001\048\001\049\001\050\001\051\001\052\001\053\001\
\054\001\255\255\056\001\057\001\058\001\255\255\255\255\061\001\
\062\001\063\001\255\255\255\255\066\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\002\001\255\255\255\255\255\255\255\255\083\001\084\001\009\001\
\086\001\087\001\255\255\255\255\014\001\255\255\016\001\255\255\
\018\001\019\001\255\255\255\255\255\255\255\255\024\001\255\255\
\026\001\027\001\028\001\255\255\255\255\031\001\255\255\033\001\
\034\001\035\001\036\001\037\001\255\255\255\255\255\255\255\255\
\255\255\043\001\255\255\045\001\046\001\047\001\048\001\049\001\
\050\001\051\001\052\001\053\001\054\001\255\255\056\001\057\001\
\058\001\255\255\255\255\061\001\062\001\063\001\255\255\255\255\
\066\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\002\001\255\255\255\255\255\255\
\255\255\083\001\084\001\009\001\086\001\087\001\255\255\255\255\
\014\001\255\255\016\001\255\255\018\001\019\001\255\255\255\255\
\255\255\255\255\024\001\255\255\026\001\027\001\028\001\255\255\
\255\255\031\001\255\255\033\001\034\001\035\001\036\001\037\001\
\255\255\255\255\255\255\255\255\255\255\043\001\255\255\045\001\
\046\001\047\001\048\001\049\001\050\001\051\001\052\001\053\001\
\054\001\255\255\056\001\057\001\058\001\255\255\255\255\061\001\
\062\001\063\001\002\001\255\255\066\001\255\255\255\255\255\255\
\255\255\009\001\255\255\255\255\255\255\255\255\014\001\255\255\
\016\001\255\255\018\001\019\001\255\255\083\001\084\001\255\255\
\086\001\087\001\026\001\027\001\028\001\255\255\255\255\031\001\
\255\255\033\001\034\001\035\001\036\001\037\001\255\255\255\255\
\255\255\255\255\255\255\043\001\255\255\045\001\046\001\047\001\
\048\001\049\001\050\001\051\001\052\001\053\001\054\001\255\255\
\056\001\057\001\058\001\255\255\255\255\061\001\062\001\063\001\
\002\001\255\255\066\001\255\255\255\255\255\255\255\255\009\001\
\255\255\255\255\255\255\255\255\014\001\255\255\016\001\255\255\
\018\001\019\001\255\255\083\001\084\001\255\255\086\001\087\001\
\026\001\027\001\028\001\255\255\255\255\031\001\255\255\033\001\
\034\001\035\001\036\001\037\001\255\255\255\255\255\255\255\255\
\255\255\043\001\255\255\045\001\046\001\047\001\048\001\049\001\
\050\001\051\001\052\001\053\001\054\001\255\255\056\001\057\001\
\058\001\255\255\255\255\061\001\062\001\063\001\002\001\255\255\
\066\001\255\255\255\255\255\255\255\255\009\001\255\255\255\255\
\255\255\255\255\014\001\255\255\016\001\255\255\018\001\019\001\
\255\255\083\001\084\001\255\255\086\001\087\001\255\255\255\255\
\028\001\255\255\255\255\031\001\255\255\033\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\043\001\
\255\255\045\001\046\001\047\001\048\001\049\001\050\001\051\001\
\052\001\053\001\054\001\255\255\056\001\057\001\058\001\255\255\
\002\001\061\001\062\001\063\001\255\255\255\255\066\001\009\001\
\255\255\255\255\255\255\255\255\014\001\255\255\016\001\255\255\
\018\001\019\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\028\001\087\001\255\255\031\001\255\255\033\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\043\001\255\255\045\001\046\001\047\001\048\001\049\001\
\050\001\051\001\052\001\053\001\054\001\255\255\056\001\057\001\
\058\001\255\255\002\001\061\001\062\001\063\001\255\255\255\255\
\066\001\009\001\255\255\255\255\255\255\255\255\014\001\255\255\
\016\001\255\255\018\001\019\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\028\001\087\001\255\255\031\001\
\255\255\033\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\043\001\255\255\045\001\046\001\047\001\
\048\001\049\001\050\001\051\001\052\001\053\001\054\001\255\255\
\056\001\057\001\058\001\002\001\255\255\061\001\062\001\063\001\
\255\255\255\255\009\001\255\255\255\255\255\255\255\255\014\001\
\255\255\016\001\255\255\018\001\019\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\028\001\255\255\087\001\
\031\001\255\255\033\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\043\001\255\255\045\001\046\001\
\047\001\048\001\049\001\050\001\051\001\052\001\053\001\054\001\
\255\255\056\001\057\001\058\001\255\255\255\255\061\001\062\001\
\063\001\001\001\255\255\003\001\004\001\005\001\006\001\007\001\
\008\001\255\255\255\255\255\255\255\255\013\001\255\255\015\001\
\255\255\255\255\255\255\255\255\020\001\021\001\255\255\255\255\
\087\001\255\255\255\255\255\255\255\255\029\001\255\255\031\001\
\032\001\255\255\255\255\255\255\255\255\001\001\038\001\003\001\
\004\001\005\001\006\001\007\001\008\001\255\255\255\255\255\255\
\255\255\013\001\255\255\015\001\255\255\255\255\255\255\255\255\
\020\001\021\001\255\255\255\255\255\255\255\255\062\001\255\255\
\255\255\255\255\255\255\031\001\032\001\033\001\255\255\255\255\
\255\255\255\255\038\001\001\001\255\255\003\001\004\001\005\001\
\006\001\007\001\008\001\255\255\255\255\085\001\086\001\013\001\
\255\255\015\001\255\255\255\255\255\255\255\255\020\001\021\001\
\001\001\255\255\003\001\004\001\005\001\006\001\007\001\008\001\
\255\255\031\001\032\001\255\255\013\001\014\001\015\001\255\255\
\038\001\255\255\255\255\020\001\021\001\255\255\255\255\255\255\
\255\255\085\001\086\001\255\255\255\255\255\255\031\001\032\001\
\255\255\255\255\255\255\255\255\255\255\038\001\255\255\255\255\
\255\255\001\001\064\001\003\001\004\001\005\001\006\001\007\001\
\008\001\255\255\255\255\255\255\255\255\013\001\255\255\015\001\
\255\255\255\255\255\255\255\255\020\001\021\001\255\255\085\001\
\086\001\255\255\255\255\255\255\255\255\255\255\255\255\031\001\
\032\001\255\255\255\255\255\255\255\255\255\255\038\001\255\255\
\255\255\255\255\255\255\255\255\085\001\086\001\001\001\255\255\
\003\001\004\001\005\001\006\001\007\001\008\001\255\255\255\255\
\255\255\255\255\013\001\255\255\015\001\255\255\255\255\255\255\
\064\001\020\001\021\001\255\255\001\001\255\255\003\001\004\001\
\005\001\006\001\007\001\008\001\031\001\032\001\255\255\255\255\
\013\001\255\255\015\001\038\001\255\255\085\001\086\001\020\001\
\021\001\001\001\255\255\003\001\004\001\005\001\006\001\007\001\
\008\001\255\255\031\001\032\001\255\255\013\001\255\255\015\001\
\255\255\038\001\255\255\062\001\020\001\021\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\031\001\
\032\001\255\255\255\255\255\255\255\255\255\255\038\001\255\255\
\255\255\062\001\085\001\086\001\255\255\255\255\255\255\001\001\
\255\255\003\001\004\001\005\001\006\001\007\001\008\001\255\255\
\255\255\255\255\255\255\013\001\255\255\015\001\255\255\255\255\
\085\001\086\001\020\001\021\001\001\001\255\255\003\001\004\001\
\005\001\006\001\007\001\008\001\255\255\031\001\032\001\255\255\
\013\001\255\255\015\001\255\255\038\001\085\001\086\001\020\001\
\021\001\001\001\255\255\003\001\004\001\005\001\006\001\007\001\
\008\001\255\255\031\001\032\001\255\255\013\001\255\255\015\001\
\255\255\038\001\255\255\255\255\020\001\021\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\031\001\
\032\001\255\255\255\255\255\255\255\255\255\255\038\001\255\255\
\013\001\014\001\015\001\085\001\086\001\018\001\255\255\020\001\
\021\001\022\001\023\001\024\001\025\001\026\001\027\001\255\255\
\029\001\030\001\255\255\255\255\255\255\034\001\035\001\036\001\
\037\001\086\001\039\001\040\001\041\001\255\255\043\001\044\001\
\255\255\255\255\255\255\002\001\255\255\255\255\255\255\255\255\
\255\255\255\255\009\001\255\255\255\255\255\255\086\001\014\001\
\255\255\016\001\255\255\018\001\019\001\066\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\028\001\255\255\255\255\
\031\001\255\255\033\001\255\255\255\255\255\255\083\001\084\001\
\255\255\086\001\087\001\255\255\043\001\255\255\045\001\046\001\
\047\001\048\001\049\001\050\001\051\001\052\001\053\001\054\001\
\255\255\056\001\057\001\058\001\002\001\255\255\061\001\062\001\
\063\001\255\255\255\255\009\001\255\255\255\255\255\255\255\255\
\014\001\255\255\016\001\255\255\018\001\019\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\028\001\255\255\
\255\255\031\001\255\255\033\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\043\001\255\255\045\001\
\046\001\047\001\048\001\049\001\050\001\051\001\052\001\053\001\
\054\001\255\255\056\001\057\001\058\001\255\255\255\255\061\001\
\062\001\063\001\001\001\255\255\003\001\004\001\005\001\006\001\
\007\001\008\001\255\255\255\255\255\255\255\255\013\001\255\255\
\015\001\255\255\255\255\255\255\255\255\020\001\021\001\028\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\031\001\032\001\255\255\255\255\255\255\255\255\255\255\038\001\
\045\001\046\001\047\001\048\001\049\001\050\001\051\001\052\001\
\053\001\054\001\255\255\056\001\057\001\058\001"

let yyact = [|
  (fun _ -> failwith "parser")
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : int * string) in
	Obj.repr((
# 87 "py_parse.mly"
            Empty ) : 'newline_or_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'stmt) in
	Obj.repr((
# 88 "py_parse.mly"
           _1 ) : 'newline_or_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : 'newline_or_stmt) in
	let _2 = (peek_val parser_env 0 : 'newline_or_stmt_seq) in
	Obj.repr((
# 91 "py_parse.mly"
                                        _1 :: _2 ) : 'newline_or_stmt_seq))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'newline_or_stmt) in
	Obj.repr((
# 92 "py_parse.mly"
                      [_1] ) : 'newline_or_stmt_seq))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : 'newline_or_stmt_seq) in
	Obj.repr((
# 95 "py_parse.mly"
                                   Suite _1 ) : Py_types.statement_t))
; (fun parser_env ->
	Obj.repr((
# 96 "py_parse.mly"
                Empty ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : Py_types.expr_t) in
	Obj.repr((
# 99 "py_parse.mly"
                        _1 ) : Py_types.expr_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 4 : Py_types.sref) in
	let _3 = (peek_val parser_env 2 : string) in
	let _4 = (peek_val parser_env 1 : 'parameters) in
	let _5 = (peek_val parser_env 0 : 'colon_suite) in
	Obj.repr((
# 102 "py_parse.mly"
                                        Def (_1, _3, _4, _5) ) : Py_types.statement_t))
; (fun parser_env ->
	let _2 = (peek_val parser_env 1 : 'varargslist) in
	Obj.repr((
# 105 "py_parse.mly"
                           _2 ) : 'parameters))
; (fun parser_env ->
	let _2 = (peek_val parser_env 2 : 'varargslist) in
	Obj.repr((
# 106 "py_parse.mly"
                                            _2 ) : 'parameters))
; (fun parser_env ->
	Obj.repr((
# 107 "py_parse.mly"
                [], NoStarParam, NoStarStarParam ) : 'parameters))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : 'fpdef_dflts) in
	let _3 = (peek_val parser_env 0 : 'starargs) in
	Obj.repr((
# 110 "py_parse.mly"
                                 _1, fst _3, snd _3 ) : 'varargslist))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'fpdef_dflts) in
	Obj.repr((
# 111 "py_parse.mly"
                  _1, NoStarParam, NoStarStarParam ) : 'varargslist))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'starargs) in
	Obj.repr((
# 112 "py_parse.mly"
                [], fst _1, snd _1 ) : 'varargslist))
; (fun parser_env ->
	let _2 = (peek_val parser_env 4 : string) in
	let _6 = (peek_val parser_env 0 : string) in
	Obj.repr((
# 116 "py_parse.mly"
                                   StarParam _2, StarStarParam _6 ) : 'starargs))
; (fun parser_env ->
	let _2 = (peek_val parser_env 3 : string) in
	let _5 = (peek_val parser_env 0 : string) in
	Obj.repr((
# 117 "py_parse.mly"
                                      StarParam _2, StarStarParam _5 ) : 'starargs))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : string) in
	Obj.repr((
# 118 "py_parse.mly"
                StarParam _2, NoStarStarParam ) : 'starargs))
; (fun parser_env ->
	let _3 = (peek_val parser_env 0 : string) in
	Obj.repr((
# 119 "py_parse.mly"
                     NoStarParam, StarStarParam _3) : 'starargs))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : string) in
	Obj.repr((
# 120 "py_parse.mly"
                      NoStarParam, StarStarParam _2) : 'starargs))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : string) in
	Obj.repr((
# 124 "py_parse.mly"
         Param _1 ) : 'fpdef))
; (fun parser_env ->
	let _2 = (peek_val parser_env 1 : 'fplist) in
	Obj.repr((
# 125 "py_parse.mly"
                       Paramtuple _2 ) : 'fpdef))
; (fun parser_env ->
	let _2 = (peek_val parser_env 2 : 'fplist) in
	Obj.repr((
# 126 "py_parse.mly"
                                      Paramtuple _2 ) : 'fpdef))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : 'fpdef) in
	let _3 = (peek_val parser_env 0 : 'fplist) in
	Obj.repr((
# 128 "py_parse.mly"
                       _1::_3 ) : 'fplist))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'fpdef) in
	Obj.repr((
# 129 "py_parse.mly"
            [_1] ) : 'fplist))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : 'fpdef) in
	let _3 = (peek_val parser_env 0 : 'test) in
	Obj.repr((
# 133 "py_parse.mly"
                     Parameter2 ( _1, _3 ) ) : 'fpdef_dflt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'fpdef) in
	Obj.repr((
# 134 "py_parse.mly"
            Parameter1 _1 ) : 'fpdef_dflt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : 'fpdef_dflts) in
	let _3 = (peek_val parser_env 0 : 'fpdef_dflt) in
	Obj.repr((
# 138 "py_parse.mly"
                                 List.concat [_1; [_3]] ) : 'fpdef_dflts))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'fpdef_dflt) in
	Obj.repr((
# 139 "py_parse.mly"
                 [_1] ) : 'fpdef_dflts))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'simple_stmt) in
	Obj.repr((
# 142 "py_parse.mly"
                 Suite [_1] ) : 'stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'compound_stmt) in
	Obj.repr((
# 143 "py_parse.mly"
                    _1 ) : 'stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : statement_t) in
	let _3 = (peek_val parser_env 0 : 'small_list) in
	Obj.repr((
# 146 "py_parse.mly"
                               _1 :: _3 ) : 'small_list))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : statement_t) in
	Obj.repr((
# 147 "py_parse.mly"
                 [_1] ) : 'small_list))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : 'small_list) in
	let _2 = (peek_val parser_env 0 : int * string) in
	Obj.repr((
# 150 "py_parse.mly"
                       Suite _1 ) : 'simple_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'assign_stmt) in
	Obj.repr((
# 153 "py_parse.mly"
                  _1) : statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : Py_types.statement_t) in
	Obj.repr((
# 154 "py_parse.mly"
                  _1) : statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : Py_types.statement_t) in
	Obj.repr((
# 155 "py_parse.mly"
                  _1) : statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : Py_types.statement_t) in
	Obj.repr((
# 156 "py_parse.mly"
                  _1) : statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : Py_types.statement_t) in
	Obj.repr((
# 157 "py_parse.mly"
                  _1) : statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : Py_types.statement_t) in
	Obj.repr((
# 158 "py_parse.mly"
                  _1) : statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : Py_types.statement_t) in
	Obj.repr((
# 159 "py_parse.mly"
                  _1) : statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : Py_types.statement_t) in
	Obj.repr((
# 160 "py_parse.mly"
                  _1) : statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : Py_types.statement_t) in
	Obj.repr((
# 161 "py_parse.mly"
                  _1) : statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : Py_types.statement_t) in
	Obj.repr((
# 162 "py_parse.mly"
                  _1) : statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : Py_types.expr_t) in
	let _3 = (peek_val parser_env 0 : 'eqlist) in
	Obj.repr((
# 165 "py_parse.mly"
                            _1 :: _3 ) : 'eqlist))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : Py_types.expr_t) in
	let _3 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 166 "py_parse.mly"
                              [_1; _3] ) : 'eqlist))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : Py_types.expr_t) in
	let _3 = (peek_val parser_env 0 : 'eqlist) in
	Obj.repr((
# 168 "py_parse.mly"
                            _1 :: _3 ) : 'eqlist))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : Py_types.expr_t) in
	let _3 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 169 "py_parse.mly"
                              [_1; _3] ) : 'eqlist))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : Py_types.sref) in
	let _2 = (peek_val parser_env 0 : 'eqlist) in
	Obj.repr((
# 173 "py_parse.mly"
                 Assign (_1, _2) ) : 'assign_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 3 : Py_types.sref) in
	let _2 = (peek_val parser_env 2 : Py_types.expr_t) in
	let _4 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 174 "py_parse.mly"
                                      PlusEqual (_1, _2, _4) ) : 'assign_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 3 : Py_types.sref) in
	let _2 = (peek_val parser_env 2 : Py_types.expr_t) in
	let _4 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 175 "py_parse.mly"
                                       MinusEqual (_1, _2, _4) ) : 'assign_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 3 : Py_types.sref) in
	let _2 = (peek_val parser_env 2 : Py_types.expr_t) in
	let _4 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 176 "py_parse.mly"
                                      StarEqual (_1, _2, _4) ) : 'assign_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 3 : Py_types.sref) in
	let _2 = (peek_val parser_env 2 : Py_types.expr_t) in
	let _4 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 177 "py_parse.mly"
                                       SlashEqual (_1, _2, _4) ) : 'assign_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 3 : Py_types.sref) in
	let _2 = (peek_val parser_env 2 : Py_types.expr_t) in
	let _4 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 178 "py_parse.mly"
                                       AmperEqual (_1, _2, _4) ) : 'assign_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 3 : Py_types.sref) in
	let _2 = (peek_val parser_env 2 : Py_types.expr_t) in
	let _4 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 179 "py_parse.mly"
                                      VbarEqual (_1, _2, _4) ) : 'assign_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 3 : Py_types.sref) in
	let _2 = (peek_val parser_env 2 : Py_types.expr_t) in
	let _4 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 180 "py_parse.mly"
                                         PercentEqual (_1, _2, _4) ) : 'assign_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 3 : Py_types.sref) in
	let _2 = (peek_val parser_env 2 : Py_types.expr_t) in
	let _4 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 181 "py_parse.mly"
                                       CaretEqual (_1, _2, _4) ) : 'assign_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 3 : Py_types.sref) in
	let _2 = (peek_val parser_env 2 : Py_types.expr_t) in
	let _4 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 182 "py_parse.mly"
                                       ColonEqual (_1, _2, _4) ) : 'assign_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 3 : Py_types.sref) in
	let _2 = (peek_val parser_env 2 : Py_types.expr_t) in
	let _4 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 183 "py_parse.mly"
                                           LeftShiftEqual (_1, _2, _4) ) : 'assign_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 3 : Py_types.sref) in
	let _2 = (peek_val parser_env 2 : Py_types.expr_t) in
	let _4 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 184 "py_parse.mly"
                                            RightShiftEqual (_1, _2, _4) ) : 'assign_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : Py_types.sref) in
	let _2 = (peek_val parser_env 1 : Py_types.expr_t) in
	Obj.repr((
# 185 "py_parse.mly"
                            PlusPlus (_1, _2) ) : 'assign_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : Py_types.sref) in
	let _3 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 186 "py_parse.mly"
                            PlusPlus (_1, _3) ) : 'assign_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : Py_types.sref) in
	let _2 = (peek_val parser_env 1 : Py_types.expr_t) in
	Obj.repr((
# 187 "py_parse.mly"
                              MinusMinus (_1, _2) ) : 'assign_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : Py_types.sref) in
	let _3 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 188 "py_parse.mly"
                              MinusMinus (_1, _3) ) : 'assign_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : Py_types.sref) in
	let _2 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 191 "py_parse.mly"
                   Expr (_1,_2) ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : 'elist_ntc) in
	let _3 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 194 "py_parse.mly"
                           List.concat [_1; [_3]] ) : 'elist_ntc))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 195 "py_parse.mly"
           [_1] ) : 'elist_ntc))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : 'elist_ntc) in
	Obj.repr((
# 198 "py_parse.mly"
                               ListWithComma _1 ) : 'special_elist))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'elist_ntc) in
	Obj.repr((
# 199 "py_parse.mly"
                ListWithoutComma _1 ) : 'special_elist))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'special_elist) in
	Obj.repr((
# 202 "py_parse.mly"
                 
    match _1 with
    | ListWithComma xx -> PyTuple xx
    | ListWithoutComma [x] -> x
    | ListWithoutComma xx -> PyTuple xx
  ) : 'elist))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : 'testlist_ntc) in
	let _3 = (peek_val parser_env 0 : 'test) in
	Obj.repr((
# 210 "py_parse.mly"
                              List.concat [_1; [_3]] ) : 'testlist_ntc))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'test) in
	Obj.repr((
# 211 "py_parse.mly"
           [_1] ) : 'testlist_ntc))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : 'testlist_ntc) in
	Obj.repr((
# 214 "py_parse.mly"
                                  ListWithComma _1 ) : testlist_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'testlist_ntc) in
	Obj.repr((
# 215 "py_parse.mly"
                   ListWithoutComma _1 ) : testlist_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : testlist_t) in
	Obj.repr((
# 218 "py_parse.mly"
                    
    match _1 with
    | ListWithComma xx -> PyTuple xx
    | ListWithoutComma [x] -> x
    | ListWithoutComma xx -> PyTuple xx
  ) : Py_types.expr_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : Py_types.sref) in
	let _3 = (peek_val parser_env 0 : testlist_t) in
	Obj.repr((
# 226 "py_parse.mly"
                                 
    match _3 with
    | ListWithComma x -> PrintComma (_1, x)
    | ListWithoutComma x -> Print (_1, x)
    ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : Py_types.sref) in
	Obj.repr((
# 231 "py_parse.mly"
                Print (_1, []) ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : Py_types.sref) in
	let _3 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 234 "py_parse.mly"
                     Del (_1, _3) ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : Py_types.sref) in
	Obj.repr((
# 237 "py_parse.mly"
             Pass ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'break_stmt) in
	Obj.repr((
# 240 "py_parse.mly"
                _1 ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'continue_stmt) in
	Obj.repr((
# 241 "py_parse.mly"
                    _1 ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'return_stmt) in
	Obj.repr((
# 242 "py_parse.mly"
                   _1 ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'raise_stmt) in
	Obj.repr((
# 243 "py_parse.mly"
                  _1 ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : Py_types.sref) in
	Obj.repr((
# 246 "py_parse.mly"
              Break _1 ) : 'break_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : Py_types.sref) in
	Obj.repr((
# 249 "py_parse.mly"
                 Continue _1 ) : 'continue_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : Py_types.sref) in
	let _3 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 252 "py_parse.mly"
                        Return (_1, _3) ) : 'return_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : Py_types.sref) in
	Obj.repr((
# 253 "py_parse.mly"
                  Return (_1, PyNone) ) : 'return_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 6 : Py_types.sref) in
	let _3 = (peek_val parser_env 4 : 'test) in
	let _5 = (peek_val parser_env 2 : 'test) in
	let _7 = (peek_val parser_env 0 : 'test) in
	Obj.repr((
# 256 "py_parse.mly"
                                         Raise3 (_1, _3, _5, _7) ) : 'raise_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 4 : Py_types.sref) in
	let _3 = (peek_val parser_env 2 : 'test) in
	let _5 = (peek_val parser_env 0 : 'test) in
	Obj.repr((
# 257 "py_parse.mly"
                                Raise2 (_1, _3, _5) ) : 'raise_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : Py_types.sref) in
	let _3 = (peek_val parser_env 0 : 'test) in
	Obj.repr((
# 258 "py_parse.mly"
                     Raise1 (_1, _3) ) : 'raise_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : Py_types.sref) in
	Obj.repr((
# 259 "py_parse.mly"
               Raise0 _1 ) : 'raise_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : Py_types.sref) in
	let _3 = (peek_val parser_env 0 : 'dotted_name_list) in
	Obj.repr((
# 262 "py_parse.mly"
                                Import (_1, _3) ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 4 : Py_types.sref) in
	let _3 = (peek_val parser_env 2 : 'dotted_name) in
	let _5 = (peek_val parser_env 0 : 'name_list) in
	Obj.repr((
# 263 "py_parse.mly"
                                           ImportFrom (_1, _3, _5) ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 4 : Py_types.sref) in
	let _3 = (peek_val parser_env 2 : 'dotted_name) in
	Obj.repr((
# 264 "py_parse.mly"
                                      ImportAll (_1, _3) ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : string) in
	let _3 = (peek_val parser_env 0 : 'dotted_name) in
	Obj.repr((
# 267 "py_parse.mly"
                        _1 :: _3 ) : 'dotted_name))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : string) in
	Obj.repr((
# 268 "py_parse.mly"
                        [_1] ) : 'dotted_name))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : 'dotted_name) in
	let _3 = (peek_val parser_env 0 : 'dotted_name_list) in
	Obj.repr((
# 271 "py_parse.mly"
                                       _1 :: _3 ) : 'dotted_name_list))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'dotted_name) in
	Obj.repr((
# 272 "py_parse.mly"
                  [_1]) : 'dotted_name_list))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : string) in
	let _3 = (peek_val parser_env 0 : 'name_list) in
	Obj.repr((
# 275 "py_parse.mly"
                         _1 :: _3 ) : 'name_list))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : string) in
	Obj.repr((
# 276 "py_parse.mly"
           [_1] ) : 'name_list))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : Py_types.sref) in
	let _3 = (peek_val parser_env 0 : 'name_list) in
	Obj.repr((
# 279 "py_parse.mly"
                         Global (_1, _3) ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 6 : Py_types.sref) in
	let _3 = (peek_val parser_env 4 : Py_types.expr_t) in
	let _5 = (peek_val parser_env 2 : 'test) in
	let _7 = (peek_val parser_env 0 : 'test) in
	Obj.repr((
# 282 "py_parse.mly"
                                     Exec3 (_1, _3, _5, _7) ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 4 : Py_types.sref) in
	let _3 = (peek_val parser_env 2 : Py_types.expr_t) in
	let _5 = (peek_val parser_env 0 : 'test) in
	Obj.repr((
# 283 "py_parse.mly"
                            Exec2 (_1, _3, _5) ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : Py_types.sref) in
	let _3 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 284 "py_parse.mly"
                     Exec1 (_1, _3) ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 4 : Py_types.sref) in
	let _3 = (peek_val parser_env 2 : 'test) in
	let _5 = (peek_val parser_env 0 : 'test) in
	Obj.repr((
# 287 "py_parse.mly"
                               Assert2 (_1, _3, _5) ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : Py_types.sref) in
	let _3 = (peek_val parser_env 0 : 'test) in
	Obj.repr((
# 288 "py_parse.mly"
                     Assert1 (_1, _3) ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : Py_types.statement_t) in
	Obj.repr((
# 291 "py_parse.mly"
             _1 ) : 'compound_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : Py_types.statement_t) in
	Obj.repr((
# 292 "py_parse.mly"
                  _1 ) : 'compound_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : Py_types.statement_t) in
	Obj.repr((
# 293 "py_parse.mly"
                _1 ) : 'compound_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : Py_types.statement_t) in
	Obj.repr((
# 294 "py_parse.mly"
                _1 ) : 'compound_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : Py_types.statement_t) in
	Obj.repr((
# 295 "py_parse.mly"
               _1 ) : 'compound_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : Py_types.statement_t) in
	Obj.repr((
# 296 "py_parse.mly"
               _1 ) : 'compound_stmt))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : Py_types.sref) in
	let _2 = (peek_val parser_env 1 : 'test) in
	let _3 = (peek_val parser_env 0 : 'colon_suite) in
	Obj.repr((
# 299 "py_parse.mly"
                              _1, _2, _3 ) : 'elif_clause))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : Py_types.sref) in
	let _2 = (peek_val parser_env 0 : 'colon_suite) in
	Obj.repr((
# 302 "py_parse.mly"
                        _2) : 'else_clause))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : Py_types.sref) in
	let _2 = (peek_val parser_env 1 : 'test) in
	let _3 = (peek_val parser_env 0 : 'colon_suite) in
	Obj.repr((
# 305 "py_parse.mly"
                             _1, _2, _3 ) : 'if_clause))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : 'elif_clause) in
	let _2 = (peek_val parser_env 0 : 'elif_clauses) in
	Obj.repr((
# 308 "py_parse.mly"
                             _1 :: _2 ) : 'elif_clauses))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'elif_clause) in
	Obj.repr((
# 309 "py_parse.mly"
                  [_1] ) : 'elif_clauses))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : 'if_clause) in
	let _2 = (peek_val parser_env 0 : 'elif_clauses) in
	Obj.repr((
# 312 "py_parse.mly"
                           _1 :: _2 ) : 'ifelif_clause))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'if_clause) in
	Obj.repr((
# 313 "py_parse.mly"
                [_1]) : 'ifelif_clause))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : 'ifelif_clause) in
	let _2 = (peek_val parser_env 0 : 'else_clause) in
	Obj.repr((
# 316 "py_parse.mly"
                                If (_1, _2) ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'ifelif_clause) in
	Obj.repr((
# 317 "py_parse.mly"
                    If (_1, Empty) ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 5 : Py_types.sref) in
	let _3 = (peek_val parser_env 3 : 'test) in
	let _4 = (peek_val parser_env 2 : 'colon_suite) in
	let _5 = (peek_val parser_env 1 : Py_types.sref) in
	let _6 = (peek_val parser_env 0 : 'colon_suite) in
	Obj.repr((
# 320 "py_parse.mly"
                                                    
    While (_1, _3, _4, _6) ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 3 : Py_types.sref) in
	let _3 = (peek_val parser_env 1 : 'test) in
	let _4 = (peek_val parser_env 0 : 'colon_suite) in
	Obj.repr((
# 322 "py_parse.mly"
                                  
    While (_1, _3, _4, Empty) ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 7 : Py_types.sref) in
	let _3 = (peek_val parser_env 5 : 'elist) in
	let _5 = (peek_val parser_env 3 : Py_types.expr_t) in
	let _6 = (peek_val parser_env 2 : 'colon_suite) in
	let _7 = (peek_val parser_env 1 : Py_types.sref) in
	let _8 = (peek_val parser_env 0 : 'colon_suite) in
	Obj.repr((
# 327 "py_parse.mly"
                                                               
    For (_1, _3, _5, _6, _8) ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 5 : Py_types.sref) in
	let _3 = (peek_val parser_env 3 : 'elist) in
	let _5 = (peek_val parser_env 1 : Py_types.expr_t) in
	let _6 = (peek_val parser_env 0 : 'colon_suite) in
	Obj.repr((
# 329 "py_parse.mly"
                                            
    For (_1, _3, _5, _6, Empty) ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 5 : Py_types.sref) in
	let _3 = (peek_val parser_env 3 : 'colon_suite) in
	let _4 = (peek_val parser_env 2 : 'handlers) in
	let _5 = (peek_val parser_env 1 : Py_types.sref) in
	let _6 = (peek_val parser_env 0 : 'colon_suite) in
	Obj.repr((
# 334 "py_parse.mly"
                                                      TryElse (_3, _4, _6) ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 3 : Py_types.sref) in
	let _3 = (peek_val parser_env 1 : 'colon_suite) in
	let _4 = (peek_val parser_env 0 : 'handlers) in
	Obj.repr((
# 335 "py_parse.mly"
                                   TryElse (_3, _4, Empty) ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 4 : Py_types.sref) in
	let _3 = (peek_val parser_env 2 : 'colon_suite) in
	let _4 = (peek_val parser_env 1 : Py_types.sref) in
	let _5 = (peek_val parser_env 0 : 'colon_suite) in
	Obj.repr((
# 336 "py_parse.mly"
                                               TryElse (_3, [], _5) ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 4 : Py_types.sref) in
	let _3 = (peek_val parser_env 2 : 'colon_suite) in
	let _4 = (peek_val parser_env 1 : Py_types.sref) in
	let _5 = (peek_val parser_env 0 : 'colon_suite) in
	Obj.repr((
# 337 "py_parse.mly"
                                                 TryFinally (_3, _5) ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 3 : Py_types.sref) in
	let _2 = (peek_val parser_env 2 : 'test) in
	let _4 = (peek_val parser_env 0 : 'test) in
	Obj.repr((
# 340 "py_parse.mly"
                               Except2 (_1, _2, _4) ) : 'except_clause))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : Py_types.sref) in
	let _2 = (peek_val parser_env 0 : 'test) in
	Obj.repr((
# 341 "py_parse.mly"
                      Except1 (_1, _2) ) : 'except_clause))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : Py_types.sref) in
	Obj.repr((
# 342 "py_parse.mly"
                 Except0 ) : 'except_clause))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : 'except_clause) in
	let _2 = (peek_val parser_env 0 : 'colon_suite) in
	Obj.repr((
# 345 "py_parse.mly"
                              _1, _2 ) : 'handler))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : 'handler) in
	let _2 = (peek_val parser_env 0 : 'handlers) in
	Obj.repr((
# 348 "py_parse.mly"
                     _1 :: _2 ) : 'handlers))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'handler) in
	Obj.repr((
# 349 "py_parse.mly"
                     [_1] ) : 'handlers))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : 'simple_stmt) in
	Obj.repr((
# 352 "py_parse.mly"
                      _2 ) : 'colon_suite))
; (fun parser_env ->
	let _2 = (peek_val parser_env 3 : int * string) in
	let _4 = (peek_val parser_env 1 : 'stmts) in
	Obj.repr((
# 353 "py_parse.mly"
                                       Suite _4 ) : 'colon_suite))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : 'stmt) in
	let _2 = (peek_val parser_env 0 : 'stmts) in
	Obj.repr((
# 356 "py_parse.mly"
               _1 :: _2 ) : 'stmts))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'stmt) in
	Obj.repr((
# 357 "py_parse.mly"
           [_1] ) : 'stmts))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : 'and_test) in
	let _2 = (peek_val parser_env 0 : 'or_list) in
	Obj.repr((
# 360 "py_parse.mly"
                       Or (_1 :: _2) ) : 'test))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'and_test) in
	Obj.repr((
# 361 "py_parse.mly"
               _1 ) : 'test))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'lambdef) in
	Obj.repr((
# 362 "py_parse.mly"
              _1 ) : 'test))
; (fun parser_env ->
	let _2 = (peek_val parser_env 1 : 'and_test) in
	let _3 = (peek_val parser_env 0 : 'or_list) in
	Obj.repr((
# 365 "py_parse.mly"
                        _2 :: _3 ) : 'or_list))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : 'and_test) in
	Obj.repr((
# 366 "py_parse.mly"
                  [_2] ) : 'or_list))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : 'not_test) in
	let _2 = (peek_val parser_env 0 : 'and_list) in
	Obj.repr((
# 369 "py_parse.mly"
                      And (_1 :: _2) ) : 'and_test))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'not_test) in
	Obj.repr((
# 370 "py_parse.mly"
               _1 ) : 'and_test))
; (fun parser_env ->
	let _2 = (peek_val parser_env 1 : 'not_test) in
	let _3 = (peek_val parser_env 0 : 'and_list) in
	Obj.repr((
# 373 "py_parse.mly"
                          _2 :: _3 ) : 'and_list))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : 'not_test) in
	Obj.repr((
# 374 "py_parse.mly"
                    [_2] ) : 'and_list))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : 'not_test) in
	Obj.repr((
# 377 "py_parse.mly"
                  Not _2 ) : 'not_test))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'comparison) in
	Obj.repr((
# 378 "py_parse.mly"
                 _1 ) : 'not_test))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : Py_types.expr_t) in
	let _2 = (peek_val parser_env 0 : 'comp_list) in
	Obj.repr((
# 381 "py_parse.mly"
                   Compare (_1, _2) ) : 'comparison))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 382 "py_parse.mly"
           _1 ) : 'comparison))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : 'comparator) in
	let _2 = (peek_val parser_env 0 : 'comp_list) in
	Obj.repr((
# 385 "py_parse.mly"
                         _1 :: _2 ) : 'comp_list))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'comparator) in
	Obj.repr((
# 386 "py_parse.mly"
                  [_1] ) : 'comp_list))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 389 "py_parse.mly"
               Less _2 ) : 'comparator))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 390 "py_parse.mly"
                   Greater _2 ) : 'comparator))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 391 "py_parse.mly"
                  Equal _2 ) : 'comparator))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 392 "py_parse.mly"
                       GreaterEqual _2 ) : 'comparator))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 393 "py_parse.mly"
                    LessEqual _2 ) : 'comparator))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 394 "py_parse.mly"
                   NotEqual _2 ) : 'comparator))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 395 "py_parse.mly"
              In _2 ) : 'comparator))
; (fun parser_env ->
	let _3 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 396 "py_parse.mly"
                   NotIn _3 ) : 'comparator))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 397 "py_parse.mly"
              Is _2 ) : 'comparator))
; (fun parser_env ->
	let _3 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 398 "py_parse.mly"
                 IsNot _3 ) : 'comparator))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : Py_types.expr_t) in
	let _2 = (peek_val parser_env 0 : 'expr_list) in
	Obj.repr((
# 401 "py_parse.mly"
                       BitOr (_1 :: _2) ) : Py_types.expr_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 402 "py_parse.mly"
               _1 ) : Py_types.expr_t))
; (fun parser_env ->
	let _2 = (peek_val parser_env 1 : Py_types.expr_t) in
	let _3 = (peek_val parser_env 0 : 'expr_list) in
	Obj.repr((
# 404 "py_parse.mly"
                           _2 :: _3 ) : 'expr_list))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 405 "py_parse.mly"
                    [_2] ) : 'expr_list))
; (fun parser_env ->
	let _2 = (peek_val parser_env 1 : Py_types.expr_t) in
	let _3 = (peek_val parser_env 0 : 'xor_expr_list) in
	Obj.repr((
# 409 "py_parse.mly"
                                      _2 :: _3 ) : 'xor_expr_list))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 410 "py_parse.mly"
                           [_2] ) : 'xor_expr_list))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : Py_types.expr_t) in
	let _2 = (peek_val parser_env 0 : 'xor_expr_list) in
	Obj.repr((
# 412 "py_parse.mly"
                            BitXor (_1 :: _2) ) : Py_types.expr_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 413 "py_parse.mly"
               _1 ) : Py_types.expr_t))
; (fun parser_env ->
	let _2 = (peek_val parser_env 1 : Py_types.expr_t) in
	let _3 = (peek_val parser_env 0 : 'and_expr_list) in
	Obj.repr((
# 416 "py_parse.mly"
                                   _2 :: _3 ) : 'and_expr_list))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 417 "py_parse.mly"
                       [_2] ) : 'and_expr_list))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : Py_types.expr_t) in
	let _2 = (peek_val parser_env 0 : 'and_expr_list) in
	Obj.repr((
# 419 "py_parse.mly"
                            BitAnd (_1 :: _2 )) : Py_types.expr_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 420 "py_parse.mly"
                  _1 ) : Py_types.expr_t))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 423 "py_parse.mly"
                         Asl _2 ) : 'shift_op))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 424 "py_parse.mly"
                            Lsr _2 ) : 'shift_op))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : 'shift_op) in
	let _2 = (peek_val parser_env 0 : 'shift_expr_list) in
	Obj.repr((
# 426 "py_parse.mly"
                             _1 :: _2 ) : 'shift_expr_list))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'shift_op) in
	Obj.repr((
# 427 "py_parse.mly"
               [_1] ) : 'shift_expr_list))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : Py_types.expr_t) in
	let _2 = (peek_val parser_env 0 : 'shift_expr_list) in
	Obj.repr((
# 429 "py_parse.mly"
                               Eval (_1, _2) ) : Py_types.expr_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 430 "py_parse.mly"
                 _1 ) : Py_types.expr_t))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 433 "py_parse.mly"
              Add _2 ) : 'add_op))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 434 "py_parse.mly"
                Sub _2 ) : 'add_op))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : 'add_op) in
	let _2 = (peek_val parser_env 0 : 'arith_expr_list) in
	Obj.repr((
# 436 "py_parse.mly"
                           _1 :: _2 ) : 'arith_expr_list))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'add_op) in
	Obj.repr((
# 437 "py_parse.mly"
              [_1] ) : 'arith_expr_list))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : Py_types.expr_t) in
	let _2 = (peek_val parser_env 0 : 'arith_expr_list) in
	Obj.repr((
# 439 "py_parse.mly"
                        Eval (_1, _2) ) : Py_types.expr_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 440 "py_parse.mly"
          _1) : Py_types.expr_t))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 443 "py_parse.mly"
                Mul _2 ) : 'mul_op))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 444 "py_parse.mly"
                  Div _2) : 'mul_op))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 445 "py_parse.mly"
                    Mod _2) : 'mul_op))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : 'mul_op) in
	let _2 = (peek_val parser_env 0 : 'term_list) in
	Obj.repr((
# 447 "py_parse.mly"
                     _1 :: _2 ) : 'term_list))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'mul_op) in
	Obj.repr((
# 448 "py_parse.mly"
             [_1] ) : 'term_list))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : Py_types.expr_t) in
	let _2 = (peek_val parser_env 0 : 'term_list) in
	Obj.repr((
# 450 "py_parse.mly"
                    Eval (_1, _2) ) : Py_types.expr_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 451 "py_parse.mly"
               _1 ) : Py_types.expr_t))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 454 "py_parse.mly"
                _2 ) : Py_types.expr_t))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 455 "py_parse.mly"
                   Neg _2 ) : Py_types.expr_t))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 456 "py_parse.mly"
                   Complement _2) : Py_types.expr_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : Py_types.expr_t) in
	Obj.repr((
# 457 "py_parse.mly"
            _1 ) : Py_types.expr_t))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : 'atomic) in
	Obj.repr((
# 460 "py_parse.mly"
                 Pow _2 ) : 'pow_op))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : 'pow_op) in
	let _2 = (peek_val parser_env 0 : 'pow_expr_list) in
	Obj.repr((
# 462 "py_parse.mly"
                         _1 :: _2 ) : 'pow_expr_list))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'pow_op) in
	Obj.repr((
# 463 "py_parse.mly"
             [_1] ) : 'pow_expr_list))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : 'atomic) in
	let _2 = (peek_val parser_env 0 : 'pow_expr_list) in
	Obj.repr((
# 465 "py_parse.mly"
                         Eval (_1, _2) ) : Py_types.expr_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'atomic) in
	Obj.repr((
# 466 "py_parse.mly"
            _1) : Py_types.expr_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : 'trailer) in
	let _2 = (peek_val parser_env 0 : 'trailers) in
	Obj.repr((
# 469 "py_parse.mly"
                     _1 :: _2 ) : 'trailers))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'trailer) in
	Obj.repr((
# 470 "py_parse.mly"
              [_1] ) : 'trailers))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : 'atom) in
	let _2 = (peek_val parser_env 0 : 'trailers) in
	Obj.repr((
# 473 "py_parse.mly"
                  AtomWithTrailers (_1, _2) ) : 'atomic))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'atom) in
	Obj.repr((
# 474 "py_parse.mly"
           _1 ) : 'atomic))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : string) in
	let _2 = (peek_val parser_env 0 : 'strings) in
	Obj.repr((
# 477 "py_parse.mly"
                   _1 ^ _2 ) : 'strings))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : string) in
	Obj.repr((
# 478 "py_parse.mly"
             _1 ) : 'strings))
; (fun parser_env ->
	Obj.repr((
# 481 "py_parse.mly"
              PyTuple [] ) : 'atom))
; (fun parser_env ->
	let _2 = (peek_val parser_env 2 : 'testlist_ntc) in
	Obj.repr((
# 482 "py_parse.mly"
                                            PyTuple _2 ) : 'atom))
; (fun parser_env ->
	let _2 = (peek_val parser_env 1 : 'testlist_ntc) in
	Obj.repr((
# 483 "py_parse.mly"
                             
    match _2 with
    | [x] -> x
    | x  -> PyTuple x
    ) : 'atom))
; (fun parser_env ->
	Obj.repr((
# 488 "py_parse.mly"
                PyList [] ) : 'atom))
; (fun parser_env ->
	let _2 = (peek_val parser_env 2 : 'testlist_ntc) in
	Obj.repr((
# 489 "py_parse.mly"
                                            PyList _2 ) : 'atom))
; (fun parser_env ->
	let _2 = (peek_val parser_env 1 : 'testlist_ntc) in
	Obj.repr((
# 490 "py_parse.mly"
                             PyList _2 ) : 'atom))
; (fun parser_env ->
	Obj.repr((
# 491 "py_parse.mly"
                    PyDict [] ) : 'atom))
; (fun parser_env ->
	let _2 = (peek_val parser_env 1 : 'dictmaker) in
	Obj.repr((
# 492 "py_parse.mly"
                             PyDict _2 ) : 'atom))
; (fun parser_env ->
	let _2 = (peek_val parser_env 2 : 'dictmaker) in
	Obj.repr((
# 493 "py_parse.mly"
                                            PyDict _2 ) : 'atom))
; (fun parser_env ->
	let _2 = (peek_val parser_env 1 : Py_types.expr_t) in
	Obj.repr((
# 494 "py_parse.mly"
                                    PyRepr _2 ) : 'atom))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : string) in
	Obj.repr((
# 495 "py_parse.mly"
          PyName _1) : 'atom))
; (fun parser_env ->
	Obj.repr((
# 496 "py_parse.mly"
           PyNone ) : 'atom))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : int) in
	Obj.repr((
# 497 "py_parse.mly"
             PyInt _1) : 'atom))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : float) in
	Obj.repr((
# 498 "py_parse.mly"
           PyFloat _1) : 'atom))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : Big_int.big_int) in
	Obj.repr((
# 499 "py_parse.mly"
          PyLong _1) : 'atom))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : float * float) in
	Obj.repr((
# 500 "py_parse.mly"
             PyComplex (fst _1, snd _1) ) : 'atom))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'strings) in
	Obj.repr((
# 501 "py_parse.mly"
             PyString _1) : 'atom))
; (fun parser_env ->
	let _2 = (peek_val parser_env 2 : 'varargslist) in
	let _4 = (peek_val parser_env 0 : 'test) in
	Obj.repr((
# 504 "py_parse.mly"
                                 Lambda (_2, _4) ) : 'lambdef))
; (fun parser_env ->
	let _2 = (peek_val parser_env 3 : 'varargslist) in
	let _4 = (peek_val parser_env 1 : Py_types.sref) in
	let _5 = (peek_val parser_env 0 : 'test) in
	Obj.repr((
# 505 "py_parse.mly"
                                       Lambda (_2, _5) ) : 'lambdef))
; (fun parser_env ->
	let _3 = (peek_val parser_env 0 : 'test) in
	Obj.repr((
# 506 "py_parse.mly"
                       Lambda (([], NoStarParam, NoStarStarParam), _3) ) : 'lambdef))
; (fun parser_env ->
	let _3 = (peek_val parser_env 1 : Py_types.sref) in
	let _4 = (peek_val parser_env 0 : 'test) in
	Obj.repr((
# 507 "py_parse.mly"
                           Lambda (([], NoStarParam, NoStarStarParam), _4) ) : 'lambdef))
; (fun parser_env ->
	Obj.repr((
# 510 "py_parse.mly"
               Arglist [] ) : 'trailer))
; (fun parser_env ->
	let _2 = (peek_val parser_env 1 : 'arglist) in
	Obj.repr((
# 511 "py_parse.mly"
                         Arglist _2 ) : 'trailer))
; (fun parser_env ->
	let _2 = (peek_val parser_env 2 : 'arglist) in
	Obj.repr((
# 512 "py_parse.mly"
                                        Arglist _2 ) : 'trailer))
; (fun parser_env ->
	let _2 = (peek_val parser_env 1 : 'subscriptlist) in
	Obj.repr((
# 513 "py_parse.mly"
                             Sublist _2 ) : 'trailer))
; (fun parser_env ->
	let _2 = (peek_val parser_env 2 : 'subscriptlist) in
	Obj.repr((
# 514 "py_parse.mly"
                                            Sublist _2 ) : 'trailer))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : string) in
	Obj.repr((
# 515 "py_parse.mly"
              Dotname _2) : 'trailer))
; (fun parser_env ->
	let _2 = (peek_val parser_env 1 : 'subscript) in
	let _3 = (peek_val parser_env 0 : 'comma_sublist) in
	Obj.repr((
# 518 "py_parse.mly"
                                  _2 :: _3 ) : 'comma_sublist))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : 'subscript) in
	Obj.repr((
# 519 "py_parse.mly"
                      [_2] ) : 'comma_sublist))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : 'subscript) in
	let _2 = (peek_val parser_env 0 : 'comma_sublist) in
	Obj.repr((
# 522 "py_parse.mly"
                               _1 :: _2 ) : 'subscriptlist))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'subscript) in
	Obj.repr((
# 523 "py_parse.mly"
                 [_1] ) : 'subscriptlist))
; (fun parser_env ->
	Obj.repr((
# 526 "py_parse.mly"
                Ellipsis ) : 'subscript))
; (fun parser_env ->
	let _1 = (peek_val parser_env 4 : 'test) in
	let _3 = (peek_val parser_env 2 : 'test) in
	let _5 = (peek_val parser_env 0 : 'test) in
	Obj.repr((
# 527 "py_parse.mly"
                                       Subscript2 (Pos _1, Pos _3, Pos _5) ) : 'subscript))
; (fun parser_env ->
	let _1 = (peek_val parser_env 3 : 'test) in
	let _3 = (peek_val parser_env 1 : 'test) in
	Obj.repr((
# 529 "py_parse.mly"
                                  Subscript2 (Pos _1, Pos _3, Defsub) ) : 'subscript))
; (fun parser_env ->
	let _1 = (peek_val parser_env 3 : 'test) in
	let _4 = (peek_val parser_env 0 : 'test) in
	Obj.repr((
# 530 "py_parse.mly"
                                  Subscript2 (Pos _1, Defsub, Pos _4) ) : 'subscript))
; (fun parser_env ->
	let _2 = (peek_val parser_env 2 : 'test) in
	let _4 = (peek_val parser_env 0 : 'test) in
	Obj.repr((
# 531 "py_parse.mly"
                                  Subscript2 (Defsub, Pos _2, Pos _4) ) : 'subscript))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : 'test) in
	Obj.repr((
# 532 "py_parse.mly"
                             Subscript2 (Pos _1, Defsub, Defsub) ) : 'subscript))
; (fun parser_env ->
	let _2 = (peek_val parser_env 1 : 'test) in
	Obj.repr((
# 533 "py_parse.mly"
                             Subscript2 (Defsub, Pos _2, Defsub) ) : 'subscript))
; (fun parser_env ->
	let _3 = (peek_val parser_env 0 : 'test) in
	Obj.repr((
# 534 "py_parse.mly"
                             Subscript2 (Defsub, Defsub, Pos _3) ) : 'subscript))
; (fun parser_env ->
	Obj.repr((
# 535 "py_parse.mly"
                        Subscript2 (Defsub, Defsub, Defsub) ) : 'subscript))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : 'test) in
	let _3 = (peek_val parser_env 0 : 'test) in
	Obj.repr((
# 537 "py_parse.mly"
                        Subscript1 (Pos _1, Pos _3) ) : 'subscript))
; (fun parser_env ->
	let _1 = (peek_val parser_env 1 : 'test) in
	Obj.repr((
# 538 "py_parse.mly"
                   Subscript1 (Pos _1, Defsub) ) : 'subscript))
; (fun parser_env ->
	let _2 = (peek_val parser_env 0 : 'test) in
	Obj.repr((
# 539 "py_parse.mly"
                   Subscript1 (Defsub, Pos _2) ) : 'subscript))
; (fun parser_env ->
	Obj.repr((
# 540 "py_parse.mly"
              Subscript1 (Defsub, Defsub) ) : 'subscript))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'test) in
	Obj.repr((
# 541 "py_parse.mly"
          Subscript0 (Pos _1) ) : 'subscript))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : 'test) in
	let _3 = (peek_val parser_env 0 : 'test) in
	Obj.repr((
# 544 "py_parse.mly"
                        DictEnt (_1, _3) ) : 'dictent))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : 'dictent) in
	let _3 = (peek_val parser_env 0 : 'dictmaker) in
	Obj.repr((
# 546 "py_parse.mly"
                            _1 :: _3 ) : 'dictmaker))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'dictent) in
	Obj.repr((
# 547 "py_parse.mly"
              [_1] ) : 'dictmaker))
; (fun parser_env ->
	let _1 = (peek_val parser_env 6 : Py_types.sref) in
	let _3 = (peek_val parser_env 4 : string) in
	let _5 = (peek_val parser_env 2 : Py_types.expr_t) in
	let _7 = (peek_val parser_env 0 : 'colon_suite) in
	Obj.repr((
# 550 "py_parse.mly"
                                                  Class (_1, _3, _5, _7) ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 3 : Py_types.sref) in
	let _3 = (peek_val parser_env 1 : string) in
	let _4 = (peek_val parser_env 0 : 'colon_suite) in
	Obj.repr((
# 551 "py_parse.mly"
                                 Class (_1, _3, PyNone, _4) ) : Py_types.statement_t))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : 'argument) in
	let _3 = (peek_val parser_env 0 : 'arglist) in
	Obj.repr((
# 554 "py_parse.mly"
                           _1 :: _3 ) : 'arglist))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'argument) in
	Obj.repr((
# 555 "py_parse.mly"
               [_1] ) : 'arglist))
; (fun parser_env ->
	let _1 = (peek_val parser_env 2 : string) in
	let _3 = (peek_val parser_env 0 : 'test) in
	Obj.repr((
# 558 "py_parse.mly"
                    Argument2 (_1, _3) ) : 'argument))
; (fun parser_env ->
	let _1 = (peek_val parser_env 0 : 'test) in
	Obj.repr((
# 559 "py_parse.mly"
           Argument1 _1 ) : 'argument))
(* Entry file_input *)
; (fun parser_env -> raise (YYexit (peek_val parser_env 0)))
(* Entry eval_input *)
; (fun parser_env -> raise (YYexit (peek_val parser_env 0)))
|]
let yytables =
  { actions=yyact;
    transl_const=yytransl_const;
    transl_block=yytransl_block;
    lhs=yylhs;
    len=yylen;
    defred=yydefred;
    dgoto=yydgoto;
    sindex=yysindex;
    rindex=yyrindex;
    gindex=yygindex;
    tablesize=yytablesize;
    table=yytable;
    check=yycheck;
    error_function=parse_error }
let file_input (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (yyparse yytables 1 lexfun lexbuf : Py_types.statement_t)
let eval_input (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (yyparse yytables 2 lexfun lexbuf : Py_types.expr_t)
(* Line 562, file py_parse.mly *)
(* trailer *)


(* Line 2428, file py_parse.ml *)
