open Py_types
open Py_exceptions
open Py_datum
open Py_util
open Util
open Py_datum


let get_parameters_from_parameters eval (ps:parameters_t) = 
  let get_parameters_from_parameter (p:parameter_t) = 
    begin match p with
    | Parameter2 (pn, e) -> 
      begin let e' = eval e in
        let rec check_default pn e = 
        match pn with
        | Param n  -> ()
        | Paramtuple ls ->
          begin let ls' = 
            match e with 
            | PyTuple ls' -> ls'
            | PyList ls' ->ls'
            | _ -> raise (TypeError "Default parameter not sequence")
            in 
              if List.length ls <> List.length ls' 
              then raise (TypeError "Default parameter sequence wrong length");
              List.iter2 check_default ls ls'
          end
        in 
          check_default pn e';
          Parameter2 (pn, e')
      end
    | Parameter1 pn -> Parameter1 pn
    end
  in let get_parameters_from_parameter_list (ps:parameter_t list) = 
    List.map get_parameters_from_parameter ps

  in 
    match ps with (pl, star, star2) ->
      let ps' = (get_parameters_from_parameter_list pl) in
      begin let defcnt = ref 0 in
        List.iter
        begin fun p -> match p with
        | Parameter1 _ -> 
          if !defcnt > 0 
          then raise (SyntaxError "Non-default argument follows default argument")
        | Parameter2 (_,_) -> incr defcnt
        end
        ps'
      end;
      ps', star, star2


