(* this module is used by py_eval but does not depend on it *)

exception FoundFile of string * string;;
open Util

let binary_slash_join a b = a ^ "/" ^ b;;
let path_slash_join x = 
  List.fold_left binary_slash_join (List.hd x) (List.tl x);;

let binary_dot_join a b = a ^ "." ^ b;;
let path_dot_join x = 
  List.fold_left binary_dot_join (List.hd x) (List.tl x);;

(* given a list of strings representing the lookup
   path, search for a given module file,
   given as a list of component names,
   return a pair: the directory name, including a trailing /
   and the component filename
*)

let extensions = [".vy"; "/__init__.vy"; ".py"; "/__init__.py"];;

let file_from_module_name (lookup_path:string list) (modname:string) =
  try begin
    List.iter 
      begin fun directory ->
        List.iter 
          begin fun extension ->
            let filename = modname ^ extension
            in let testname = binary_slash_join directory filename
            in 
            print_endline ("Trying filename=" ^ testname); 
            if Sys.file_exists testname 
            then raise (FoundFile (directory,filename) )
          end
          extensions
      end
      lookup_path
    ;
    None
  end with FoundFile (d,f) -> (Some (d,f))
;;


