open Py_parse

let hash_table_from_list n lst =
  let tbl = Hashtbl.create n
  in let addEntry (s,kw) = Hashtbl.add tbl s kw
  in 
  List.iter addEntry lst;
  tbl
;;     


let keyword_table =          (* 97 is a prime larger than table size *)
  hash_table_from_list 97 [  
    "None",NONE;
    "and", AND;
    "assert", ASSERT;
    "break",  BREAK;
    "class",  CLASS;
    "continue", CONTINUE;
    "def", DEF;
    "del", DEL;
    "elif", ELIF;
    "else", ELSE;
    "except", EXCEPT;
    "exec", EXEC;
    "finally", FINALLY;
    "for", FOR;
    "from", FROM;
    "global", GLOBAL;
    "if", IF;
    "import", IMPORT; 
    "in", IN;
    "is", IS;
    "lambda", LAMBDA; 
    "not", NOT;
    "or", OR;
    "pass", PASS;
    "print", PRINT; 
    "raise", RAISE;
    "return", RETURN;
    "try", TRY;
    "while", WHILE
];;

let map_keywords lex_item = 
  try Hashtbl.find keyword_table lex_item
  with Not_found -> NAME lex_item;;


