open Py_types
open Py_exceptions
open Py_builtins_util

open Gdk

let py_font_load
  (interp:interpreter_t) 
  (e:expr_t list) 
  (d:dictionary_t): expr_t  = 
  empty_dict d;
  exactly e 1;
  match arg e 0 with
  | PyString s ->
    begin 
      try PyFont (font_load s)
      with Failure _ -> raise (ValueError ("Unable to load font " ^ s))
    end
  | _ -> raise (TypeError "font load requires string arg 1")

(* WARNING: this routine does NOT handle ISO-10646 *)
let py_string_extents
  (interp:interpreter_t) 
  (e:expr_t list) 
  (d:dictionary_t): expr_t  = 
  empty_dict d;
  exactly e 2;
  let font = 
    begin match arg e 0 with
    | PyFont f -> f
    | _ -> raise (TypeError "string extents requires font arg 1")
    end
  and str = 
    begin match arg e 1 with
    | PyString s -> s
    | _ -> raise (TypeError "string extents requires string arg 2")
    end
  in
    let ext = string_extents font str
    and width = string_width font str
    and height = string_height font str
    in PyTuple [
      PyInt width; 
      PyInt height; 
      PyInt ext.lbearing;
      PyInt ext.rbearing;
      PyInt ext.e_width;
      PyInt ext.ascent;
      PyInt ext.descent
    ]

let cvt14 x = 
  if x >= 1.0 
  then 16383 
  else max (min (int_of_float (x *. 16384.0)) 16383) 0

let py_create_color_rgb
  (interp:interpreter_t) 
  (e:expr_t list) 
  (d:dictionary_t): expr_t  = 
  empty_dict d;
  exactly e 3;
  let red' = 
    begin match arg e 0 with
    | PyFloat f -> f
    | _ -> raise (TypeError "create color requires float for red")
    end

  and green' = 
    begin match arg e 1 with
    | PyFloat f -> f
    | _ -> raise (TypeError "create color requires float for green")
    end

  and blue' = 
    begin match arg e 2 with
    | PyFloat f -> f
    | _ -> raise (TypeError "create color requires float for blue")
    end
  in
    PyColor { 
      pixel=0; (* who knows what this is for? *)
      red = cvt14 red'; 
      green = cvt14 green'; 
      blue = cvt14 blue'
    }

