(* execute, translating ocaml exceptions to python ones *)
val py_exec_wrap_exn : 
  Py_types.interpreter_t -> 
  Py_types.environment_t -> 
  Py_types.statement_t -> 
  unit

(* execute without exception translation *)
val py_exec : 
  Py_types.interpreter_t -> 
  Py_types.environment_t -> 
  Py_types.statement_t -> 
  unit

(* evaluate expression *)
val py_eval : 
  Py_types.interpreter_t -> 
  Py_types.environment_t -> 
  Py_types.expr_t -> 
  Py_types.expr_t

(* call function *)
val py_call :
  Py_types.interpreter_t ->
  Py_types.expr_t -> Py_types.argument_t list -> Py_types.expr_t

(* create a class instance *)
val create_class_instance :
  Py_types.interpreter_t ->
  Py_types.class_t -> Py_types.argument_t list -> Py_types.instance_t

(* get an attribute *)
val get_attribute :
  Py_types.interpreter_t ->
  Py_types.expr_t -> Py_types.expr_t -> Py_types.expr_t

(* get sequence length  *)
val py_seq_len :
  Py_types.interpreter_t ->
  Py_types.expr_t -> Py_types.expr_t 

(* get sequence item *)
val py_get_seq_elem :
  Py_types.interpreter_t ->
  Py_types.expr_t -> Py_types.expr_t -> Py_types.expr_t

