exception LexError of string 
  (* an error during lexing *)

exception TokenError of string 
  (* an error during tokenizing *)

exception ParseError of string 
  (* An error while parsing *)

exception SystemError of string
  (* An internal failure that might be due to either a system fault,
     or the client destroying system integrity *)

exception ViperError of string
  (* Definitely a programming error in Viper itself *)

exception PyException of Py_types.py_exception
  (* Client exception type *)

(* internal exceptions not passed up as python ones *)

exception UnknownError of exn   
  (* Some ocaml exception that doesn't map to a python one *)

exception NotImplemented of string 
  (* an unimplemented feature: not mapped to python ones *)

(* interpreter exceptions: these have to be converted to py_exceptions *)

exception SyntaxError of string
  (* the error given when a syntax error is detected dynamically *)

exception TypeError of string
  (* The type of an object is not what is expected *)

exception NonSequence
  (* The type of an object is not a sequence as expected *)

exception RangeError of string
  (* An index is out of raange [to be replaced by IndexError!] *)

exception ValueError of string
  (* An argument has a bad value *)

exception AssertionError of string
  (* A client assert statement failed *)

exception ImportError of string * exn option
  (* An import statement failed [for any reason] *)

exception IndexError of string * int * int
  (* A sequence index is out of bounds *)

exception AttributeError of string * Py_types.expr_t
  (* 1. An attempt to get a attribute that doesn't exist failed, or,
     2. an attempt to delete an attribute that doesn't exist 
        or is read only, failed, or,
     3. an attempt to set a readonly attribute failed, or,
     4. an attempt to set an attribute into an object without
     5. a writable dictionary failed *)

exception NameError of string * Py_types.expr_t
  (* 1. An attempt to get an unqualified name that doesn't exist failed *)

exception KeyError of string * Py_types.expr_t
  (* 1. An attempt to get a non-existant key from a dictionary failed, or,
     2. An attempt to delete a non-existant key from a dictionary failed *)

exception Breaker (* raise by a break statement *)
exception Continuer (* raised by a continue statement *)
exception Returner of Py_types.expr_t (* raised by a return statements *)
exception SystemExit of int (* raised by sys.exit(n) function *)

