class py_handler_environment :
  string ->
  Py_types.expr_t ->
  Py_types.environment_t ->
  object
    val dict : Py_dict.py_dictionary
    val super : Py_types.environment_t
    method can_del_attr : Py_types.expr_t -> bool
    method can_get_attr : Py_types.expr_t -> bool
    method can_set_any_attr : Py_types.expr_t -> bool
    method can_set_attr : Py_types.expr_t -> Py_types.expr_t -> bool
    method del_attr : Py_types.expr_t -> bool
    method del_indexed : int -> int -> unit
    method get_attr : Py_types.expr_t -> Py_types.expr_t option
    method get_globals : Py_types.dictionary_t
    method get_indexed : int -> int -> Py_types.expr_t
    method get_locals : Py_dict.py_dictionary
    method has_attr : Py_types.expr_t -> bool
    method keys : Py_types.expr_t list
    method set_attr : Py_types.expr_t -> Py_types.expr_t -> bool
    method set_indexed : int -> int -> Py_types.expr_t -> unit
    method get_module : Py_types.module_t
  end

class py_null_environment :
  object
    method can_del_attr : Py_types.expr_t -> bool
    method can_get_attr : Py_types.expr_t -> bool
    method can_set_any_attr : Py_types.expr_t -> bool
    method can_set_attr : Py_types.expr_t -> Py_types.expr_t -> bool
    method del_attr : Py_types.expr_t -> bool
    method del_indexed : int -> int -> unit
    method get_attr : Py_types.expr_t -> Py_types.expr_t option
    method get_globals : Py_types.dictionary_t
    method get_indexed : int -> int -> Py_types.expr_t
    method get_locals : Py_dict.py_dictionary
    method has_attr : Py_types.expr_t -> bool
    method keys : Py_types.expr_t list
    method set_attr : Py_types.expr_t -> Py_types.expr_t -> bool
    method set_indexed : int -> int -> Py_types.expr_t -> unit
    method get_module : Py_types.module_t
  end

class py_python_environment :
  Py_types.dictionary_t ->
  Py_types.dictionary_t ->
  Py_types.dictionary_t ->
  object
    method can_del_attr : Py_types.expr_t -> bool
    method can_get_attr : Py_types.expr_t -> bool
    method can_set_any_attr : Py_types.expr_t -> bool
    method can_set_attr : Py_types.expr_t -> Py_types.expr_t -> bool
    method del_attr : Py_types.expr_t -> bool
    method del_indexed : int -> int -> unit
    method get_attr : Py_types.expr_t -> Py_types.expr_t option
    method get_globals : Py_types.dictionary_t
    method get_indexed : int -> int -> Py_types.expr_t
    method get_locals : Py_dict.py_dictionary
    method has_attr : Py_types.expr_t -> bool
    method keys : Py_types.expr_t list
    method set_attr : Py_types.expr_t -> Py_types.expr_t -> bool
    method set_indexed : int -> int -> Py_types.expr_t -> unit
    method get_module : Py_types.module_t
  end
