(* THESE TYPES PROVIDE THE BASIC OPERATIONS ON KERNEL TYPES
   Clients should not use these functions, some of them return
   native ocaml types, etc, and most ignore class instance
   emulation methods like __add__
*)

val get_typename : Py_types.expr_t -> string

(* logic *)
val py_istrue : Py_types.expr_t -> bool
val py_or : Py_types.expr_t -> Py_types.expr_t -> Py_types.expr_t
val py_and : Py_types.expr_t -> Py_types.expr_t -> Py_types.expr_t
val py_not : Py_types.expr_t -> Py_types.expr_t

(* utility *)
val py_coerce :
  Py_types.expr_t * Py_types.expr_t -> Py_types.expr_t * Py_types.expr_t
val list_less : ('a -> 'a -> bool) -> 'a list -> 'a list -> bool
val dictionary_less :
  Py_types.expr_t Py_types.dictionary_t' ->
  Py_types.expr_t Py_types.dictionary_t' -> bool

(* comparisons *)
val py_less : Py_types.expr_t -> Py_types.expr_t -> bool
val py_equal : Py_types.expr_t -> Py_types.expr_t -> bool
val py_greater : Py_types.expr_t -> Py_types.expr_t -> bool
val py_not_equal : Py_types.expr_t -> Py_types.expr_t -> bool
val py_greater_equal : Py_types.expr_t -> Py_types.expr_t -> bool
val py_less_equal : Py_types.expr_t -> Py_types.expr_t -> bool

val py_is : 'a -> 'a -> bool
val py_in : Py_types.expr_t -> Py_types.expr_t -> bool
val py_not_in : Py_types.expr_t -> Py_types.expr_t -> bool
val py_compare : Py_types.expr_t -> Py_types.expr_t -> int

(* unary operators *)
val py_complement : Py_types.expr_t -> int
val py_neg : Py_types.expr_t -> Py_types.expr_t

(* binary operators *)
val py_bit_or : int -> Py_types.expr_t -> int
val py_bit_and : int -> Py_types.expr_t -> int
val py_bit_xor : int -> Py_types.expr_t -> int
val py_lsl : Py_types.expr_t -> Py_types.expr_t -> Py_types.expr_t
val py_lsr : Py_types.expr_t -> Py_types.expr_t -> Py_types.expr_t

val py_add : Py_types.expr_t -> Py_types.expr_t -> Py_types.expr_t
val py_sub : Py_types.expr_t -> Py_types.expr_t -> Py_types.expr_t
val py_mul : Py_types.expr_t -> Py_types.expr_t -> Py_types.expr_t
val py_div : Py_types.expr_t -> Py_types.expr_t -> Py_types.expr_t
val py_mod : Py_types.expr_t -> Py_types.expr_t -> Py_types.expr_t
val py_pow : Py_types.expr_t -> Py_types.expr_t -> Py_types.expr_t

(* subscription *)
val py_seq_len : Py_types.expr_t -> int
val py_get_seq_elem: Py_types.expr_t -> int -> Py_types.expr_t
val py_get_seq_slice: Py_types.expr_t -> int -> int -> Py_types.expr_t
val py_get_seq_slice_extended: Py_types.expr_t -> int -> int -> int -> Py_types.expr_t
val normalise_range: int -> int -> int -> int * int

(* attributes *)
val py_get_attribute : Py_types.expr_t -> Py_types.expr_t -> Py_types.expr_t option
 
