# this is the pcre emulation module
#print "Python pcre emnulation module starts"

# original C flags
PCRE_CASELESS       =   0x0001
PCRE_MULTILINE      =   0x0002
PCRE_DOTALL         =   0x0004
PCRE_EXTENDED       =   0x0008
PCRE_ANCHORED       =   0x0010
PCRE_DOLLAR_ENDONLY =   0x0020
PCRE_EXTRA          =   0x0040
PCRE_NOTBOL         =   0x0080
PCRE_NOTEOL         =   0x0100

# WARNING: somehow, this differs from the python version!
# Python uses x200 for PCRE_LOCALE, and x400 for UNGREEDY
PCRE_UNGREEDY       =   0x0200
PCRE_NOTEMPTY       =   0x0400

# NOTE: PCRE_ANCHORED is both a compile and runtime flag!

IGNORECASE = PCRE_CASELESS
LOCALE = 0 # not implemented
MULTILINE = PCRE_MULTILINE
DOTALL = PCRE_DOTALL
VERBOSE = 0 # not implemented
ANCHORED = PCRE_ANCHORED


class pcre_regexp_object:
  def __init__(self,code):
    self.code = code
  def match(self,src,pos,end,flags):
    #print "Matching '"+src+"' from",pos,"to",end,"flags",flags
    result = re_match(flags,self.code,pos,end,src)
    #print "Got result from match",result
    return result

def pcre_compile(pattern, flags, index):
  code = re_compile(pattern, flags) # ignore index
  obj = pcre_regexp_object(code)
  return obj

