from gui import *
gui = GUI()

input_area = Text(text="Viper Input",editable=1,show=1)
myfont = font_load("-adobe-courier-medium-r-normal--14-100-*-*-*-*-iso8859-1")
fg = rgb_color(0.6, 0.9, 0.9)

text_replace(input_area.widget, 0, text_length(input_area.widget),
  "HELLO", font=myfont, foreground=fg)

output_area = Text(text="Viper Output",editable=0,show=1)
input_output = Paned(orientation='horizontal',show=1)
input_output.add(input_area,pane=1)
input_output.add(output_area,pane=2)

module_book = NoteBook(show=1)
module_book.setattr(scroll_tabs=1)
module_book.set_usize(320,200)

from sys import modules
pageno = 0
modules_keys = modules.keys()
modules_keys.sort()

for key in modules_keys:
  label = Label(text=key)
  list = Clist(text="module "+key, show=1, columns=['Attribute','Value'])
  win = ScrolledWindow(show=1)
  win.add(list)
  mdict = modules[key].__dict__
  mdict_keys = mdict.keys()
  mdict_keys.sort()
  i = 0
  for name in mdict_keys:
    if name != '__builtins__':
      value = mdict[name]
      clist_insert (list.widget, i, [name, value])
      i = i + 1
  module_book.add(win, label, pageno)
  pageno = pageno + 1

io_modules = Paned(orientation='horizontal',show=1)
io_modules.add(input_output, pane=1)
io_modules.add(module_book, pane=2)

quit_button = Button(text="Quit",on_click=gui_quit, show=1)
tool_client_panes = Paned(orientation='vertical',show=1)
tool_client_panes.add(quit_button, pane=1)
tool_client_panes.add(io_modules, pane=2)

toplevel= TopLevel(
  title="Viper GUI Demo", 
  on_delete=gui_quit, 
  show=1, 
  child=tool_client_panes
  )



#file_sel = widget_create("file_selection", text="Select File",show=1)

#file_sel_ok = file_selection_getattr(file_sel,'ok_button')
#def handle_file_sel_ok(*args):
#  print "File selection OK button pressed"
#  filename = file_selection_getattr(file_sel,'filename')
#  print "Filename is",filename
#  try:
#    f = open(filename,"r")
#    data = f.read()
#    f.close()
#    text_insert(text_area.get_widget(),data)
#  except: pass
#
#signal_connect(file_sel_ok,"clicked", handle_file_sel_ok)

gui.mainloop()

