type update_policy =
  | UPDATE_CONTINUOUS
  | UPDATE_DISCONTINUOUS
  | UPDATE_DELAYED
and button_box_layout_style =
  | BUTTONBOX_DEFAULT_STYLE
  | BUTTONBOX_SPREAD
  | BUTTONBOX_EDGE
  | BUTTONBOX_START
  | BUTTONBOX_END
and arrow_type = | ARROW_UP | ARROW_DOWN | ARROW_LEFT | ARROW_RIGHT
and curve_type = | CURVE_TYPE_LINEAR | CURVE_TYPE_SPLINE | CURVE_TYPE_FREE
and direction_type =
  | DIR_TAB_FORWARD
  | DIR_TAB_BACKWARD
  | DIR_UP
  | DIR_DOWN
  | DIR_LEFT
  | DIR_RIGHT
and justification =
  | JUSTIFY_LEFT
  | JUSTIFY_RIGHT
  | JUSTIFY_CENTER
  | JUSTIFY_FILL
and pack_type = | PACK_START | PACK_END
and position_type = | POS_LEFT | POS_RIGHT | POS_TOP | POS_BOTTOM
and selection_type =
  | SELECTION_SINGLE
  | SELECTION_BROWSE
  | SELECTION_MULTIPLE
  | SELECTION_EXTENDED
and shadow_type =
  | SHADOW_NONE
  | SHADOW_IN
  | SHADOW_OUT
  | SHADOW_ETCHED_IN
  | SHADOW_ETCHED_OUT
and window_type = | WINDOW_TOPLEVEL | WINDOW_DIALOG | WINDOW_POPUP
and style =
  { font: Gdk.font;
    fg_gc: Gdk.gc array;
    fg_gc_0: Gdk.gc;
    fg_gc_1: Gdk.gc;
    fg_gc_2: Gdk.gc;
    fg_gc_3: Gdk.gc;
    fg_gc_4: Gdk.gc;
    black_gc: Gdk.gc;
    white_gc: Gdk.gc;
    colormap: Gdk.colormap }
and allocation = { x: int; y: int; width: int; height: int }

and adjustment_data =
  {
    pos: float;
    lower: float;
    upper: float;
    step_increment: float;
    page_increment: float;
    page_size: float;
  }
  module Unsafe :
  sig
    type gtkobject
    and gtkArg =
      | Unit
      | Other
      | Invalid
      | Bool of bool
      | Char of char
      | Int of int
      | Float of float
      | String of string
      | Pointer of Glib.Pointer.t
    and gtkCallBack = gtkobject -> gtkArg list -> gtkArg
    external object_set_data : gtkobject -> string -> 'a -> unit
      = "mlgtk_object_set_data"
    external object_get_data : gtkobject -> string -> 'a
      = "mlgtk_object_get_data"
    external object_free_data : gtkobject -> string -> bool
      = "mlgtk_object_free_data"
    val object_set_user_data : gtkobject -> 'a -> unit
    val object_get_user_data : gtkobject -> 'a
    val object_free_user_data : gtkobject -> bool
    external adjustment_new: float -> float -> float -> float -> float -> float -> gtkobject = "mlgtk_adjustment_new"
    external adjustment_set_value: gtkobject -> float -> unit = "mlgtk_adjustment_set_value"
    external adjustment_get_data: gtkobject -> adjustment_data = "mlgtk_adjustment_get_data"
    external range_get_adjustment : gtkobject -> gtkobject = "mlgtk_range_get_adjustment"
    external range_set_adjustment : gtkobject -> gtkobject -> unit = "mlgtk_range_set_adjustment"


    external signal_connect : gtkobject -> string -> gtkCallBack -> int
      = "mlgtk_signal_connect"
    external signal_disconnect : gtkobject -> int -> unit
      = "mlgtk_signal_disconnect"
    external alignment_new : float -> float -> float -> float -> gtkobject
      = "mlgtk_alignment_new"
    external alignment_set :
      gtkobject -> float -> float -> float -> float -> unit
      = "mlgtk_alignment_set"
    external arrow_new : arrow_type -> shadow_type -> gtkobject
      = "mlgtk_arrow_new"
    external arrow_set : gtkobject -> arrow_type -> shadow_type -> unit
      = "mlgtk_arrow_set"
    external aspect_frame_new :
      string -> float -> float -> float -> bool -> gtkobject
      = "mlgtk_aspect_frame_new"
    external aspect_frame_set :
      gtkobject -> float -> float -> float -> bool -> unit
      = "mlgtk_aspect_frame_set"
    external box_pack_start :
      gtkobject -> gtkobject -> bool -> bool -> int -> unit
      = "mlgtk_box_pack_start"
    external box_pack_end :
      gtkobject -> gtkobject -> bool -> bool -> int -> unit
      = "mlgtk_box_pack_end"
    val box_pack_start_defaults : gtkobject -> gtkobject -> unit
    val box_pack_end_defaults : gtkobject -> gtkobject -> unit
    external box_set_homogeneous : gtkobject -> bool -> unit
      = "mlgtk_box_set_homogeneous"
    external box_set_spacing : gtkobject -> int -> unit
      = "mlgtk_box_set_spacing"
    external box_reorder_child : gtkobject -> gtkobject -> int -> unit
      = "mlgtk_box_reorder_child"
    external box_query_child_packing :
      gtkobject -> gtkobject -> bool * bool * int * pack_type
      = "mlgtk_box_query_child_packing"
    external box_set_child_packing :
      gtkobject -> gtkobject -> bool -> bool -> int -> pack_type -> unit
      = "mlgtk_box_set_child_packing_bytecode" "mlgtk_box_set_child_packing"
    external button_box_set_child_size : gtkobject -> int -> int -> unit
      = "mlgtk_button_box_set_child_size"
    external button_box_set_child_ipadding : gtkobject -> int -> int -> unit
      = "mlgtk_button_box_set_child_ipadding"
    external button_box_set_layout :
      gtkobject -> button_box_layout_style -> unit
      = "mlgtk_button_box_set_layout"
    external button_box_get_spacing : gtkobject -> int
      = "mlgtk_button_box_get_spacing"
    external button_box_get_child_size : gtkobject -> int * int
      = "mlgtk_button_box_get_child_size"
    external button_box_get_child_ipadding : gtkobject -> int * int
      = "mlgtk_button_box_get_child_ipadding"
    external button_box_get_layout : gtkobject -> button_box_layout_style
      = "mlgtk_button_box_get_layout"
    external button_new : unit -> gtkobject = "gtk_button_new"
    external button_new_with_label : string -> gtkobject
      = "mlgtk_button_new_with_label"
    external button_pressed : gtkobject -> unit = "mlgtk_button_pressed"
    external button_released : gtkobject -> unit = "mlgtk_button_released"
    external button_clicked : gtkobject -> unit = "mlgtk_button_clicked"
    external button_enter : gtkobject -> unit = "mlgtk_button_enter"
    external button_leave : gtkobject -> unit = "mlgtk_button_leave"
    external check_button_new : unit -> gtkobject = "gtk_check_button_new"
    external check_button_new_with_label : string -> gtkobject
      = "mlgtk_check_button_new_with_label"
    external check_menu_item_new : unit -> gtkobject
      = "gtk_check_menu_item_new"
    external check_menu_item_new_with_label : string -> gtkobject
      = "mlgtk_check_menu_item_new_with_label"
    external check_menu_item_set_state : gtkobject -> bool -> unit
      = "mlgtk_check_menu_item_set_state"
    external check_menu_item_toggled : gtkobject -> unit
      = "mlgtk_check_menu_item_toggled"
    external clist_new : int -> gtkobject = "mlgtk_clist_new"
    external clist_set_border : gtkobject -> shadow_type -> unit
      = "mlgtk_clist_set_border"
    external clist_set_selection_mode : gtkobject -> selection_type -> unit
      = "mlgtk_clist_set_selection_mode"
    external clist_freeze : gtkobject -> unit = "mlgtk_clist_freeze"
    external clist_thaw : gtkobject -> unit = "mlgtk_clist_thaw"
    external clist_column_titles_show : gtkobject -> unit
      = "mlgtk_clist_column_titles_show"
    external clist_column_titles_hide : gtkobject -> unit
      = "mlgtk_clist_column_titles_hide"
    external clist_set_column_title : gtkobject -> int -> string -> unit
      = "mlgtk_clist_set_column_title"
    external clist_set_column_widget : gtkobject -> int -> gtkobject -> unit
      = "mlgtk_clist_set_column_widget"
    external clist_set_column_justification :
      gtkobject -> int -> justification -> unit
      = "mlgtk_clist_set_column_justification"
    external clist_set_column_width : gtkobject -> int -> int -> unit
      = "mlgtk_clist_set_column_width"
    external clist_set_row_height : gtkobject -> int -> unit
      = "mlgtk_clist_set_row_height"
    external clist_moveto : gtkobject -> int -> int -> float -> float -> unit
      = "mlgtk_clist_moveto"
    external clist_set_text : gtkobject -> int -> int -> string -> unit
      = "mlgtk_clist_set_text"
    external clist_get_text : gtkobject -> int -> int -> string
      = "mlgtk_clist_get_text"
    external clist_set_shift : gtkobject -> int -> int -> int -> int -> unit
      = "mlgtk_clist_set_shift"
    external clist_append : gtkobject -> string array -> int
      = "mlgtk_clist_append"
    external clist_prepend : gtkobject -> string array -> int
      = "mlgtk_clist_prepend"
    external clist_insert : gtkobject -> int -> string array -> unit
      = "mlgtk_clist_insert"
    external clist_remove : gtkobject -> int -> unit = "mlgtk_clist_remove"
    external clist_set_row_data : gtkobject -> int -> 'a -> unit
      = "mlgtk_clist_set_row_data"
    external clist_get_row_data : gtkobject -> int -> 'a
      = "mlgtk_clist_get_row_data"
    external clist_select_row : gtkobject -> int -> int -> unit
      = "mlgtk_clist_select_row"
    external clist_unselect_row : gtkobject -> int -> int -> unit
      = "mlgtk_clist_unselect_row"
    external clist_clear : gtkobject -> unit = "mlgtk_clist_clear"
    external color_selection_new : unit -> gtkobject
      = "gtk_color_selection_new"
    external color_selection_set_update_policy :
      gtkobject -> update_policy -> unit
      = "mlgtk_color_selection_set_update_policy"
    external color_selection_set_color :
      gtkobject -> float * float * float * float -> unit
      = "mlgtk_color_selection_set_color"
    external color_selection_get_color :
      gtkobject -> float * float * float * float
      = "mlgtk_color_selection_get_color"
    external color_selection_set_opacity : gtkobject -> bool -> unit
      = "mlgtk_color_selection_set_opacity"
    external combo_new : unit -> gtkobject = "gtk_combo_new"
    external combo_set_value_in_list : gtkobject -> bool -> bool -> unit
      = "mlgtk_combo_set_value_in_list"
    external combo_set_use_arrows : gtkobject -> bool -> unit
      = "mlgtk_combo_set_use_arrows"
    external combo_set_use_arrows_always : gtkobject -> bool -> unit
      = "mlgtk_combo_set_use_arrows_always"
    external combo_set_case_sensitive : gtkobject -> bool -> unit
      = "mlgtk_combo_set_case_sensitive"
    external combo_set_item_string : gtkobject -> gtkobject -> string -> unit
      = "mlgtk_combo_set_item_string"
    external combo_set_popdown_strings :
      gtkobject -> gtkobject Glib.GList.t -> unit
      = "mlgtk_combo_set_popdown_strings"
    external combo_get_entry : gtkobject -> gtkobject
      = "mlgtk_combo_get_entry"
    external combo_get_button : gtkobject -> gtkobject
      = "mlgtk_combo_get_button"
    external combo_disable_activate : gtkobject -> unit
      = "mlgtk_combo_disable_activate"
    external container_border_width : gtkobject -> int -> unit
      = "mlgtk_container_border_width"
    external container_add : gtkobject -> gtkobject -> unit
      = "mlgtk_container_add"
    external container_remove : gtkobject -> gtkobject -> unit
      = "mlgtk_container_remove"
    external container_block_resize : gtkobject -> unit
      = "mlgtk_container_block_resize"
    external container_unblock_resize : gtkobject -> unit
      = "mlgtk_container_unblock_resize"
    external container_need_resize : gtkobject -> unit
      = "mlgtk_container_need_resize"
    external container_foreach : gtkobject -> (gtkobject -> unit) -> unit
      = "mlgtk_container_foreach"
    external container_focus : gtkobject -> direction_type -> unit
      = "mlgtk_container_focus"
    external container_children : gtkobject -> gtkobject Glib.GList.t
      = "gtk_container_children"
    external curve_new : unit -> gtkobject = "gtk_curve_new"
    external curve_reset : gtkobject -> unit = "mlgtk_curve_reset"
    external curve_set_gamma : gtkobject -> float -> unit
      = "mlgtk_curve_set_gamma"
    external curve_set_range :
      gtkobject -> float -> float -> float -> float -> unit
      = "mlgtk_curve_set_range"
    external curve_get_vector : gtkobject -> float array -> unit
      = "mlgtk_curve_get_vector"
    external curve_set_vector : gtkobject -> float array -> unit
      = "mlgtk_curve_set_vector"
    external curve_set_curve_type : gtkobject -> curve_type -> unit
      = "mlgtk_curve_set_curve_type"
    external gamma_curve_new : unit -> gtkobject = "gtk_gamma_curve_new"
    external dialog_new : unit -> gtkobject = "gtk_dialog_new"
    external dialog_get_action_area : gtkobject -> gtkobject
      = "mlgtk_dialog_get_action_area"
    external dialog_get_vbox : gtkobject -> gtkobject
      = "mlgtk_dialog_get_vbox"
    external drawing_area_new : unit -> gtkobject = "gtk_drawing_area_new"
    external drawing_area_size : gtkobject -> int -> int -> unit
      = "mlgtk_drawing_area_size"
    external entry_new : unit -> gtkobject = "mlgtk_entry_new"
    external entry_new_with_max_length : int -> gtkobject
      = "mlgtk_entry_new_with_max_length"
    external entry_set_text : gtkobject -> string -> unit
      = "mlgtk_entry_set_text"
    external entry_append_text : gtkobject -> string -> unit
      = "mlgtk_entry_append_text"
    external entry_prepend_text : gtkobject -> string -> unit
      = "mlgtk_entry_prepend_text"
    external entry_set_position : gtkobject -> int -> unit
      = "mlgtk_entry_set_position"
    external entry_set_visibility : gtkobject -> int -> unit
      = "mlgtk_entry_set_visibility"
    external entry_get_text : gtkobject -> string = "mlgtk_entry_get_text"
    external file_selection_new : string -> gtkobject
      = "mlgtk_file_selection_new"
    external file_selection_set_filename : gtkobject -> string -> unit
      = "mlgtk_file_selection_set_filename"
    external file_selection_get_filename : gtkobject -> string
      = "mlgtk_file_selection_get_filename"
    external file_selection_get_ok_button : gtkobject -> gtkobject
      = "mlgtk_file_selection_get_ok_button"
    external file_selection_get_cancel_button : gtkobject -> gtkobject
      = "mlgtk_file_selection_get_cancel_button"
    external file_selection_get_help_button : gtkobject -> gtkobject
      = "mlgtk_file_selection_get_help_button"
    external file_selection_get_dir_list : gtkobject -> gtkobject
      = "mlgtk_file_selection_get_dir_list"
    external file_selection_get_file_list : gtkobject -> gtkobject
      = "mlgtk_file_selection_get_file_list"
    external file_selection_get_selection_entry : gtkobject -> gtkobject
      = "mlgtk_file_selection_get_selection_entry"
    external file_selection_get_selection_text : gtkobject -> gtkobject
      = "mlgtk_file_selection_get_selection_text"
    external file_selection_get_main_vbox : gtkobject -> gtkobject
      = "mlgtk_file_selection_get_main_vbox"
    external frame_new : string -> gtkobject = "mlgtk_frame_new"
    external frame_set_label : gtkobject -> string -> unit
      = "mlgtk_frame_set_label"
    external frame_set_label_align : gtkobject -> float -> float -> unit
      = "mlgtk_frame_set_label_align"
    external frame_set_shadow_type : gtkobject -> shadow_type -> unit
      = "mlgtk_frame_set_shadow_type"
    external hbox_new : bool -> int -> gtkobject = "mlgtk_hbox_new"
    external hbutton_box_new : unit -> gtkobject = "gtk_hbutton_box_new"
    external hpaned_new : unit -> gtkobject = "mlgtk_hpaned_new"
    external hscrollbar_new : gtkobject option -> gtkobject
      = "mlgtk_hscrollbar_new"
    external hseparator_new : unit -> gtkobject = "mlgtk_hseparator_new"
    external label_new : string -> gtkobject = "mlgtk_label_new"
    external label_set_text : gtkobject -> string -> unit
      = "mlgtk_label_set_text"
    external label_get : gtkobject -> string = "mlgtk_label_get"
    external list_new : unit -> gtkobject = "mlgtk_list_new"
    external list_insert_items :
      gtkobject -> gtkobject Glib.GList.t -> int -> unit
      = "mlgtk_list_insert_items"
    external list_append_items : gtkobject -> gtkobject Glib.GList.t -> unit
      = "mlgtk_list_append_items"
    external list_item_new_with_label : string -> gtkobject
      = "mlgtk_list_item_new_with_label"
    external menu_new : unit -> gtkobject = "mlgtk_menu_new"
    external menu_append : gtkobject -> gtkobject -> unit
      = "mlgtk_menu_append"
    external menu_prepend : gtkobject -> gtkobject -> unit
      = "mlgtk_menu_prepend"
    external menu_insert : gtkobject -> gtkobject -> int -> unit
      = "mlgtk_menu_insert"
    external menu_popdown : gtkobject -> unit = "mlgtk_menu_popdown"
    external menu_get_active : gtkobject -> gtkobject
      = "mlgtk_menu_get_active"
    external menu_set_active : gtkobject -> int -> gtkobject
      = "mlgtk_menu_set_active"
    external menu_bar_new : unit -> gtkobject = "mlgtk_menu_bar_new"
    external menu_bar_append : gtkobject -> gtkobject -> unit
      = "mlgtk_menu_bar_append"
    external menu_bar_prepend : gtkobject -> gtkobject -> unit
      = "mlgtk_menu_bar_prepend"
    external menu_bar_insert : gtkobject -> gtkobject -> int -> unit
      = "mlgtk_menu_bar_insert"
    external menu_item_new : unit -> gtkobject = "gtk_menu_item_new"
    external menu_item_new_with_label : string -> gtkobject
      = "mlgtk_menu_item_new_with_label"
    external menu_item_set_submenu : gtkobject -> gtkobject -> unit
      = "mlgtk_menu_item_set_submenu"
    external menu_item_select : gtkobject -> unit = "mlgtk_menu_item_select"
    external menu_item_deselect : gtkobject -> unit
      = "mlgtk_menu_item_deselect"
    external menu_shell_append : gtkobject -> gtkobject -> unit
      = "mlgtk_menu_shell_append"
    external menu_shell_prepend : gtkobject -> gtkobject -> unit
      = "mlgtk_menu_shell_prepend"
    external menu_shell_insert : gtkobject -> gtkobject -> int -> unit
      = "mlgtk_menu_shell_insert"
    external notebook_new : unit -> gtkobject = "mlgtk_notebook_new"
    external notebook_append_page :
      gtkobject -> gtkobject -> gtkobject -> unit
      = "mlgtk_notebook_append_page"
    external notebook_prepend_page :
      gtkobject -> gtkobject -> gtkobject -> unit
      = "mlgtk_notebook_prepend_page"
    external notebook_insert_page :
      gtkobject -> gtkobject -> gtkobject -> int -> unit
      = "mlgtk_notebook_insert_page"
    external notebook_remove_page : gtkobject -> int -> unit
      = "mlgtk_notebook_remove_page"
    external notebook_set_page : gtkobject -> int -> unit
      = "mlgtk_notebook_set_page"
    external notebook_get_current_page : gtkobject -> int
      = "mlgtk_notebook_get_current_page"
    external notebook_next_page : gtkobject -> unit
      = "mlgtk_notebook_next_page"
    external notebook_prev_page : gtkobject -> unit
      = "mlgtk_notebook_prev_page"
    external notebook_set_tab_pos : gtkobject -> position_type -> unit
      = "mlgtk_notebook_set_tab_pos"
    external notebook_set_show_tabs : gtkobject -> bool -> unit
      = "mlgtk_notebook_set_show_tabs"
    external notebook_set_show_border : gtkobject -> bool -> unit
      = "mlgtk_notebook_set_show_border"
    external notebook_set_scrollable : gtkobject -> bool -> unit
      = "mlgtk_notebook_set_scrollable"
    external paned_add1 : gtkobject -> gtkobject -> unit = "mlgtk_paned_add1"
    external paned_add2 : gtkobject -> gtkobject -> unit = "mlgtk_paned_add2"
    external paned_handle_size_unsafe : gtkobject -> int -> unit
      = "mlgtk_paned_handle_size"
    external paned_gutter_size_unsafe : gtkobject -> int -> unit
      = "mlgtk_paned_gutter_size"
    val paned_handle_size : gtkobject -> int -> unit
    val paned_gutter_size : gtkobject -> int -> unit
    external pixmap_new : Gdk.pixmap -> Gdk.bitmap -> gtkobject
      = "mlgtk_pixmap_new"
    external progress_bar_new : unit -> gtkobject = "mlgtk_progress_bar_new"
    external progress_bar_update : gtkobject -> float -> unit
      = "mlgtk_progress_bar_update"
    external radio_button_new_with_label :
      gtkobject Glib.GSList.t option -> string -> gtkobject
      = "mlgtk_radio_button_new_with_label"
    external radio_button_group : gtkobject -> gtkobject Glib.GSList.t
      = "gtk_radio_button_group"
    external radio_menu_item_new_with_label :
      gtkobject Glib.GSList.t option -> string -> gtkobject
      = "mlgtk_radio_menu_item_new_with_label"
    external radio_menu_item_group : gtkobject -> gtkobject Glib.GSList.t
      = "gtk_radio_menu_item_group"
    external scrolled_window_new : unit -> gtkobject
      = "mlgtk_scrolled_window_new"
    external scrolled_window_add_with_viewport :
      gtkobject -> gtkobject -> unit
      = "mlgtk_scrolled_window_add_with_viewport"
    external statusbar_new : unit -> gtkobject = "mlgtk_statusbar_new"
    external statusbar_get_context_id : gtkobject -> string -> int
      = "mlgtk_statusbar_get_context_id"
    external statusbar_push : gtkobject -> int -> string -> int
      = "mlgtk_statusbar_push"
    external statusbar_pop : gtkobject -> int -> unit = "mlgtk_statusbar_pop"
    external statusbar_remove : gtkobject -> int -> int -> unit
      = "mlgtk_statusbar_remove"
    type option_mask = | GTK_FILL | GTK_SHRINK | GTK_EXPAND
    external table_new : int -> int -> bool -> gtkobject = "mlgtk_table_new"
    external table_attach :
      gtkobject ->
      gtkobject ->
      int ->
      int ->
      int ->
      int -> option_mask list -> option_mask list -> int -> int -> unit
      = "mlgtk_true_table_attach" "mlgtk_table_attach"
    external text_new : unit -> gtkobject = "mlgtk_text_new"
    external text_set_editable : gtkobject -> bool -> unit
      = "mlgtk_text_set_editable"
    external text_set_word_wrap : gtkobject -> bool -> unit
      = "mlgtk_text_set_word_wrap"
    external text_get_vadj : gtkobject -> gtkobject = "mlgtk_text_get_vadj"
    external text_get_hadj : gtkobject -> gtkobject = "mlgtk_text_get_hadj"
    external text_get_point : gtkobject -> int = "mlgtk_text_get_point"
    external text_set_point : gtkobject -> int -> unit
      = "mlgtk_text_set_point"
    external text_get_length : gtkobject -> int = "mlgtk_text_get_length"
    external text_freeze : gtkobject -> unit = "mlgtk_text_freeze"
    external text_thaw : gtkobject -> unit = "mlgtk_text_thaw"
    external text_insert :
      gtkobject ->
      Gdk.font option ->
      Gdk.color option -> Gdk.color option -> string -> int -> int -> unit
      = "mlgtk_text_insert"
    external text_forward_delete : gtkobject -> int -> int
      = "mlgtk_text_forward_delete"
    external text_backward_delete : gtkobject -> int -> int
      = "mlgtk_text_backward_delete"
    external toggle_button_new_with_label : string -> gtkobject
      = "mlgtk_toggle_button_new_with_label"
    external toggle_button_new : unit -> gtkobject
      = "mlgtk_toggle_button_new"
    external toggle_button_set_state : gtkobject -> bool -> unit
      = "mlgtk_toggle_button_set_state"
    external toggle_button_set_mode : gtkobject -> bool -> unit
      = "mlgtk_toggle_button_set_mode"
    external toggle_button_toggled : gtkobject -> unit
      = "mlgtk_toggle_button_toggled"
    external toggle_button_set_active : gtkobject -> bool -> unit
      = "mlgtk_toggle_button_set_active"
    external tooltips_new : unit -> gtkobject = "mlgtk_tooltips_new"
    external tooltips_set_tip :
      gtkobject -> gtkobject -> string -> string -> unit
      = "mlgtk_tooltips_set_tip"
    external vbox_new : bool -> int -> gtkobject = "mlgtk_vbox_new"
    external vbutton_box_new : unit -> gtkobject = "gtk_vbutton_box_new"
    external vpaned_new : unit -> gtkobject = "mlgtk_vpaned_new"
    external vscrollbar_new : gtkobject option -> gtkobject
      = "mlgtk_vscrollbar_new"
    external vseparator_new : unit -> gtkobject = "mlgtk_vseparator_new"
    external widget_show : gtkobject -> unit = "mlgtk_widget_show"
    external widget_hide : gtkobject -> unit = "mlgtk_widget_hide"
    external widget_activate: gtkobject -> unit = "mlgtk_widget_activate"
    external widget_grab_focus: gtkobject -> unit = "mlgtk_widget_grab_focus"
    external widget_realize : gtkobject -> unit = "mlgtk_widget_realize"
    external widget_unrealize : gtkobject -> unit = "mlgtk_widget_unrealize"
    external widget_draw : gtkobject -> Gdk.rectangle -> unit
      = "mlgtk_widget_draw"
    external widget_unparent : gtkobject -> unit = "mlgtk_widget_unparent"
    external widget_reparent : gtkobject -> gtkobject -> unit
      = "mlgtk_widget_reparent"
    external widget_set_events : gtkobject -> Gdk.Event.mask list -> unit
      = "mlgtk_widget_set_events"
    external widget_set_sensitive : gtkobject -> bool -> unit
      = "mlgtk_widget_set_sensitive"
    external widget_set_usize : gtkobject -> int -> int -> unit
      = "mlgtk_widget_set_usize"
    external window_new : window_type -> gtkobject = "mlgtk_window_new"
    external window_set_title : gtkobject -> string -> unit
      = "mlgtk_window_set_title"
    external window_of : gtkobject -> Gdk.window = "mlgtk_window_of"
    external style_of : gtkobject -> style = "mlgtk_style_of"
    external fg_gc_of : gtkobject -> int -> Gdk.gc = "mlgtk_fg_gc_of"
    external allocation_of : gtkobject -> allocation = "mlgtk_allocation_of"
    external state_of : gtkobject -> int = "mlgtk_state_of"
    external editable_insert_text : gtkobject -> string -> int -> int -> int
      = "mlgtk_editable_insert_text"
    external editable_select_region : gtkobject -> int -> int -> unit
      = "mlgtk_editable_select_region"
    external editable_get_chars : gtkobject -> int -> int -> string
      = "mlgtk_editable_get_chars"
    external editable_get_position : gtkobject -> int
      = "mlgtk_editable_get_position"
    external object_destroy : gtkobject -> unit = "mlgtk_object_destroy"
    external timeout_add_internal : int -> gtkCallBack -> int
      = "mlgtk_timeout_add"
  end
external button_box_set_child_size_default : int -> int -> unit
  = "mlgtk_button_box_set_child_size_default"
external button_box_set_child_ipadding_default : int -> int -> unit
  = "mlgtk_button_box_set_child_ipadding_default"
external button_box_get_child_size_default : unit -> int * int
  = "mlgtk_button_box_get_child_size_default"
external button_box_get_child_ipadding_default : unit -> int * int
  = "mlgtk_button_box_get_child_ipadding_default"
val timeout_add : int -> (unit -> bool) -> int
external timeout_remove : int -> unit = "mlgtk_timeout_remove"
external main_quit : unit -> unit = "mlgtk_main_quit"
external gtk_init : unit -> unit = "mlgtkthr_init"
external gtk_set_locale : unit -> unit = "mlgtk_set_locale"
external gtk_mainloop : unit -> unit = "mlgtkthr_mainloop"
