module type OutputIterator =
  sig type 'a iterator val write : 'a iterator -> 'a -> 'a iterator end
module type InputIterator =
  sig
    type 'a iterator
    val next : 'a iterator
    val deref : 'a iterator -> 'a option
  end
module type ForwardIterator =
  sig
    type 'a iterator
    val next : 'a iterator -> 'a iterator
    val deref : 'a iterator -> 'a option
    val equal : 'a iterator -> 'a iterator -> bool
  end
module type BiDirectionalIterator =
  sig
    type 'a iterator
    val next : 'a iterator -> 'a iterator
    val prev : 'a iterator -> 'a iterator
    val deref : 'a iterator -> 'a option
    val equal : 'a iterator -> 'a iterator -> bool
  end
module type RandomIterator =
  sig
    type 'a iterator
    val advance : 'a iterator -> int -> 'a iterator
    val retreat : 'a iterator -> int -> 'a iterator
    val next : 'a iterator -> 'a iterator
    val prev : 'a iterator -> 'a iterator
    val deref : 'a iterator -> 'a option
    val equal : 'a iterator -> 'a iterator -> bool
    val less : 'a iterator -> 'a iterator -> bool
  end
module type BiDirectional =
  sig
    type 'a iterator
    val next : 'a iterator -> 'a iterator
    val prev : 'a iterator -> 'a iterator
    val deref : 'a iterator -> 'a option
    val terminal : 'a iterator
    class ['a] dlist :
      object
        method as_list : 'a list
        method first : 'a iterator
        method iter : ('a -> unit) -> unit
        method last : 'a iterator
        method length : int
        method nth : int -> 'a option
        method pop_back : 'a option
        method pop_front : 'a option
        method push_back : 'a -> unit
        method push_front : 'a -> unit
        method terminal : 'a iterator
        method indexed_insert : int -> 'a -> unit
        method indexed_replace : int -> 'a -> unit
        method indexed_delete : int -> unit
      end
    val of_list : 'a list -> 'a dlist
    val map : 'a dlist -> ('a -> 'b) -> 'b dlist
    val create : unit -> 'a dlist
    val concat : 'a dlist -> 'a dlist -> 'a dlist
  end
module DoublyLinkedList : BiDirectional
