
/**
 *
 * GLUT Module for Python
 * 
 * Version: 0.7
 *
 * Date: 96/09/12 (September)
 *
 * Authors: Tom Schwaller     <tom.schwaller@linux-magazin.de>
 *          Jim Hugunin       <jjh@Goldilocks.LCS.MIT.EDU>
 *          David Ascher      <david_ascher@brown.edu>
 * 
 * Notes:
 *
 *   - the file glutconst.py is also needed, as it defines all kinds of
 *     useful constants
 *
 *   - The SGISTEREO define should be on if you want to have access
 *     to the SGI fullscreen stereo control from Python.  This
 *     defines four more calls: start_stereo, stop_stereo, left and right.
 *
 *   - This module should compile as is w/ both GLUT 2 and GLUT 3.
 *
 *
 *   - Note that the Setup line should read something like:
 *
 *     opengl openglmodule.c glut_shapes.c -lGL -lGLU -lnumpymodule
 *     glu glumodule.c  -lGLU
 *     glut glutmodule.c -lGL -lGLU -lglut -lXi -lXmu 
 *     
***/

/* #define SGISTEREO  */


/* ========================== Module glut =========================== */

#include "Python.h"
#include "GL/glut.h"
#include "GL/glutint.h"

static PyObject *glut_Error;

void DeviceButtonPressGrab(void *x, void *y, void *z) {
  printf("help, shouldn't be here\n");
}

void *map_lookup(char *mp[][2], char *nm) {
  int i=0;
  while (mp[i][0] != NULL) {
    if (strcmp(mp[i][0], nm) == 0) {
      return (void *)mp[i][1];
    }
    i = i+1;
  }
  return NULL;
}

char *glutFonts[][2] = {
  {"9by15", (char *)GLUT_BITMAP_9_BY_15},
  {"8by13", (char *)GLUT_BITMAP_8_BY_13},
  {"TimesRoman10", (char *)GLUT_BITMAP_TIMES_ROMAN_10},
  {"TimesRoman24", (char *)GLUT_BITMAP_TIMES_ROMAN_24},
#if (GLUT_API_VERSION >= 3)
  {"Helvetica10", (char *)GLUT_BITMAP_HELVETICA_10},
  {"Helvetica12", (char *)GLUT_BITMAP_HELVETICA_12},
  {"Helvetica18", (char *)GLUT_BITMAP_HELVETICA_18},
  {"StrokeRoman", (char *)GLUT_STROKE_ROMAN},
  {"StrokeRomanFixed", (char *)GLUT_STROKE_MONO_ROMAN},
#endif
  {NULL, NULL},
};

static PyObject *glut_Error;

static PyObject *glut_glutCreateMenuObject;

static PyObject *glut_SetglutCreateMenuCallback(PyObject* self, PyObject* args)
{
  PyObject *func;
  if(!PyArg_ParseTuple(args, "O", &func)) return NULL;
  Py_XDECREF(glut_glutCreateMenuObject);
  glut_glutCreateMenuObject = func;
  Py_INCREF(func);
  Py_INCREF(Py_None);
  return Py_None;
}


static void glutCreateMenuCallback(x)
	int x;
{
	PyObject *_args = NULL;
	PyObject *_res = NULL;
	_args = Py_BuildValue("(i)",
	                      x);
	_res = PyObject_CallObject(glut_glutCreateMenuObject, _args);
	if (_res == NULL) { PyErr_Print();  }
	Py_XDECREF(_res);
}

static PyObject *glut_glutDisplayFuncObject;

static PyObject *glut_SetglutDisplayFuncCallback(PyObject* self, PyObject* args)
{
  PyObject *func;
  if(!PyArg_ParseTuple(args, "O", &func)) return NULL;
  Py_XDECREF(glut_glutDisplayFuncObject);
  glut_glutDisplayFuncObject = func;
  Py_INCREF(func);
  Py_INCREF(Py_None);
  return Py_None;
}


static void glutDisplayFuncCallback()
{
	PyObject *_args = NULL;
	PyObject *_res = NULL;
	_args = Py_BuildValue("()");
	_res = PyObject_CallObject(glut_glutDisplayFuncObject, _args);
	if (_res == NULL) { PyErr_Print();  }
	Py_XDECREF(_res);
}

static PyObject *glut_glutReshapeFuncObject;

static PyObject *glut_SetglutReshapeFuncCallback(PyObject* self, PyObject* args)
{
  PyObject *func;
  if(!PyArg_ParseTuple(args, "O", &func)) return NULL;
  Py_XDECREF(glut_glutReshapeFuncObject);
  glut_glutReshapeFuncObject = func;
  Py_INCREF(func);
  Py_INCREF(Py_None);
  return Py_None;
}


static void glutReshapeFuncCallback(width,
                                    height)
	int width;
	int height;
{
	PyObject *_args = NULL;
	PyObject *_res = NULL;
	_args = Py_BuildValue("(ii)",
	                      width,
	                      height);
	_res = PyObject_CallObject(glut_glutReshapeFuncObject, _args);
	if (_res == NULL) { PyErr_Print();  }
	Py_XDECREF(_res);
}

static PyObject *glut_glutKeyboardFuncObject;

static PyObject *glut_SetglutKeyboardFuncCallback(PyObject* self, PyObject* args)
{
  PyObject *func;
  if(!PyArg_ParseTuple(args, "O", &func)) return NULL;
  Py_XDECREF(glut_glutKeyboardFuncObject);
  glut_glutKeyboardFuncObject = func;
  Py_INCREF(func);
  Py_INCREF(Py_None);
  return Py_None;
}


static void glutKeyboardFuncCallback(key,
                                     x,
                                     y)
	char key;
	int x;
	int y;
{
	PyObject *_args = NULL;
	PyObject *_res = NULL;
	_args = Py_BuildValue("(cii)",
	                      key,
	                      x,
	                      y);
	_res = PyObject_CallObject(glut_glutKeyboardFuncObject, _args);
	if (_res == NULL) { PyErr_Print();  }
	Py_XDECREF(_res);
}

static PyObject *glut_glutMouseFuncObject;

static PyObject *glut_SetglutMouseFuncCallback(PyObject* self, PyObject* args)
{
  PyObject *func;
  if(!PyArg_ParseTuple(args, "O", &func)) return NULL;
  Py_XDECREF(glut_glutMouseFuncObject);
  glut_glutMouseFuncObject = func;
  Py_INCREF(func);
  Py_INCREF(Py_None);
  return Py_None;
}


static void glutMouseFuncCallback(button,
                                  state,
                                  x,
                                  y)
	int button;
	int state;
	int x;
	int y;
{
	PyObject *_args = NULL;
	PyObject *_res = NULL;
	_args = Py_BuildValue("(iiii)",
	                      button,
	                      state,
	                      x,
	                      y);
	_res = PyObject_CallObject(glut_glutMouseFuncObject, _args);
	if (_res == NULL) { PyErr_Print();  }
	Py_XDECREF(_res);
}

static PyObject *glut_glutMotionFuncObject;

static PyObject *glut_SetglutMotionFuncCallback(PyObject* self, PyObject* args)
{
  PyObject *func;
  if(!PyArg_ParseTuple(args, "O", &func)) return NULL;
  Py_XDECREF(glut_glutMotionFuncObject);
  glut_glutMotionFuncObject = func;
  Py_INCREF(func);
  Py_INCREF(Py_None);
  return Py_None;
}


static void glutMotionFuncCallback(x,
                                   y)
	int x;
	int y;
{
	PyObject *_args = NULL;
	PyObject *_res = NULL;
	_args = Py_BuildValue("(ii)",
	                      x,
	                      y);
	_res = PyObject_CallObject(glut_glutMotionFuncObject, _args);
	if (_res == NULL) { PyErr_Print();  }
	Py_XDECREF(_res);
}

static PyObject *glut_glutPassiveMotionFuncObject;

static PyObject *glut_SetglutPassiveMotionFuncCallback(PyObject* self, PyObject* args)
{
  PyObject *func;
  if(!PyArg_ParseTuple(args, "O", &func)) return NULL;
  Py_XDECREF(glut_glutPassiveMotionFuncObject);
  glut_glutPassiveMotionFuncObject = func;
  Py_INCREF(func);
  Py_INCREF(Py_None);
  return Py_None;
}


static void glutPassiveMotionFuncCallback(x,
                                          y)
	int x;
	int y;
{
	PyObject *_args = NULL;
	PyObject *_res = NULL;
	_args = Py_BuildValue("(ii)",
	                      x,
	                      y);
	_res = PyObject_CallObject(glut_glutPassiveMotionFuncObject, _args);
	if (_res == NULL) { PyErr_Print();  }
	Py_XDECREF(_res);
}

static PyObject *glut_glutEntryFuncObject;

static PyObject *glut_SetglutEntryFuncCallback(PyObject* self, PyObject* args)
{
  PyObject *func;
  if(!PyArg_ParseTuple(args, "O", &func)) return NULL;
  Py_XDECREF(glut_glutEntryFuncObject);
  glut_glutEntryFuncObject = func;
  Py_INCREF(func);
  Py_INCREF(Py_None);
  return Py_None;
}


static void glutEntryFuncCallback(state)
	int state;
{
	PyObject *_args = NULL;
	PyObject *_res = NULL;
	_args = Py_BuildValue("(i)",
	                      state);
	_res = PyObject_CallObject(glut_glutEntryFuncObject, _args);
	if (_res == NULL) { PyErr_Print();  }
	Py_XDECREF(_res);
}

static PyObject *glut_glutVisibilityFuncObject;

static PyObject *glut_SetglutVisibilityFuncCallback(PyObject* self, PyObject* args)
{
  PyObject *func;
  if(!PyArg_ParseTuple(args, "O", &func)) return NULL;
  Py_XDECREF(glut_glutVisibilityFuncObject);
  glut_glutVisibilityFuncObject = func;
  Py_INCREF(func);
  Py_INCREF(Py_None);
  return Py_None;
}


static void glutVisibilityFuncCallback(state)
	int state;
{
	PyObject *_args = NULL;
	PyObject *_res = NULL;
	_args = Py_BuildValue("(i)",
	                      state);
	_res = PyObject_CallObject(glut_glutVisibilityFuncObject, _args);
	if (_res == NULL) { PyErr_Print();  }
	Py_XDECREF(_res);
}

static PyObject *glut_glutIdleFuncObject;

static PyObject *glut_SetglutIdleFuncCallback(PyObject* self, PyObject* args)
{
  PyObject *func;
  if(!PyArg_ParseTuple(args, "O", &func)) return NULL;
  Py_XDECREF(glut_glutIdleFuncObject);
  glut_glutIdleFuncObject = func;
  Py_INCREF(func);
  Py_INCREF(Py_None);
  return Py_None;
}


static void glutIdleFuncCallback()
{
	PyObject *_args = NULL;
	PyObject *_res = NULL;
	_args = Py_BuildValue("()");
	_res = PyObject_CallObject(glut_glutIdleFuncObject, _args);
	if (_res == NULL) { PyErr_Print();  }
	Py_XDECREF(_res);
}

static PyObject *glut_glutTimerFuncObject;

static PyObject *glut_SetglutTimerFuncCallback(PyObject* self, PyObject* args)
{
  PyObject *func;
  if(!PyArg_ParseTuple(args, "O", &func)) return NULL;
  Py_XDECREF(glut_glutTimerFuncObject);
  glut_glutTimerFuncObject = func;
  Py_INCREF(func);
  Py_INCREF(Py_None);
  return Py_None;
}


static void glutTimerFuncCallback(value)
	int value;
{
	PyObject *_args = NULL;
	PyObject *_res = NULL;
	_args = Py_BuildValue("(i)",
	                      value);
	_res = PyObject_CallObject(glut_glutTimerFuncObject, _args);
	if (_res == NULL) { PyErr_Print();  }
	Py_XDECREF(_res);
}

static PyObject *glut_glutMenuStateFuncObject;

static PyObject *glut_SetglutMenuStateFuncCallback(PyObject* self, PyObject* args)
{
  PyObject *func;
  if(!PyArg_ParseTuple(args, "O", &func)) return NULL;
  Py_XDECREF(glut_glutMenuStateFuncObject);
  glut_glutMenuStateFuncObject = func;
  Py_INCREF(func);
  Py_INCREF(Py_None);
  return Py_None;
}


static void glutMenuStateFuncCallback(state)
	int state;
{
	PyObject *_args = NULL;
	PyObject *_res = NULL;
	_args = Py_BuildValue("(i)",
	                      state);
	_res = PyObject_CallObject(glut_glutMenuStateFuncObject, _args);
	if (_res == NULL) { PyErr_Print();  }
	Py_XDECREF(_res);
}

static PyObject *glut_glutSpecialFuncObject;

static PyObject *glut_SetglutSpecialFuncCallback(PyObject* self, PyObject* args)
{
  PyObject *func;
  if(!PyArg_ParseTuple(args, "O", &func)) return NULL;
  Py_XDECREF(glut_glutSpecialFuncObject);
  glut_glutSpecialFuncObject = func;
  Py_INCREF(func);
  Py_INCREF(Py_None);
  return Py_None;
}


static void glutSpecialFuncCallback(key,
                                    x,
                                    y)
	int key;
	int x;
	int y;
{
	PyObject *_args = NULL;
	PyObject *_res = NULL;
	_args = Py_BuildValue("(iii)",
	                      key,
	                      x,
	                      y);
	_res = PyObject_CallObject(glut_glutSpecialFuncObject, _args);
	if (_res == NULL) { PyErr_Print();  }
	Py_XDECREF(_res);
}

static PyObject *glut_glutSpaceballMotionFuncObject;

static PyObject *glut_SetglutSpaceballMotionFuncCallback(PyObject* self, PyObject* args)
{
  PyObject *func;
  if(!PyArg_ParseTuple(args, "O", &func)) return NULL;
  Py_XDECREF(glut_glutSpaceballMotionFuncObject);
  glut_glutSpaceballMotionFuncObject = func;
  Py_INCREF(func);
  Py_INCREF(Py_None);
  return Py_None;
}


static void glutSpaceballMotionFuncCallback(x,
                                            y,
                                            z)
	int x;
	int y;
	int z;
{
	PyObject *_args = NULL;
	PyObject *_res = NULL;
	_args = Py_BuildValue("(iii)",
	                      x,
	                      y,
	                      z);
	_res = PyObject_CallObject(glut_glutSpaceballMotionFuncObject, _args);
	if (_res == NULL) { PyErr_Print();  }
	Py_XDECREF(_res);
}

static PyObject *glut_glutSpaceballRotateFuncObject;

static PyObject *glut_SetglutSpaceballRotateFuncCallback(PyObject* self, PyObject* args)
{
  PyObject *func;
  if(!PyArg_ParseTuple(args, "O", &func)) return NULL;
  Py_XDECREF(glut_glutSpaceballRotateFuncObject);
  glut_glutSpaceballRotateFuncObject = func;
  Py_INCREF(func);
  Py_INCREF(Py_None);
  return Py_None;
}


static void glutSpaceballRotateFuncCallback(x,
                                            y,
                                            z)
	int x;
	int y;
	int z;
{
	PyObject *_args = NULL;
	PyObject *_res = NULL;
	_args = Py_BuildValue("(iii)",
	                      x,
	                      y,
	                      z);
	_res = PyObject_CallObject(glut_glutSpaceballRotateFuncObject, _args);
	if (_res == NULL) { PyErr_Print();  }
	Py_XDECREF(_res);
}

static PyObject *glut_glutSpaceballButtonFuncObject;

static PyObject *glut_SetglutSpaceballButtonFuncCallback(PyObject* self, PyObject* args)
{
  PyObject *func;
  if(!PyArg_ParseTuple(args, "O", &func)) return NULL;
  Py_XDECREF(glut_glutSpaceballButtonFuncObject);
  glut_glutSpaceballButtonFuncObject = func;
  Py_INCREF(func);
  Py_INCREF(Py_None);
  return Py_None;
}


static void glutSpaceballButtonFuncCallback(button,
                                            state)
	int button;
	int state;
{
	PyObject *_args = NULL;
	PyObject *_res = NULL;
	_args = Py_BuildValue("(ii)",
	                      button,
	                      state);
	_res = PyObject_CallObject(glut_glutSpaceballButtonFuncObject, _args);
	if (_res == NULL) { PyErr_Print();  }
	Py_XDECREF(_res);
}

static PyObject *glut_glutButtonBoxFuncObject;

static PyObject *glut_SetglutButtonBoxFuncCallback(PyObject* self, PyObject* args)
{
  PyObject *func;
  if(!PyArg_ParseTuple(args, "O", &func)) return NULL;
  Py_XDECREF(glut_glutButtonBoxFuncObject);
  glut_glutButtonBoxFuncObject = func;
  Py_INCREF(func);
  Py_INCREF(Py_None);
  return Py_None;
}


static void glutButtonBoxFuncCallback(button,
                                      state)
	int button;
	int state;
{
	PyObject *_args = NULL;
	PyObject *_res = NULL;
	_args = Py_BuildValue("(ii)",
	                      button,
	                      state);
	_res = PyObject_CallObject(glut_glutButtonBoxFuncObject, _args);
	if (_res == NULL) { PyErr_Print();  }
	Py_XDECREF(_res);
}

static PyObject *glut_glutDialsFuncObject;

static PyObject *glut_SetglutDialsFuncCallback(PyObject* self, PyObject* args)
{
  PyObject *func;
  if(!PyArg_ParseTuple(args, "O", &func)) return NULL;
  Py_XDECREF(glut_glutDialsFuncObject);
  glut_glutDialsFuncObject = func;
  Py_INCREF(func);
  Py_INCREF(Py_None);
  return Py_None;
}


static void glutDialsFuncCallback(dial,
                                  value)
	int dial;
	int value;
{
	PyObject *_args = NULL;
	PyObject *_res = NULL;
	_args = Py_BuildValue("(ii)",
	                      dial,
	                      value);
	_res = PyObject_CallObject(glut_glutDialsFuncObject, _args);
	if (_res == NULL) { PyErr_Print();  }
	Py_XDECREF(_res);
}

static PyObject *glut_glutTabletMotionFuncObject;

static PyObject *glut_SetglutTabletMotionFuncCallback(PyObject* self, PyObject* args)
{
  PyObject *func;
  if(!PyArg_ParseTuple(args, "O", &func)) return NULL;
  Py_XDECREF(glut_glutTabletMotionFuncObject);
  glut_glutTabletMotionFuncObject = func;
  Py_INCREF(func);
  Py_INCREF(Py_None);
  return Py_None;
}


static void glutTabletMotionFuncCallback(x,
                                         y)
	int x;
	int y;
{
	PyObject *_args = NULL;
	PyObject *_res = NULL;
	_args = Py_BuildValue("(ii)",
	                      x,
	                      y);
	_res = PyObject_CallObject(glut_glutTabletMotionFuncObject, _args);
	if (_res == NULL) { PyErr_Print();  }
	Py_XDECREF(_res);
}

static PyObject *glut_glutTabletButtonFuncObject;

static PyObject *glut_SetglutTabletButtonFuncCallback(PyObject* self, PyObject* args)
{
  PyObject *func;
  if(!PyArg_ParseTuple(args, "O", &func)) return NULL;
  Py_XDECREF(glut_glutTabletButtonFuncObject);
  glut_glutTabletButtonFuncObject = func;
  Py_INCREF(func);
  Py_INCREF(Py_None);
  return Py_None;
}


static void glutTabletButtonFuncCallback(button,
                                         state,
                                         x,
                                         y)
	int button;
	int state;
	int x;
	int y;
{
	PyObject *_args = NULL;
	PyObject *_res = NULL;
	_args = Py_BuildValue("(iiii)",
	                      button,
	                      state,
	                      x,
	                      y);
	_res = PyObject_CallObject(glut_glutTabletButtonFuncObject, _args);
	if (_res == NULL) { PyErr_Print();  }
	Py_XDECREF(_res);
}

#if (GLUT_API_VERSION >= 3)
static PyObject *glut_glutMenuStatusFuncObject;

static PyObject *glut_SetglutMenuStatusFuncCallback(PyObject* self, PyObject* args)
{
  PyObject *func;
  if(!PyArg_ParseTuple(args, "O", &func)) return NULL;
  Py_XDECREF(glut_glutMenuStatusFuncObject);
  glut_glutMenuStatusFuncObject = func;
  Py_INCREF(func);
  Py_INCREF(Py_None);
  return Py_None;
}


static void glutMenuStatusFuncCallback(status,
                                       x,
                                       y)
	int status;
	int x;
	int y;
{
	PyObject *_args = NULL;
	PyObject *_res = NULL;
	_args = Py_BuildValue("(iii)",
	                      status,
	                      x,
	                      y);
	_res = PyObject_CallObject(glut_glutMenuStatusFuncObject, _args);
	if (_res == NULL) { PyErr_Print();  }
	Py_XDECREF(_res);
}

static PyObject *glut_glutOverlayDisplayFuncObject;

static PyObject *glut_SetglutOverlayDisplayFuncCallback(PyObject* self, PyObject* args)
{
  PyObject *func;
  if(!PyArg_ParseTuple(args, "O", &func)) return NULL;
  Py_XDECREF(glut_glutOverlayDisplayFuncObject);
  glut_glutOverlayDisplayFuncObject = func;
  Py_INCREF(func);
  Py_INCREF(Py_None);
  return Py_None;
}


static void glutOverlayDisplayFuncCallback()
{
	PyObject *_args = NULL;
	PyObject *_res = NULL;
	_args = Py_BuildValue("()");
	_res = PyObject_CallObject(glut_glutOverlayDisplayFuncObject, _args);
	if (_res == NULL) { PyErr_Print();  }
	Py_XDECREF(_res);
}
#endif

static PyObject *glut_glutInit(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int argcp = 1;
	char* argv;
	if (!PyArg_ParseTuple(_args, "s",
	                      &argv))
		return NULL;
	glutInit(&argcp,
	         &argv);
	_res = Py_BuildValue("i",
	                     argcp);
	return _res;
}

static PyObject *glut_glutInitDisplayMode(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int mode;
	if (!PyArg_ParseTuple(_args, "i",
	                      &mode))
		return NULL;
	glutInitDisplayMode(mode);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutInitWindowPosition(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int x;
	int y;
	if (!PyArg_ParseTuple(_args, "ii",
	                      &x,
	                      &y))
		return NULL;
	glutInitWindowPosition(x,
	                       y);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutInitWindowSize(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int width;
	int height;
	if (!PyArg_ParseTuple(_args, "ii",
	                      &width,
	                      &height))
		return NULL;
	glutInitWindowSize(width,
	                   height);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutMainLoop(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutMainLoop();
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutCreateWindow(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int _rv;
	char* title;
	if (!PyArg_ParseTuple(_args, "s",
	                      &title))
		return NULL;
	_rv = glutCreateWindow(title);
	_res = Py_BuildValue("i",
	                     _rv);
	return _res;
}

static PyObject *glut_glutCreateSubWindow(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int _rv;
	int win;
	int x;
	int y;
	int width;
	int height;
	if (!PyArg_ParseTuple(_args, "iiiii",
	                      &win,
	                      &x,
	                      &y,
	                      &width,
	                      &height))
		return NULL;
	_rv = glutCreateSubWindow(win,
	                          x,
	                          y,
	                          width,
	                          height);
	_res = Py_BuildValue("i",
	                     _rv);
	return _res;
}

static PyObject *glut_glutDestroyWindow(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int win;
	if (!PyArg_ParseTuple(_args, "i",
	                      &win))
		return NULL;
	glutDestroyWindow(win);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutPostRedisplay(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutPostRedisplay();
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutSwapBuffers(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutSwapBuffers();
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutGetWindow(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int _rv;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	_rv = glutGetWindow();
	_res = Py_BuildValue("i",
	                     _rv);
	return _res;
}

static PyObject *glut_glutSetWindow(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int win;
	if (!PyArg_ParseTuple(_args, "i",
	                      &win))
		return NULL;
	glutSetWindow(win);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutSetWindowTitle(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	char* title;
	if (!PyArg_ParseTuple(_args, "s",
	                      &title))
		return NULL;
	glutSetWindowTitle(title);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutSetIconTitle(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	char* title;
	if (!PyArg_ParseTuple(_args, "s",
	                      &title))
		return NULL;
	glutSetIconTitle(title);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutPositionWindow(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int x;
	int y;
	if (!PyArg_ParseTuple(_args, "ii",
	                      &x,
	                      &y))
		return NULL;
	glutPositionWindow(x,
	                   y);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutReshapeWindow(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int width;
	int height;
	if (!PyArg_ParseTuple(_args, "ii",
	                      &width,
	                      &height))
		return NULL;
	glutReshapeWindow(width,
	                  height);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutPopWindow(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutPopWindow();
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutPushWindow(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutPushWindow();
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutIconifyWindow(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutIconifyWindow();
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutShowWindow(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutShowWindow();
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutHideWindow(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutHideWindow();
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutFullScreen(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutFullScreen();
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutSetCursor(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int cursor;
	if (!PyArg_ParseTuple(_args, "i",
	                      &cursor))
		return NULL;
	glutSetCursor(cursor);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutEstablishOverlay(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutEstablishOverlay();
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutRemoveOverlay(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutRemoveOverlay();
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutUseLayer(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	long layer;
	if (!PyArg_ParseTuple(_args, "l",
	                      &layer))
		return NULL;
	glutUseLayer(layer);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutPostOverlayRedisplay(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutPostOverlayRedisplay();
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutShowOverlay(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutShowOverlay();
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutHideOverlay(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutHideOverlay();
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutCreateMenu(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int _rv;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	_rv = glutCreateMenu(glutCreateMenuCallback);
	_res = Py_BuildValue("i",
	                     _rv);
	return _res;
}

static PyObject *glut_glutDestroyMenu(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int menu;
	if (!PyArg_ParseTuple(_args, "i",
	                      &menu))
		return NULL;
	glutDestroyMenu(menu);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutGetMenu(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int _rv;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	_rv = glutGetMenu();
	_res = Py_BuildValue("i",
	                     _rv);
	return _res;
}

static PyObject *glut_glutSetMenu(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int menu;
	if (!PyArg_ParseTuple(_args, "i",
	                      &menu))
		return NULL;
	glutSetMenu(menu);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutAddMenuEntry(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	char* label;
	int value;
	if (!PyArg_ParseTuple(_args, "si",
	                      &label,
	                      &value))
		return NULL;
	glutAddMenuEntry(label,
	                 value);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutAddSubMenu(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	char* label;
	int submenu;
	if (!PyArg_ParseTuple(_args, "si",
	                      &label,
	                      &submenu))
		return NULL;
	glutAddSubMenu(label,
	               submenu);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutChangeToMenuEntry(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int item;
	char* label;
	int value;
	if (!PyArg_ParseTuple(_args, "isi",
	                      &item,
	                      &label,
	                      &value))
		return NULL;
	glutChangeToMenuEntry(item,
	                      label,
	                      value);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutChangeToSubMenu(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int item;
	char* label;
	int submenu;
	if (!PyArg_ParseTuple(_args, "isi",
	                      &item,
	                      &label,
	                      &submenu))
		return NULL;
	glutChangeToSubMenu(item,
	                    label,
	                    submenu);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutRemoveMenuItem(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int item;
	if (!PyArg_ParseTuple(_args, "i",
	                      &item))
		return NULL;
	glutRemoveMenuItem(item);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutAttachMenu(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int button;
	if (!PyArg_ParseTuple(_args, "i",
	                      &button))
		return NULL;
	glutAttachMenu(button);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutDetachMenu(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int button;
	if (!PyArg_ParseTuple(_args, "i",
	                      &button))
		return NULL;
	glutDetachMenu(button);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutDisplayFunc(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutDisplayFunc(glutDisplayFuncCallback);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutReshapeFunc(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutReshapeFunc(glutReshapeFuncCallback);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutKeyboardFunc(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutKeyboardFunc(glutKeyboardFuncCallback);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutMouseFunc(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutMouseFunc(glutMouseFuncCallback);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutMotionFunc(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutMotionFunc(glutMotionFuncCallback);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutPassiveMotionFunc(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutPassiveMotionFunc(glutPassiveMotionFuncCallback);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutEntryFunc(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutEntryFunc(glutEntryFuncCallback);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutVisibilityFunc(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutVisibilityFunc(glutVisibilityFuncCallback);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutIdleFunc(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutIdleFunc(glutIdleFuncCallback);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutTimerFunc(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int millis;
	int value;
	if (!PyArg_ParseTuple(_args, "ii",
	                      &millis,
	                      &value))
		return NULL;
	glutTimerFunc(millis,
	              glutTimerFuncCallback,
	              value);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutMenuStateFunc(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutMenuStateFunc(glutMenuStateFuncCallback);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutSpecialFunc(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutSpecialFunc(glutSpecialFuncCallback);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutSpaceballMotionFunc(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutSpaceballMotionFunc(glutSpaceballMotionFuncCallback);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutSpaceballRotateFunc(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutSpaceballRotateFunc(glutSpaceballRotateFuncCallback);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutSpaceballButtonFunc(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutSpaceballButtonFunc(glutSpaceballButtonFuncCallback);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutButtonBoxFunc(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutButtonBoxFunc(glutButtonBoxFuncCallback);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutDialsFunc(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutDialsFunc(glutDialsFuncCallback);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutTabletMotionFunc(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutTabletMotionFunc(glutTabletMotionFuncCallback);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutTabletButtonFunc(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutTabletButtonFunc(glutTabletButtonFuncCallback);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutMenuStatusFunc(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutMenuStatusFunc(glutMenuStatusFuncCallback);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutOverlayDisplayFunc(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutOverlayDisplayFunc(glutOverlayDisplayFuncCallback);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutSetColor(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int x;
	float red;
	float green;
	float blue;
	if (!PyArg_ParseTuple(_args, "ifff",
	                      &x,
	                      &red,
	                      &green,
	                      &blue))
		return NULL;
	glutSetColor(x,
	             red,
	             green,
	             blue);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutGetColor(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	float _rv;
	int ndx;
	int component;
	if (!PyArg_ParseTuple(_args, "ii",
	                      &ndx,
	                      &component))
		return NULL;
	_rv = glutGetColor(ndx,
	                   component);
	_res = Py_BuildValue("f",
	                     _rv);
	return _res;
}

static PyObject *glut_glutCopyColormap(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int win;
	if (!PyArg_ParseTuple(_args, "i",
	                      &win))
		return NULL;
	glutCopyColormap(win);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutGet(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int _rv;
	long type;
	if (!PyArg_ParseTuple(_args, "l",
	                      &type))
		return NULL;
	_rv = glutGet(type);
	_res = Py_BuildValue("i",
	                     _rv);
	return _res;
}

static PyObject *glut_glutDeviceGet(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int _rv;
	long type;
	if (!PyArg_ParseTuple(_args, "l",
	                      &type))
		return NULL;
	_rv = glutDeviceGet(type);
	_res = Py_BuildValue("i",
	                     _rv);
	return _res;
}

static PyObject *glut_glutExtensionSupported(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int _rv;
	char* name;
	if (!PyArg_ParseTuple(_args, "s",
	                      &name))
		return NULL;
	_rv = glutExtensionSupported(name);
	_res = Py_BuildValue("i",
	                     _rv);
	return _res;
}

#if (GLUT_API_VERSION >= 3)
static PyObject *glut_glutGetModifiers(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int _rv;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	_rv = glutGetModifiers();
	_res = Py_BuildValue("i",
	                     _rv);
	return _res;
}

static PyObject *glut_glutLayerGet(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int _rv;
	long type;
	if (!PyArg_ParseTuple(_args, "l",
	                      &type))
		return NULL;
	_rv = glutLayerGet(type);
	_res = Py_BuildValue("i",
	                     _rv);
	return _res;
}

#endif

static PyObject *glut_glutBitmapCharacter(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	char *font_name; void *font;
	int character;
	if (!PyArg_ParseTuple(_args, "si",
	                      &font_name,
	                      &character))
		return NULL;
	font = map_lookup(glutFonts, font_name);
	glutBitmapCharacter(font,
	                    character);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutBitmapWidth(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int _rv;
	char *font_name; void *font;
	int character;
	if (!PyArg_ParseTuple(_args, "si",
	                      &font_name,
	                      &character))
		return NULL;
	font = map_lookup(glutFonts, font_name);
	_rv = glutBitmapWidth(font,
	                      character);
	_res = Py_BuildValue("i",
	                     _rv);
	return _res;
}

static PyObject *glut_glutStrokeCharacter(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	char *font_name; void *font;
	int character;
	if (!PyArg_ParseTuple(_args, "si",
	                      &font_name,
	                      &character))
		return NULL;
	font = map_lookup(glutFonts, font_name);
	glutStrokeCharacter(font,
	                    character);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutStrokeWidth(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	int _rv;
	char *font_name; void *font;
	int character;
	if (!PyArg_ParseTuple(_args, "si",
	                      &font_name,
	                      &character))
		return NULL;
	font = map_lookup(glutFonts, font_name);
	_rv = glutStrokeWidth(font,
	                      character);
	_res = Py_BuildValue("i",
	                     _rv);
	return _res;
}

static PyObject *glut_glutWireSphere(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	double radius;
	int slices;
	int stacks;
	if (!PyArg_ParseTuple(_args, "dii",
	                      &radius,
	                      &slices,
	                      &stacks))
		return NULL;
	glutWireSphere(radius,
	               slices,
	               stacks);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutSolidSphere(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	double radius;
	int slices;
	int stacks;
	if (!PyArg_ParseTuple(_args, "dii",
	                      &radius,
	                      &slices,
	                      &stacks))
		return NULL;
	glutSolidSphere(radius,
	                slices,
	                stacks);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutWireCone(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	double base;
	double height;
	int slices;
	int stacks;
	if (!PyArg_ParseTuple(_args, "ddii",
	                      &base,
	                      &height,
	                      &slices,
	                      &stacks))
		return NULL;
	glutWireCone(base,
	             height,
	             slices,
	             stacks);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutSolidCone(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	double base;
	double height;
	int slices;
	int stacks;
	if (!PyArg_ParseTuple(_args, "ddii",
	                      &base,
	                      &height,
	                      &slices,
	                      &stacks))
		return NULL;
	glutSolidCone(base,
	              height,
	              slices,
	              stacks);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutWireCube(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	double size;
	if (!PyArg_ParseTuple(_args, "d",
	                      &size))
		return NULL;
	glutWireCube(size);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutSolidCube(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	double size;
	if (!PyArg_ParseTuple(_args, "d",
	                      &size))
		return NULL;
	glutSolidCube(size);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutWireTorus(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	double innerRadius;
	double outerRadius;
	int sides;
	int rings;
	if (!PyArg_ParseTuple(_args, "ddii",
	                      &innerRadius,
	                      &outerRadius,
	                      &sides,
	                      &rings))
		return NULL;
	glutWireTorus(innerRadius,
	              outerRadius,
	              sides,
	              rings);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutSolidTorus(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	double innerRadius;
	double outerRadius;
	int sides;
	int rings;
	if (!PyArg_ParseTuple(_args, "ddii",
	                      &innerRadius,
	                      &outerRadius,
	                      &sides,
	                      &rings))
		return NULL;
	glutSolidTorus(innerRadius,
	               outerRadius,
	               sides,
	               rings);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutWireDodecahedron(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutWireDodecahedron();
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutSolidDodecahedron(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutSolidDodecahedron();
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutWireTeapot(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	double size;
	if (!PyArg_ParseTuple(_args, "d",
	                      &size))
		return NULL;
	glutWireTeapot(size);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutSolidTeapot(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	double size;
	if (!PyArg_ParseTuple(_args, "d",
	                      &size))
		return NULL;
	glutSolidTeapot(size);
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutWireOctahedron(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutWireOctahedron();
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutSolidOctahedron(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutSolidOctahedron();
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutWireTetrahedron(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutWireTetrahedron();
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutSolidTetrahedron(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutSolidTetrahedron();
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutWireIcosahedron(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutWireIcosahedron();
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

static PyObject *glut_glutSolidIcosahedron(_self, _args)
	PyObject *_self;
	PyObject *_args;
{
	PyObject *_res = NULL;
	if (!PyArg_ParseTuple(_args, ""))
		return NULL;
	glutSolidIcosahedron();
	Py_INCREF(Py_None);
	_res = Py_None;
	return _res;
}

#ifdef SGISTEREO

#include <X11/Xatom.h> 
#include <X11/extensions/SGIStereo.h>

static PyObject *stereo_Error;

/* Standard screen dimensions */
#define XMAXSCREEN      1280
#define YMAXSCREEN      1024

#define YSTEREO         491             /* Subfield height in pixels */
#define YOFFSET_LEFT    532             /* YSTEREO + YBLANK */

static char stereo_start__doc__[] ="";
static PyObject *
stereo_start(PyObject *self, PyObject *args)
{
  int event, error;

  if (!PyArg_ParseTuple(args, ""))
    return NULL;
  if (!XSGIStereoQueryExtension(__glutDisplay, &event, &error)) {
    fprintf(stderr, "Stereo not supported on this display!\n");
    exit(0);
  }
  if (XSGIQueryStereoMode(__glutDisplay, __glutCurrentWindow->win) < 0) {
    fprintf(stderr, "Stereo not supported on this window!\n");
    exit(0);
  }
  if (system("/usr/gfx/setmon -n STR_BOT") != 0) { 
    fprintf(stderr, "setmon attempt failed!\n");
    system("/usr/gfx/setmon -n 72hz");
    exit(0);
  }
  Py_INCREF(Py_None);
  return Py_None;
}

static char stereo_stop__doc__[] ="";

static PyObject *
stereo_stop(PyObject *self, PyObject *args)
{
  
  if (!PyArg_ParseTuple(args, ""))
    return NULL;
  system("/usr/gfx/setmon -n 72hz");

  Py_INCREF(Py_None);
  return Py_None;
}

static char stereo_left__doc__[] ="";
static PyObject *
stereo_left(PyObject *self, PyObject *args)
{
  if (!PyArg_ParseTuple(args, ""))
    return NULL;
  XSGISetStereoBuffer(__glutDisplay, __glutCurrentWindow->win, STEREO_BUFFER_LEFT);
  glViewport(0, 0, XMAXSCREEN, YSTEREO);

  XSync(__glutDisplay, False);  
  
  Py_INCREF(Py_None);
  return Py_None;
}

static char stereo_right__doc__[] ="";
static PyObject *
stereo_right(PyObject *self, PyObject *args)
{
  if (!PyArg_ParseTuple(args, ""))
    return NULL;

  XSGISetStereoBuffer(__glutDisplay, __glutCurrentWindow->win, STEREO_BUFFER_RIGHT);
  glViewport(0, 0, XMAXSCREEN, YSTEREO);

  XSync(__glutDisplay, False); 

  Py_INCREF(Py_None);
  return Py_None;
}
#endif

static PyMethodDef glut_methods[] = {
	{"SetCreateMenuCallback", (PyCFunction)glut_SetglutCreateMenuCallback, 1},
	{"SetDisplayFuncCallback", (PyCFunction)glut_SetglutDisplayFuncCallback, 1},
	{"SetReshapeFuncCallback", (PyCFunction)glut_SetglutReshapeFuncCallback, 1},
	{"SetKeyboardFuncCallback", (PyCFunction)glut_SetglutKeyboardFuncCallback, 1},
	{"SetMouseFuncCallback", (PyCFunction)glut_SetglutMouseFuncCallback, 1},
	{"SetMotionFuncCallback", (PyCFunction)glut_SetglutMotionFuncCallback, 1},
	{"SetPassiveMotionFuncCallback", (PyCFunction)glut_SetglutPassiveMotionFuncCallback, 1},
	{"SetEntryFuncCallback", (PyCFunction)glut_SetglutEntryFuncCallback, 1},
	{"SetVisibilityFuncCallback", (PyCFunction)glut_SetglutVisibilityFuncCallback, 1},
	{"SetIdleFuncCallback", (PyCFunction)glut_SetglutIdleFuncCallback, 1},
	{"SetTimerFuncCallback", (PyCFunction)glut_SetglutTimerFuncCallback, 1},
	{"SetMenuStateFuncCallback", (PyCFunction)glut_SetglutMenuStateFuncCallback, 1},
	{"SetSpecialFuncCallback", (PyCFunction)glut_SetglutSpecialFuncCallback, 1},
	{"SetSpaceballMotionFuncCallback", (PyCFunction)glut_SetglutSpaceballMotionFuncCallback, 1},
	{"SetSpaceballRotateFuncCallback", (PyCFunction)glut_SetglutSpaceballRotateFuncCallback, 1},
	{"SetSpaceballButtonFuncCallback", (PyCFunction)glut_SetglutSpaceballButtonFuncCallback, 1},
	{"SetButtonBoxFuncCallback", (PyCFunction)glut_SetglutButtonBoxFuncCallback, 1},
	{"SetDialsFuncCallback", (PyCFunction)glut_SetglutDialsFuncCallback, 1},
	{"SetTabletMotionFuncCallback", (PyCFunction)glut_SetglutTabletMotionFuncCallback, 1},
	{"SetTabletButtonFuncCallback", (PyCFunction)glut_SetglutTabletButtonFuncCallback, 1},
	{"SetMenuStatusFuncCallback", (PyCFunction)glut_SetglutMenuStatusFuncCallback, 1},
	{"SetOverlayDisplayFuncCallback", (PyCFunction)glut_SetglutOverlayDisplayFuncCallback, 1},
	{"Init", (PyCFunction)glut_glutInit, 1,
	 "(char* argv) -> (int argcp)"},
	{"InitDisplayMode", (PyCFunction)glut_glutInitDisplayMode, 1,
	 "(int mode) -> None"},
	{"InitWindowPosition", (PyCFunction)glut_glutInitWindowPosition, 1,
	 "(int x, int y) -> None"},
	{"InitWindowSize", (PyCFunction)glut_glutInitWindowSize, 1,
	 "(int width, int height) -> None"},
	{"MainLoop", (PyCFunction)glut_glutMainLoop, 1,
	 "() -> None"},
	{"CreateWindow", (PyCFunction)glut_glutCreateWindow, 1,
	 "(char* title) -> (int _rv)"},
	{"CreateSubWindow", (PyCFunction)glut_glutCreateSubWindow, 1,
	 "(int win, int x, int y, int width, int height) -> (int _rv)"},
	{"DestroyWindow", (PyCFunction)glut_glutDestroyWindow, 1,
	 "(int win) -> None"},
	{"PostRedisplay", (PyCFunction)glut_glutPostRedisplay, 1,
	 "() -> None"},
	{"SwapBuffers", (PyCFunction)glut_glutSwapBuffers, 1,
	 "() -> None"},
	{"GetWindow", (PyCFunction)glut_glutGetWindow, 1,
	 "() -> (int _rv)"},
	{"SetWindow", (PyCFunction)glut_glutSetWindow, 1,
	 "(int win) -> None"},
	{"SetWindowTitle", (PyCFunction)glut_glutSetWindowTitle, 1,
	 "(char* title) -> None"},
	{"SetIconTitle", (PyCFunction)glut_glutSetIconTitle, 1,
	 "(char* title) -> None"},
	{"PositionWindow", (PyCFunction)glut_glutPositionWindow, 1,
	 "(int x, int y) -> None"},
	{"ReshapeWindow", (PyCFunction)glut_glutReshapeWindow, 1,
	 "(int width, int height) -> None"},
	{"PopWindow", (PyCFunction)glut_glutPopWindow, 1,
	 "() -> None"},
	{"PushWindow", (PyCFunction)glut_glutPushWindow, 1,
	 "() -> None"},
	{"IconifyWindow", (PyCFunction)glut_glutIconifyWindow, 1,
	 "() -> None"},
	{"ShowWindow", (PyCFunction)glut_glutShowWindow, 1,
	 "() -> None"},
	{"HideWindow", (PyCFunction)glut_glutHideWindow, 1,
	 "() -> None"},
	{"FullScreen", (PyCFunction)glut_glutFullScreen, 1,
	 "() -> None"},
	{"SetCursor", (PyCFunction)glut_glutSetCursor, 1,
	 "(int cursor) -> None"},
	{"EstablishOverlay", (PyCFunction)glut_glutEstablishOverlay, 1,
	 "() -> None"},
	{"RemoveOverlay", (PyCFunction)glut_glutRemoveOverlay, 1,
	 "() -> None"},
	{"UseLayer", (PyCFunction)glut_glutUseLayer, 1,
	 "(long layer) -> None"},
	{"PostOverlayRedisplay", (PyCFunction)glut_glutPostOverlayRedisplay, 1,
	 "() -> None"},
	{"ShowOverlay", (PyCFunction)glut_glutShowOverlay, 1,
	 "() -> None"},
	{"HideOverlay", (PyCFunction)glut_glutHideOverlay, 1,
	 "() -> None"},
	{"CreateMenu", (PyCFunction)glut_glutCreateMenu, 1,
	 "(staticGlobal glutCreateMenuCallback) -> (int _rv)"},
	{"DestroyMenu", (PyCFunction)glut_glutDestroyMenu, 1,
	 "(int menu) -> None"},
	{"GetMenu", (PyCFunction)glut_glutGetMenu, 1,
	 "() -> (int _rv)"},
	{"SetMenu", (PyCFunction)glut_glutSetMenu, 1,
	 "(int menu) -> None"},
	{"AddMenuEntry", (PyCFunction)glut_glutAddMenuEntry, 1,
	 "(char* label, int value) -> None"},
	{"AddSubMenu", (PyCFunction)glut_glutAddSubMenu, 1,
	 "(char* label, int submenu) -> None"},
	{"ChangeToMenuEntry", (PyCFunction)glut_glutChangeToMenuEntry, 1,
	 "(int item, char* label, int value) -> None"},
	{"ChangeToSubMenu", (PyCFunction)glut_glutChangeToSubMenu, 1,
	 "(int item, char* label, int submenu) -> None"},
	{"RemoveMenuItem", (PyCFunction)glut_glutRemoveMenuItem, 1,
	 "(int item) -> None"},
	{"AttachMenu", (PyCFunction)glut_glutAttachMenu, 1,
	 "(int button) -> None"},
	{"DetachMenu", (PyCFunction)glut_glutDetachMenu, 1,
	 "(int button) -> None"},
	{"DisplayFunc", (PyCFunction)glut_glutDisplayFunc, 1,
	 "(staticGlobal glutDisplayFuncCallback) -> None"},
	{"ReshapeFunc", (PyCFunction)glut_glutReshapeFunc, 1,
	 "(staticGlobal glutReshapeFuncCallback) -> None"},
	{"KeyboardFunc", (PyCFunction)glut_glutKeyboardFunc, 1,
	 "(staticGlobal glutKeyboardFuncCallback) -> None"},
	{"MouseFunc", (PyCFunction)glut_glutMouseFunc, 1,
	 "(staticGlobal glutMouseFuncCallback) -> None"},
	{"MotionFunc", (PyCFunction)glut_glutMotionFunc, 1,
	 "(staticGlobal glutMotionFuncCallback) -> None"},
	{"PassiveMotionFunc", (PyCFunction)glut_glutPassiveMotionFunc, 1,
	 "(staticGlobal glutPassiveMotionFuncCallback) -> None"},
	{"EntryFunc", (PyCFunction)glut_glutEntryFunc, 1,
	 "(staticGlobal glutEntryFuncCallback) -> None"},
	{"VisibilityFunc", (PyCFunction)glut_glutVisibilityFunc, 1,
	 "(staticGlobal glutVisibilityFuncCallback) -> None"},
	{"IdleFunc", (PyCFunction)glut_glutIdleFunc, 1,
	 "(staticGlobal glutIdleFuncCallback) -> None"},
	{"TimerFunc", (PyCFunction)glut_glutTimerFunc, 1,
	 "(int millis, staticGlobal glutTimerFuncCallback, int value) -> None"},
	{"MenuStateFunc", (PyCFunction)glut_glutMenuStateFunc, 1,
	 "(staticGlobal glutMenuStateFuncCallback) -> None"},
	{"SpecialFunc", (PyCFunction)glut_glutSpecialFunc, 1,
	 "(staticGlobal glutSpecialFuncCallback) -> None"},
	{"SpaceballMotionFunc", (PyCFunction)glut_glutSpaceballMotionFunc, 1,
	 "(staticGlobal glutSpaceballMotionFuncCallback) -> None"},
	{"SpaceballRotateFunc", (PyCFunction)glut_glutSpaceballRotateFunc, 1,
	 "(staticGlobal glutSpaceballRotateFuncCallback) -> None"},
	{"SpaceballButtonFunc", (PyCFunction)glut_glutSpaceballButtonFunc, 1,
	 "(staticGlobal glutSpaceballButtonFuncCallback) -> None"},
	{"ButtonBoxFunc", (PyCFunction)glut_glutButtonBoxFunc, 1,
	 "(staticGlobal glutButtonBoxFuncCallback) -> None"},
	{"DialsFunc", (PyCFunction)glut_glutDialsFunc, 1,
	 "(staticGlobal glutDialsFuncCallback) -> None"},
	{"TabletMotionFunc", (PyCFunction)glut_glutTabletMotionFunc, 1,
	 "(staticGlobal glutTabletMotionFuncCallback) -> None"},
	{"TabletButtonFunc", (PyCFunction)glut_glutTabletButtonFunc, 1,
	 "(staticGlobal glutTabletButtonFuncCallback) -> None"},
	{"MenuStatusFunc", (PyCFunction)glut_glutMenuStatusFunc, 1,
	 "(staticGlobal glutMenuStatusFuncCallback) -> None"},
	{"OverlayDisplayFunc", (PyCFunction)glut_glutOverlayDisplayFunc, 1,
	 "(staticGlobal glutOverlayDisplayFuncCallback) -> None"},
	{"SetColor", (PyCFunction)glut_glutSetColor, 1,
	 "(int x, float red, float green, float blue) -> None"},
	{"GetColor", (PyCFunction)glut_glutGetColor, 1,
	 "(int ndx, int component) -> (float _rv)"},
	{"CopyColormap", (PyCFunction)glut_glutCopyColormap, 1,
	 "(int win) -> None"},
	{"Get", (PyCFunction)glut_glutGet, 1,
	 "(long type) -> (int _rv)"},
	{"DeviceGet", (PyCFunction)glut_glutDeviceGet, 1,
	 "(long type) -> (int _rv)"},
	{"ExtensionSupported", (PyCFunction)glut_glutExtensionSupported, 1,
	 "(char* name) -> (int _rv)"},
#if (GLUT_API_VERSION >= 3)
	{"GetModifiers", (PyCFunction)glut_glutGetModifiers, 1,
	 "() -> (int _rv)"},
	{"LayerGet", (PyCFunction)glut_glutLayerGet, 1,
	 "(long type) -> (int _rv)"},
#endif
	{"BitmapCharacter", (PyCFunction)glut_glutBitmapCharacter, 1,
	 "(stringMap font, int character) -> None"},
	{"BitmapWidth", (PyCFunction)glut_glutBitmapWidth, 1,
	 "(stringMap font, int character) -> (int _rv)"},
	{"StrokeCharacter", (PyCFunction)glut_glutStrokeCharacter, 1,
	 "(stringMap font, int character) -> None"},
	{"StrokeWidth", (PyCFunction)glut_glutStrokeWidth, 1,
	 "(stringMap font, int character) -> (int _rv)"},
	{"WireSphere", (PyCFunction)glut_glutWireSphere, 1,
	 "(double radius, int slices, int stacks) -> None"},
	{"SolidSphere", (PyCFunction)glut_glutSolidSphere, 1,
	 "(double radius, int slices, int stacks) -> None"},
	{"WireCone", (PyCFunction)glut_glutWireCone, 1,
	 "(double base, double height, int slices, int stacks) -> None"},
	{"SolidCone", (PyCFunction)glut_glutSolidCone, 1,
	 "(double base, double height, int slices, int stacks) -> None"},
	{"WireCube", (PyCFunction)glut_glutWireCube, 1,
	 "(double size) -> None"},
	{"SolidCube", (PyCFunction)glut_glutSolidCube, 1,
	 "(double size) -> None"},
	{"WireTorus", (PyCFunction)glut_glutWireTorus, 1,
	 "(double innerRadius, double outerRadius, int sides, int rings) -> None"},
	{"SolidTorus", (PyCFunction)glut_glutSolidTorus, 1,
	 "(double innerRadius, double outerRadius, int sides, int rings) -> None"},
	{"WireDodecahedron", (PyCFunction)glut_glutWireDodecahedron, 1,
	 "() -> None"},
	{"SolidDodecahedron", (PyCFunction)glut_glutSolidDodecahedron, 1,
	 "() -> None"},
	{"WireTeapot", (PyCFunction)glut_glutWireTeapot, 1,
	 "(double size) -> None"},
	{"SolidTeapot", (PyCFunction)glut_glutSolidTeapot, 1,
	 "(double size) -> None"},
	{"WireOctahedron", (PyCFunction)glut_glutWireOctahedron, 1,
	 "() -> None"},
	{"SolidOctahedron", (PyCFunction)glut_glutSolidOctahedron, 1,
	 "() -> None"},
	{"WireTetrahedron", (PyCFunction)glut_glutWireTetrahedron, 1,
	 "() -> None"},
	{"SolidTetrahedron", (PyCFunction)glut_glutSolidTetrahedron, 1,
	 "() -> None"},
	{"WireIcosahedron", (PyCFunction)glut_glutWireIcosahedron, 1,
	 "() -> None"},
	{"SolidIcosahedron", (PyCFunction)glut_glutSolidIcosahedron, 1,
	 "() -> None"},
#ifdef SGISTEREO
	{"start_stereo",	stereo_start,	1,	stereo_start__doc__},
	{"stop_stereo",	stereo_stop,	1,	stereo_stop__doc__},
	{"left",	stereo_left,	1,	stereo_left__doc__},
	{"right",	stereo_right,	1,	stereo_right__doc__},
#endif
	{NULL, NULL, 0}
};

void initglut()
{
	PyObject *m;
	PyObject *d;

	m = Py_InitModule("glut", glut_methods);
	d = PyModule_GetDict(m);
	glut_Error = PyString_FromString("glut.Error");
	if (glut_Error == NULL ||
	    PyDict_SetItemString(d, "Error", glut_Error) != 0)
		Py_FatalError("can't initialize glut.Error");
}

