#!/usr/local/bin/python

from Opengl import *
from Numeric import *

n, dt = 2000, 0.01
x, y, z = 0.01, 0.01, 0.01
frac = -1.0 * (8.0/3.0)
a = array((n,3), 'd')

def lorentz(o, x, y, z, n=2000, dt=0.01):
  """Generate Lorentz attractor.  Put graphic in a graphical object"""

  o.grob = gl.GenLists(10);
  gl.NewList(o.grob, GL_COMPILE);
  gl.Disable(GL_LIGHTING)
  gl.Begin(GL_LINE_STRIP)

  gl.Vertex3f(x, y, z)
  frac = -1.0 * (8.0/3.0)
  for i in range(0, n):
    xp = x + (-10.0 * x * dt + 10.0 * y * dt)
    yp = y + ( 28.0 * x * dt - y * dt - x * dt * z *dt)
    zp = z + ( frac * z * dt + x * dt * y * dt)
    x=xp
    y=yp
    z=zp
    gl.Color3f(x, y, z)
    gl.Vertex3f(x, y, z)
  gl.End()
 
  gl.Enable(GL_LIGHTING)
  gl.EndList()

def redraw(o):
  """The main scene redraw function."""

  # Clear the background and depth buffer.
  gl.ClearColor(1., 0., 1., 0.)
  gl.Clear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
  gl.Color3f(1., 1., 1.)
  gl.CallList(o.grob)

#
# Demo starts here really.

import Tkinter, sys

# Create the opengl widget here.

o = Opengl(None, width = 200, height = 200, double = 1)

# Register the redraw procedure for the widget.

o.redraw = redraw

o.pack(side = 'top', expand = 1, fill = 'both')
o.set_centerpoint(0., 0., 2000.)
o.set_eyepoint(13000.)

o.far = 15000.

lorentz(o, 0.01, 0.01, 0.01)

# Enter the tk mainloop.

Tkinter.mainloop()
