#! /usr/local/bin/python

from Opengl import *

def init():
  gl.Material(GL_FRONT, GL_AMBIENT, [0.2, 0.2, 0.2, 1.0])
  gl.Material(GL_FRONT, GL_DIFFUSE, [0.8, 0.8, 0.8, 1.0])
  gl.Material(GL_FRONT, GL_SPECULAR, [1.0, 0.0, 1.0, 1.0])
  gl.Material(GL_FRONT, GL_SHININESS, 50.0)
  gl.Light(GL_LIGHT0, GL_AMBIENT, [0.0, 1.0, 0.0, 1.0])
  gl.Light(GL_LIGHT0, GL_DIFFUSE, [1.0, 1.0, 1.0, 1.0])
  gl.Light(GL_LIGHT0, GL_SPECULAR, [1.0, 1.0, 1.0, 1.0])
  gl.Light(GL_LIGHT0, GL_POSITION, [1.0, 1.0, 1.0, 0.0]);   
  gl.LightModel(GL_LIGHT_MODEL_AMBIENT, [0.2, 0.2, 0.2, 1.0])
  gl.Enable(GL_LIGHTING)
  gl.Enable(GL_LIGHT0)
  gl.DepthFunc(GL_LESS)
  gl.Enable(GL_DEPTH_TEST)


def redraw(o):
  gl.Clear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
  gl.PushMatrix()
  gl.Translate(0, -1, 0)
  gl.Rotate(250, 1, 0, 0)
  gl.SolidCone(1, 2, 50, 10)
  gl.PopMatrix()

def main():
  o = Opengl(width = 200, height = 200, double = 1)
  o.redraw = redraw
  o.autospin_allowed = 1
  o.pack(side = TOP, expand = YES, fill = BOTH)
  init()
  o.mainloop()

main()
