#! /usr/local/bin/python

from Opengl import *
import sys

def redraw(o):
  gl.ClearColor(1, 0, 1, 0)
  gl.Clear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
  gl.Color3f(0, 1, 0)
  #draw checkerboard
  N = 4
  gl.Disable(GL_LIGHTING)
  for x in range(-N, N):
    for y in range(-N, N):
      if (x + y) % 2 == 0:
	gl.Color3f(1, 1, 1)
      else:
	gl.Color3f(0, 0, 0)	
      gl.Rectf(x, y, x + 1, y + 1)
  gl.Enable(GL_LIGHTING)

  gl.PushMatrix()
  gl.Translatef(0., 0., 1.)
  gl.SolidSphere(1.0)
  gl.PopMatrix()

def main():
  f = Frame()
  f.pack(side = 'top')
  o = Opengl(width = 200, height = 200, double = 1)
  o.redraw = redraw
  quit = Button(f, text = 'Quit', command = sys.exit)
  quit.pack(side = 'top', side = 'left')
  help = Button(f, text = 'Help', command = o.help)
  help.pack(side = 'top', side = 'left')
  reset = Button(f, text = 'Reset', command = o.reset)
  reset.pack(side = 'top', side = 'left')
  o.pack(side = 'top', expand = 1, fill = 'both')
  o.set_eyepoint(20.)
  o.mainloop()

main()
