#
# threaddialog.py
#
# Copyright 1995 - Koert Zeilstra
#
# No warranty - use at your own risk
#

import tempfile
import os
import uu
import string
import Tkinter

import mimeview

import setup
import groupstat
import articledlg
import searchart
import postdlg
import emaildlg

#
# ThreadsDialog
#
#
class ThreadsDialog(Tkinter.Toplevel):
  def __init__ (self, parent, app_config, news_fetcher, group_stat,
		config=None):
    Tkinter.Toplevel.__init__ (self, parent)
    self.window_title = ""
    self.ok_command = None
    self.close_command = None
    self.app_config = app_config
    self.news_fetcher = news_fetcher
    self.group_stat = group_stat
    self.current_group = None
    self.current_article = None
    self.article_dialog = None
    self.post_dialog = None
    self.email_dialog = None
    self.search_dialog = None
    self.selected_items = []
    self.art_selection = Tkinter.StringVar()
    self.art_selection.set("New")
    self.list_all = 0
    self.last_number = 0
    self.colors = {"read": "yellow", "normal": "black",
		"select": "blue"}
    self.subject_font = "-*-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-*"
    self.author_font = "-*-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*"
    self.line_height = 12
    self.x_indent = 15
    self.x_margin = 30
    self.y_margin = 5
    self.article_number = {}

    view = Tkinter.Frame(self)
    self.canvas = Tkinter.Canvas(view, {"width": "20c",
		"height": "10c",
		"scrollregion": "0 0 600 800",
		"relief": "sunken", "borderwidth": 2})
    xscroll = Tkinter.Scrollbar(view, {"orient": "horizontal",
		"command": self.canvas.xview})
    yscroll = Tkinter.Scrollbar(view, {"orient": "vertical",
		"command": self.canvas.yview})
    self.canvas["xscrollcommand"] = xscroll.set
    self.canvas["yscrollcommand"] = yscroll.set
    xscroll.pack({"side": "bottom", "fill": "x"})
    yscroll.pack({"side": "right", "fill": "y"})
    self.canvas.pack({"fill": "both", "expand": 1})
    view.pack({"fill": "both", "expand": 1})

    self.canvas.bind("<Any-ButtonPress-1>", self.highlightItem)
    self.canvas.bind("<Shift-ButtonPress-1>",
		self.highlightItemExtend)
    self.canvas.bind("<Any-Double-ButtonPress-1>",
		self.doubleClickItem)
    self.canvas.bind("<2>", self.canvasScan)
    self.canvas.bind("<B2-Motion>", self.canvasDragto)

    self.info_entry = Tkinter.Entry(self, {"width": 40})
    self.info_entry.pack({"side": "top", "fill": "x"})

    buttons1 = Tkinter.Frame(self)
    self.read_button = Tkinter.Button(buttons1, {"text": "Read..",
	"width": 9, "command": self.read})
    self.uudecode_button = Tkinter.Button(buttons1,
	{"text": "Uudecode", "width": 9, "command": self.uudecode})
    self.post_button = Tkinter.Button(buttons1, {"text": "Post..",
	"width": 9, "command": self.post})
    self.read_button.pack({"side": "left", "padx": 3, "pady": 2})
    self.uudecode_button.pack({"side": "left", "padx": 3, "pady": 2})
    self.post_button.pack({"side": "right", "padx": 3, "pady": 2})
    buttons1.pack({"side": "top", "fill": "x", "pady": 1})

    buttons2 = Tkinter.Frame(self)
    #self.select_menu = Tkinter.OptionMenu(buttons2,
	#	self.art_selection, "New", "All")
    #self.select_menu.pack({"side": "left", "pady": 2})
    self.select_new = Tkinter.Radiobutton(buttons2, {"text": "New",
		"variable": self.art_selection, "value": "New",
		"command": self.changeListSelection})
    self.select_new.pack({"side": "left", "pady": 2})
    self.select_all = Tkinter.Radiobutton(buttons2, {"text": "All",
		"variable": self.art_selection, "value": "All",
		"command": self.changeListSelection})
    self.select_all.pack({"side": "left", "pady": 2})
    self.select_label = Tkinter.Label(buttons2, {"text": "Articles"})
    self.select_label.pack({"side": "left", "pady": 2})
    self.search_button = Tkinter.Button(buttons2, {"text": "Search..",
		"width": 10, "command": self.search})
    self.search_button.pack({"side": "left", "pady": 2})
    self.markall_button = Tkinter.Button(buttons2,
		{"text": "Mark All Read",
		"width": 10, "command": self.markAll})
    self.close_button = Tkinter.Button(buttons2, {"text": "Close",
		"width": 10, "command": self.close})
    self.close_button.pack ({"side": "right", "padx": 3, "pady": 2})
    self.markall_button.pack ({"side": "right", "padx": 3, "pady": 2})
    buttons2.pack ({"side": "top", "fill": "x", "pady": 1})

    self.article_status = groupstat.ArticleList()
    #self.art_selection.trace("w", (self.changeListSelection))

    self.protocol("WM_DELETE_WINDOW", self.close)

  def canvasScan (self, event):
    self.canvas.scan_mark(event.x, event.y)

  def canvasDragto (self, event):
    self.canvas.scan_dragto(event.x, event.y)

  def read(self):
    if self.current_article != None:
      if self.article_dialog == None:
        self.article_dialog = mimeview.MimeViewer(self)
        #self.article_dialog = articledlg.ArticleDialog(self, self,
	#	self.app_config, self.news_fetcher)
        self.article_dialog.title("Article")
        self.article_dialog.followupCommand(self.followup)
        self.article_dialog.emailCommand(self.email)
        self.article_dialog.closeCommand(self.article_dialog.withdraw)
      else:
        self.article_dialog.deiconify()
      self.showInfo("loading article %d..." % self.current_article)
      if 0:
        self.article_dialog.showArticle(self.current_group,
		self.current_article)
      else:
        tmp_file = tempfile.mktemp()
        article = self.news_fetcher.saveArticle(self.current_article,
		tmp_file)
        file = open(tmp_file, "r")
        self.article_dialog.showMessage(self.current_group,
			self.current_article, file)
        file.close()
        os.unlink(tmp_file)
      self.showInfo("")
      self.article_status.setRead(self.current_article)

  def uudecode (self):
    if len(self.selected_items) == 0:
      self.showInfo("saving %d..." % self.current_article)
      article = self.news_fetcher.getArticle(self.current_article,
		"body")
      tmp_file = tempfile.mktemp()
      fp = open(tmp_file, "w")
      fp.write(article)
      fp.close()
      self.showInfo("uudecoding...")
      os.system("uudecode %s" % tmp_file)
      os.unlink(tmp_file)
      self.showInfo("")
      self.article_status.setRead(self.current_article)
    else:
      tmp_file = tempfile.mktemp()
      fp = open(tmp_file, "w")
      for number in self.selected_items:
        self.showInfo("saving %d" % number)
        article = self.news_fetcher.getArticle(number, "body")
        fp.write(article)
        fp.write("\n")
        self.article_status.setRead(number)
      fp.close()
      self.showInfo("uudecoding...")
      uu.decode(tmp_file)
      #os.system("uudecode %s" % tmp_file)
      os.system("rm %s" % tmp_file)
      os.showInfo("")

  def followup (self, subject, references, group, article_number):
    if self.post_dialog == None:
      self.post_dialog = postdlg.PostDialog(self,
		self.app_config, self.news_fetcher)
      self.post_dialog.title("Post Article")
      self.post_dialog.closeCommand(self.post_dialog.withdraw)
    else:
      self.post_dialog.deiconify()
    self.post_dialog.setGroupAndClear(group)
    self.post_dialog.setFollowup(subject, references, article_number)

  def email (self, address, subject, group, article_number):
    if self.email_dialog == None:
      self.email_dialog = emaildlg.EmailDialog(self, self.app_config)
      self.email_dialog.title("Email Reply")
      self.email_dialog.closeCommand(self.email_dialog.withdraw)
    else:
      self.email_dialog.deiconify()
    self.email_dialog.setAddressSubject(address, subject)

  def post (self):
    if self.post_dialog == None:
      self.post_dialog = postdlg.PostDialog(self,
		self.app_config, self.news_fetcher)
      self.post_dialog.title("Post Article")
      self.post_dialog.closeCommand(self.post_dialog.withdraw)
    else:
      self.post_dialog.deiconify()
    self.post_dialog.setGroupAndClear(self.current_group)

  def changeListSelection (self):
    if self.art_selection.get() == "New":
      self.list_all = 0
    else:
      self.list_all = 1
    self.showGroupArticles(self.current_group)

  def search (self):
    if self.search_dialog == None:
      self.search_dialog = searchart.SearchDialog(self)
      self.search_dialog.title("Search")
      self.search_dialog.searchCommand(self.doSearch)
      self.search_dialog.selectCommand(self.showArticle)
      self.search_dialog.closeCommand(self.search_dialog.withdraw)
    else:
      self.search_dialog.deiconify()

  def markAll (self):
    self.article_status.setReadAll(self.last_number)
    self.canvas.itemconfig("all", {"fill": self.colors["read"]})

  def closeCommand (self, command):
    self.close_command = command

  def title (self, new_title):
    Tkinter.Toplevel.title(self, new_title)
    self.window_title = new_title

  def close (self):
    self.saveArticleStatus()
    if self.article_dialog != None:
      self.article_dialog.close()
    if self.post_dialog != None:
      self.post_dialog.close()
    if self.email_dialog != None:
      self.email_dialog.close()
    if self.search_dialog != None:
      self.search_dialog.close()
    if self.close_command != None:
      self.close_command()

  def doSearch (self, field, search_string):
    numbers = self.art_subject.keys()
    result = []
    if field == "subject":
      for number in numbers:
        subject = self.art_subject[number]
        if string.find(self.art_subject[number], search_string) != -1:
          result.append((self.art_from[number],
		self.art_subject[number], number))
    elif field == "author":
      for number in numbers:
        if string.find(self.art_from[number], search_string) != -1:
          result.append((self.art_from[number],
		self.art_subject[number], number))
    return result

  def saveArticleStatus (self):
    self.group_stat.updateGroupReadArticles(self.current_group,
		self.article_status.getArticleList())

  def showInfo (self, message):
    self.info_entry.delete(0, "end")
    self.info_entry.insert(0, message)
    self.update_idletasks()

  def clickArticle (self, row):
    self.current_article = self.article_numbers[row]

  def doubleClickArticle (self, row):
    self.current_article = self.article_numbers[row]

  def showGroupArticles (self, group_name):
    #blt_busy hold $this
    Tkinter.Toplevel.title(self, "%s - %s" % (self.window_title, group_name))
    self.canvas.delete("all")
    self.article_status.setArticleList(self.group_stat.getGroupReadArticles(group_name))
    self.current_group = group_name
    self.current_item = None
    self.current_article = None
    self.art_subject = {}
    self.art_from = {}
    self.art_idnumber = {}
    self.art_numberid = {}
    self.art_children = {}
    self.art_has_parent = {}
    self.news_fetcher.changeGroup(self.current_group)
    status, n, first_number, last_number = self.news_fetcher.groupStatus()
    lowest = self.article_status.getLowestNumber()
    if self.list_all or lowest < first_number:
      self.article_status.setLowestNumber(first_number)
      lowest = first_number
    self.last_number = last_number
    self.showInfo("Getting subjects")
    self.news_fetcher.getXhdr(lowest, last_number, "Subject",
		self.setSubject)
    self.showInfo("Getting authors")
    self.news_fetcher.getXhdr(lowest, last_number, "From",
		self.setFrom)
    self.showInfo("Getting message ids")
    self.news_fetcher.getXhdr(lowest, last_number, "Message-ID",
		self.setMessageId)
    self.showInfo("Getting references")
    self._references = {}
    self.news_fetcher.getXhdr(lowest, last_number, "References",
		self.setReference)

    x = self.x_margin
    y = self.line_height
      
    no_of_articles = len(self.art_subject)
    self.showInfo("Threading %d articles" % no_of_articles)
    self.canvas_height = (no_of_articles+1) * (2*self.line_height+self.y_margin)
    self.canvas.config({"scrollregion": "0 0 600 %d" % self.canvas_height})

    ids = self.art_children.keys()
    for id in ids:
      #print "display: %s" % id
      if id == "(none)":
        for number in self.art_children[id]:
          id = self.art_numberid[number]
          y = self.displayArticle(id, x, y)
      else:
        if self.art_idnumber.has_key(id) and self.art_has_parent.has_key(self.art_idnumber[id]):
          is_child = 1
        else:
          y = self.displayArticle(id, x, y)
    self.showInfo("")
    #blt_busy release $this

  def setSubject (self, number, value):
    if self.list_all or self.article_status.isRead(number) == 0:
      self.art_subject[number] = value

  def setFrom (self, number, value):
    if self.list_all or self.article_status.isRead(number) == 0:
      self.art_from[number] = value

  def setMessageId (self, number, value):
    if self.list_all or self.article_status.isRead(number) == 0:
      id = string.strip(value)
      self.art_idnumber[id] = number
      self.art_numberid[number] = id

  def setReference (self, number, value):
    if self.list_all or self.article_status.isRead(number) == 0:
      value = string.strip(value)
      if value == "":
        reference = "(none)"
      else:
        reference = string.split(value)[-1]
      if self.art_children.has_key(reference):
        self.art_children[reference].append(number)
        self.art_has_parent[number] = 1
      else:
        self.art_children[reference] = [number]
        self.art_has_parent[number] = 1

  def displayArticle (self, id, x, y):
    if self.art_idnumber.has_key(id):
      number = self.art_idnumber[id]
      subject = self.art_subject[number]
      author = self.art_from[number]
      self.canvas.create_text(x, y, {"text": self.art_subject[number],
		"anchor": "nw", "font": self.subject_font,
		"tags": "art-%d subj-%d" % (number, number)})
      y = y + self.line_height
      self.canvas.create_text(x+self.x_margin, y, {"text":
		self.art_from[number], "anchor": "nw",
		"font": self.author_font,
		"fill": self.colors["normal"],
		"tags": "art-%d auth-%d" % (number, number),
		"fill": self.colors["normal"]})
      y = y + self.line_height + self.y_margin
      py = y - self.line_height - self.y_margin
    else:
      py = y

    if self.art_children.has_key(id):
      for number in self.art_children[id]:
        px = x - self.x_indent/3
        self.canvas.create_line(px, py, px, y+self.line_height,
		x+self.x_indent, y+self.line_height,
		{"tags": "art-%d" % number,
			"fill": self.colors["normal"]})
        id = self.art_numberid[number]
        y = self.displayArticle(id, x+self.x_indent, y)

    return y

  def getArticleBody (self, number):
    return self.news_fetcher.getArticle(number, "body")

  def getArticle (self, number, part):
    return self.news_fetcher.getArticle(number, part)

  def showArticle (self, number):
    item = self.canvas.find("withtag", "subj-%d" % number)
    coords = string.split(self.canvas.coords(item))
    x = string.atof(coords[0])
    y = string.atof(coords[1])
    self.canvas.yview("moveto", float(y) / self.canvas_height)

  def highlightItem (self, event):
    x = event.x
    y = event.y
    self.unhighlightItem()
    tags = self.current_item = self.canvas.gettags("current")
    if len(tags) > 0:
      self.current_item = tags[0]
      self.current_article = string.atoi(string.split(self.current_item, "-")[1])
      number = self.current_article
      self.canvas.itemconfig("art-%d" % number,
		{"fill": self.colors["select"]})
      self.canvas.itemconfig("subj-%d" % number,
		{"fill": self.colors["select"]})
      self.canvas.itemconfig("auth-%d" % number,
		{"fill": self.colors["select"]})

  def doubleClickItem (self, event):
    self.read()

  def highlightItemExtend (self, event):
    x = event.x
    y = event.y
    if len(self.selected_items) == 0:
      self.selected_items = [self.current_article]
      self.showSelectionSequence(1, self.current_article)
    tags = self.current_item = self.canvas.gettags("current")
    if len(tags) > 0:
      self.current_item = tags[0]
      self.current_article = string.atoi(string.split(self.current_item, "-")[1])
      if self.current_article not in self.selected_items:
        item_no = len(self.selected_items) + 1
        self.selected_items.append(self.current_article)
        self.showSelectionSequence(item_no, self.current_article)
        number = self.current_article
        self.canvas.itemconfig("art-%d" % number,
		{"fill": self.colors["select"]})
        self.canvas.itemconfig("subj-%d" % number,
		{"fill": self.colors["select"]})
        self.canvas.itemconfig("auth-%d" % number,
		{"fill": self.colors["select"]})

  def unhighlightItem (self):
    if self.current_item != None:
      if self.article_status.isRead(self.current_article):
        color = self.colors["read"]
      else:
        color = self.colors["normal"]
      number = self.current_article
      self.canvas.itemconfig("art-%d" % number, {"fill": color})
      self.canvas.itemconfig("subj-%d" % number, {"fill": color})
      self.canvas.itemconfig("auth-%d" % number, {"fill": color})
    if len(self.selected_items) > 0:
      self.canvas.delete("sequence")
      for number in self.selected_items:
        if self.article_status.isRead(self.current_article):
          color = self.colors["read"]
        else:
          color = self.colors["normal"]
    self.current_item = None
    self.selected_items = []

  def showSelectionSequence (self, sequence, article_number):
    item = self.canvas.find("withtag", "subj-%d" % article_number)
    coord = self.canvas.coords(item)
    x = self.x_margin - 15
    y = string.split(coord)[1]
    tags = "art-%d seq-%d sequence" % (article_number, sequence)
    self.canvas.create_text(x, y, {"text": "%d" % sequence, "anchor": "nw",
		"tags": tags, "font": self.subject_font,
		"fill": self.colors["select"]})




