#
# setup.py
#
# Copyright 1995 - Koert Zeilstra
#
# No warranty - use at your own risk
#

import posix, posixpath
import string
import Tkinter

import labelentry

class SetupDialog(Tkinter.Toplevel):
  def __init__ (self, parent, app_config):
    self.ok_command = None
    self.close_command = None
    self.app_config = app_config

    Tkinter.Toplevel.__init__(self, parent)
    self.title("Setup Newsflash")

    self.nntp_server = labelentry.LabelEntry(self, "NNTP server", 15, 35)
    self.nntp_server.pack ({"side": "top"})
    self.nntp_port = labelentry.LabelEntry(self, "NNTP port", 15, 10)
    self.nntp_port.pack ({"side": "top", "padx": 4, "fill": "x"})
    self.mail_transport = labelentry.LabelEntry(self, "Mail transport", 15, 25)
    self.mail_transport.pack ({"side": "top", "padx": 4, "fill": "x"})
    self.email = labelentry.LabelEntry(self, "Email address", 15, 35)
    self.email.pack ({"side": "top", "padx": 4, "fill": "x"})
    self.name = labelentry.LabelEntry(self, "Name", 15, 35)
    self.name.pack ({"side": "top", "padx": 4, "fill": "x"})
    self.organization = labelentry.LabelEntry(self, "Organization", 15, 35)
    self.organization.pack ({"side": "top", "padx": 4, "fill": "x"})
    self.signature = labelentry.LabelEntry(self, "Signature", 15, 35)
    self.signature.pack ({"side": "top", "padx": 4, "fill": "x"})
    self.storage = labelentry.LabelEntry(self, "Storage", 15, 35)
    self.storage.pack ({"side": "top", "padx": 4, "fill": "x"})

    buttons = Tkinter.Frame(self, {"relief": "sunken", "bd": 2})
    help_button = Tkinter.Button(buttons, {"text": "Help", "width": 8,
		"command": self.help})
    #help_button.pack ({"side": "left", "pady": 2, "padx": 3})
    cancel_button = Tkinter.Button(buttons, {"text": "Cancel",
		"width": 8, "command": self.cancel})
    cancel_button.pack ({"side": "right", "pady": 2, "padx": 3})
    ok_button = Tkinter.Button(buttons, {"text": "OK", "width": 8,
		"command": self.ok})
    ok_button.pack ({"side": "right", "pady": 2, "padx": 3})
    buttons.pack({"side": "top", "fill": "x"})

  def ok (self):
    self.saveConfig()
    self.close()
    if self.ok_command != None:
      self.ok_command()

  def cancel (self):
    self.close()

  def help (self):
    self.main.help("gui/setup")

  def okCommand (self, func):
    self.ok_command = func

  def closeCommand (self, func):
    self.close_command = func

  def readConfig (self):
    try:
      self.nntp_server.setEntry (posix.environ["NNTP_SERVER"])
    except KeyError:
      self.nntp_server.setEntry ("")
    self.nntp_port.setEntry(119)
    self.mail_transport.setEntry("/usr/lib/sendmail -t")
    nntp_server = self.app_config.get("nntp_server")
    if nntp_server != "":
      self.nntp_server.setEntry(nntp_server)
    nntp_port=self.app_config.get("nntp_port")
    if nntp_port != "":
      self.nntp_port.setEntry(nntp_port)
    mail_transport = self.app_config.get("mail_transport")
    if mail_transport != "":
      self.mail_transport.setEntry(mail_transport)
    self.email.setEntry (self.app_config.get("email"))
    self.name.setEntry (self.app_config.get("name"))
    self.organization.setEntry(self.app_config.get("organization"))
    self.signature.setEntry(self.app_config.get("signature"))
    self.storage.setEntry(self.app_config.get("storage"))

  def saveConfig (self):
    self.app_config.put("nntp_server", self.nntp_server.getEntry())
    self.app_config.put("nntp_port", self.nntp_port.getEntry())
    self.app_config.put("mail_transport", self.mail_transport.getEntry())
    self.app_config.put("email", self.email.getEntry())
    self.app_config.put("name", self.name.getEntry())
    self.app_config.put("organization", self.organization.getEntry())
    self.app_config.put("signature", self.signature.getEntry())
    self.app_config.put("storage", self.storage.getEntry())

  def close (self):
    if self.close_command != None:
      self.close_command()

class ApplicationConfig:
  def __init__ (self):
    self.app_name = "NewsFlash"
    self.version = "0.6.0"
    self.app_config = {}

  def clear (self):
    self.app_config = {}

  def load (self, filename):
    fp = open(filename, "r")
    done = 0
    while done == 0:
      line = fp.readline()
      if not line:
        done = 1
      else:
        items = string.splitfields(line, ":")
        id = string.strip(items[0])
        self.app_config[id] = string.strip(items[1])
    fp.close()

  def save (self, filename):
    fp = open(filename, "w")
    config_list = self.app_config.keys()
    for id in config_list:
      fp.write("%s:%s\n" % (id, self.app_config[id]))
    fp.close()

  def get (self, item):
    if self.app_config.has_key(item):
      return self.app_config[item]
    else:
      return ""

  def put (self, item, value):
    self.app_config[item] = value

  def getVersion (self):
    return self.version

  def getAppVersion (self):
    return "%s %s" % (self.app_name, self.version)

  def getAppName (self):
    return self.app_name

  def getSignature (self):
    filename = self.app_config["signature"]
    fp = open (posixpath.expanduser(filename), "r")
    signature = fp.read()
    return signature









