#
# searchgroups.py
#
# Copyright 1996 - Koert Zeilstra
#
# No warranty - use at your own risk
#

import string
import Tkinter

import labelentry
import multicolumn

#
# SearchGroupsDialog
#
#
class SearchGroupsDialog(Tkinter.Toplevel):
  def __init__(self, parent):
    Tkinter.Toplevel.__init__ (self, parent)
    self.search_command = None
    self.select_command = None
    self.close_command = None
    self.group_names = []
    self.search_field = Tkinter.StringVar()
    self.search_field.set("subject")

    self.string = labelentry.LabelEntry(self,
		"Search String", 15, 20)
    self.string.pack({"side": "top"})

    frame = Tkinter.Frame(self)
    self.list = Tkinter.Listbox(frame, {"relief": "sunken", "bd": 2,
		"exportselection": "no", "width": 25, "height": 10})
    scrollbar = Tkinter.Scrollbar(frame, {"relief": "sunken",
		"command": self.list.yview})
    self.list["yscrollcommand"] = scrollbar.set
    scrollbar.pack({"side": "right", "fill": "y"})
    self.list.pack({"side": "left", "expand": "yes", "fill": "both"})
    frame.pack({"side": "top", "fill": "both", "expand": "yes"})
    self.list.bind("<ButtonRelease-1>", self._clickList)

    buttons = Tkinter.Frame(self, {"relief": "sunken",
		"bd": "1"})
    search_button = Tkinter.Button(buttons, {"text": "Search",
		"width": "8", "command": self.search})
    close_button = Tkinter.Button(buttons, {"text": "Close",
		"width": "8", "command": self.close})
    search_button.pack({"side": "left", "pady": "2", "padx": "3"})
    close_button.pack({"side": "right", "pady": "2", "padx": "3"})
    buttons.pack({"side": "top", "fill": "x"})

    self.protocol("WM_DELETE_WINDOW", self.close)

  def search (self):
    self.list.delete(0, "end")
    self.group_names = []
    if self.search_command != None:
      string = self.string.getEntry()
      groups = self.search_command(string)
      for row, group in groups:
        self.group_names.append((row, group))
        self.list.insert("end", group)

  def close (self):
    if self.close_command != None:
      self.close_command()

  def _clickList (self, event):
    index = self.list.nearest(event.y)
    if self.select_command != None:
      row, group = self.group_names[index]
      self.select_command(row)

  def searchCommand (self, func):
    self.search_command = func

  def selectCommand (self, func):
    self.select_command = func

  def closeCommand (self, func):
    self.close_command = func





