#
# searchart.py
#
# Copyright 1996 - Koert Zeilstra
#
# No warranty - use at your own risk
#

import string
import Tkinter

import labelentry
import multicolumn

#
# SearchDialog
#
#
class SearchDialog(Tkinter.Toplevel):
  def __init__(self, parent):
    Tkinter.Toplevel.__init__ (self, parent)
    self.search_command = None
    self.select_command = None
    self.close_command = None
    self.art_numbers = []
    self.search_field = Tkinter.StringVar()
    self.search_field.set("subject")

    self.string = labelentry.LabelEntry(self,
		"Search String", 15, 35)
    self.string.pack({"side": "top"})

    frame = Tkinter.Frame(self)
    self.subject = Tkinter.Radiobutton(frame, {"text": "Subject",
		"value": "subject", "variable": self.search_field})
    self.author = Tkinter.Radiobutton(frame, {"text": "Author",
		"value": "author", "variable": self.search_field})
    self.subject.pack({"side": "left"})
    self.author.pack({"side": "left"})
    frame.pack({"side": "top"})

    self.columns = multicolumn.MultiColumnList(self,
		2, ["Author", "Subject"])
    self.columns.selectCommand(self.rowSelected)
    self.columns.pack({"side": "top", "fill": "both",
		"expand": "yes"})

    buttons = Tkinter.Frame(self, {"relief": "sunken", "bd": "1"})
    search_button = Tkinter.Button(buttons, {"text": "Search",
		"width": "8", "command": self.search})
    close_button = Tkinter.Button(buttons, {"text": "Close",
		"width": "8", "command": self.close})
    search_button.pack({"side": "left", "pady": "2", "padx": "3"})
    close_button.pack({"side": "right", "pady": "2", "padx": "3"})
    buttons.pack({"side": "top", "fill": "x"})

    self.protocol("WM_DELETE_WINDOW", self.close)

  def search (self):
    self.columns.clearAllColumns()
    self.art_numbers = []
    if self.search_command != None:
      string = self.string.getEntry()
      field = self.search_field.get()
      result = self.search_command(field, string)
      for art in result:
        author = art[0]
        subject = art[1]
        number = art[2]
        self.columns.addRow([author, subject])
        self.art_numbers.append(number)

  def close (self):
    if self.close_command != None:
      self.close_command()

  def rowSelected (self, row):
    number = self.art_numbers[row]
    if self.select_command != None:
      self.select_command(number)

  def searchCommand (self, func):
    self.search_command = func

  def selectCommand (self, func):
    self.select_command = func

  def closeCommand (self, func):
    self.close_command = func



