#
# postdlg.py
#
# Copyright 1996 - Koert Zeilstra
#
# No warranty - use at your own risk
#

import Tkinter

from labelentry import LabelEntry

#
# PostDialog
#
class PostDialog(Tkinter.Toplevel):
  def __init__ (self, parent, app_config, news_fetcher):
    Tkinter.Toplevel.__init__ (self, parent)
    self.close_command = None
    self.app_config = app_config
    self.news_fetcher = news_fetcher
    self.current_group = None
    self.article_number = None

    self.newsgroup = LabelEntry(self, "Newsgroup", 15, 50)
    self.author = LabelEntry(self, "From", 15, 50)
    self.subject = LabelEntry(self, "Subject", 15, 50)
    self.organization = LabelEntry(self, "Organization", 15, 50)
    self.ref = LabelEntry(self, "References", 15, 50)
    for field in [self.newsgroup, self.author, self.subject,
		self.organization, self.ref]:
      field.pack({"side": "top", "fill": "x"})

    frame = Tkinter.Frame(self)
    self.art_text = Tkinter.Text(frame, {"relief": "sunken", "bd": 2,
	"setgrid": 1, "width": 70, "height": 30})
    scroll = Tkinter.Scrollbar(frame, {"relief": "sunken",
	"command": self.art_text.yview, "width": 14})
    self.art_text["yscrollcommand"] = scroll.set
    scroll.pack({"side": "right", "fill": "y"})
    self.art_text.pack({"expand": "yes", "fill": "both"})
    frame.pack({"expand": "yes", "side": "top", "fill": "both"})

    buttons = Tkinter.Frame(self, {"relief": "sunken", "bd": 1})
    self.include_button = Tkinter.Button(buttons, {"text": "Include",
		"width": 8, "command": self.include})
    ok = Tkinter.Button(buttons, {"text": "OK", "width": 8,
		"command": self.ok})
    cancel = Tkinter.Button(buttons, {"text": "Cancel", "width": 8,
		"command": self.close})
    self.include_button.pack({"side": "left", "padx": 3, "pady": 2})
    cancel.pack({"side": "right", "padx": 3, "pady": 2})
    ok.pack({"side": "right", "padx": 3, "pady": 2})
    buttons.pack({"side": "top", "fill": "x"})

    self.organization.setEntry(self.app_config.get("organization"))
    self.author.setEntry("%s (%s)" % (self.app_config.get("email"),
		self.app_config.get("name")))
    self.protocol("WM_DELETE_WINDOW", self.close)

  def include (self):
    article = self.news_fetcher.getArticle(self.article_number,
		self.news_fetcher.ARTICLE_BODY)
    lines = string.split(article)
    inc = ""
    for line in lines:
      inc = inc + "\n> %s" % line
      print "include %s" % line
    self.art_text.insert("1.0", inc)

  def ok (self):
    newsgroup = self.newsgroup.getEntry()
    author =  self.author.getEntry()
    organization = self.organization.getEntry()
    subject = self.subject.getEntry()
    references = self.ref.getEntry()
    article = self.art_text.get("1.0", "end")
    err = self.news_fetcher.postArticle(article, author, newsgroup,
		subject, organization, references)
    if err == 0:
      self.close_command()

  def close (self):
    if self.close_command:
      self.close_command()

  def closeCommand (self, command):
    self.close_command = command

  def setGroupAndClear (self, group):
    self.current_group = group
    self.art_text.delete("1.0", "end")
    text = "\n--\n%s" % self.app_config.getSignature()
    self.art_text.insert("1.0", text)
    self.newsgroup.setEntry(group)
    self.subject.setEntry("")
    self.article_number = None
    self.include_button["state"] = "disabled"

  def setFollowup (self, subject, references, number):
    self.subject.setEntry(subject)
    self.ref.setEntry(references)
    self.article_number = number
    self.include_button["state"] = "normal"





