#
# NewsFlash
#
# Koert Zeilstra
# 1996.01.18
#

import sys
import string
import os

import Tkinter

import filedlg, alert

import about
import groupstat
import newsfetch
import setup
import glist
import threaddlg
import allgroups

debug = 0

class QuitWarningDialog(alert.AlertDialog):
  def SetupDialog(self):
    alert.AlertDialog.SetupDialog(self)
    self.setBitmap('warning')
    self.CreateButton("Yes", self.OkPressed)
    self.CreateButton("No", self.NoPressed)
    self.CreateButton("Cancel", self.CancelPressed)


class MyApp:
  def __init__(self, parent):
    self.thread_dialog = None
    self.setup_dialog = None
    self.groups_dialog = None
    self.rc_filename = "%s/.flashrc/rc" % os.environ["HOME"]
    self.current_file = None
    self.selected_row = None
    self.selected_group = None
    self.news_source = Tkinter.StringVar()
    self.news_source.set("NNTP")

    self.dialog = Tkinter.Toplevel(parent)
    self.dialog.title('Newsflash - 0.5')
    self.dialog.iconname('Newsflash')

    menubar = Tkinter.Frame(self.dialog, {'relief': 'raised', 'bd': 2,
		"class": "Menubar"})
    file = Tkinter.Menubutton (menubar, {'text': 'File', 'underline': 0})
    file.pack ({'side': 'left', "ipadx": 4})
    file_menu = Tkinter.Menu(file)
    file_menu.add ('command', {'label': 'Open...', 'underline': 0, 
		     'command' : self.fileOpen})
    file_menu.add ('command', {'label': 'Open .newsrc', 'underline': 0, 
		     'command' : self.fileOpenNewsRc})
    file_menu.add ('command', {'label': 'Save', 'underline': 0, 
		     'command' : self.fileSave})
    file_menu.add ('command', {'label': 'Save As...', 'underline': 0, 
		     'command' : self.fileSaveAs})
    file_menu.add ('separator')
    file_menu.add ("command", {"label": "Setup...", "underline": 0, 
		     "command": self.fileSetup})
    file_menu.add ("command", {"label": "About...", "underline": 0, 
		     "command": self.fileAbout})
    file_menu.add ('separator')
    file_menu.add ('command', {'label': 'Quit', 'underline': 0, 
		     'command' : self.fileQuit})
    file['menu'] = file_menu

    group = Tkinter.Menubutton (menubar, {"text": "Group", "underline": 0})
    group.pack ({"side": "left", "ipadx": 4})
    group_menu = Tkinter.Menu(group)
    group_menu.add ("command", {"label": "Open...", "underline": 0, 
		     "command": self.groupOpen})
    group_menu.add ("command", {"label": "Delete", "underline": 0,
		     "command": self.groupDelete})
    group_menu.add ("command", {"label": "All Groups...",
		"underline": 0, "command": self.groupAllGroups})
    group['menu'] = group_menu
    if debug == 1:
      news = Tkinter.Menubutton(menubar, {"text": "News", "underline": 0})
      news.pack ({"side": "left", "ipadx": 4})
      news_menu = Menu(news)
      news_menu.add ("radiobutton", {"label": "NNTP", "underline": 0,
		"variable": self.news_source,
		"command": self.changeNewsSource})
      news_menu.add ("radiobutton", {"label": "Local", "underline": 0,
		"variable": self.news_source,
		"command": self.changeNewsSource})
      news["menu"] = news_menu
      #menubar.tk_menuBar (file, group, news)
    #else:
      #menubar.tk_menuBar (file, group)

    menubar.pack ({'side': 'top', 'fill': 'x'})

    self.glist = glist.GroupListFrame (self.dialog)
    self.glist.singleclickCallback (self.singleClickList)
    self.glist.doubleclickCallback (self.doubleClickList)
    self.glist.pack ({'expand':1, 'side' :'top', 'fill' :'both'})

    self.group_stat = groupstat.GroupStat()
    self.app_config = setup.ApplicationConfig()
    try:
      self.app_config.load(self.rc_filename)
    except IOError:
      pass
    self.news_fetcher = newsfetch.NewsFetcher (self.app_config)
    self.news_fetcher.setSource("nntp")

    self.dialog.protocol("WM_DELETE_WINDOW", self.fileQuit)

  def fileOpen (self):
    dialog = filedlg.LoadFileDialog(self.dialog, "Open", "*")
    if dialog.Show() == 1:
      filename = dialog.GetFileName()
      self.openNewsRc (filename)
    dialog.DialogCleanup()

  def fileSave (self):
    self.group_stat.save(self.current_file)

  def fileSaveAs (self):
    dialog = filedlg.SaveFileDialog(self.dialog, "Save", "*")
    if dialog.Show() == 1:
      filename = dialog.GetFileName()
      self.current_file = filename
      self.dialog.title ("%s - %s" % (self.app_config.getAppVersion(),
		filename))
      self.fileSave()
    dialog.DialogCleanup()

  def fileOpenNewsRc (self):
    filename = "%s/.newsrc" % os.environ["HOME"]
    self.openNewsRc (filename)

  def fileSetup (self):
    if self.setup_dialog == None:
      self.setup_dialog = setup.SetupDialog(self.dialog, self.app_config)
      self.setup_dialog.readConfig()
      self.setup_dialog.okCommand (self.okSetupDialog)
      self.setup_dialog.closeCommand (self.setup_dialog.withdraw)
    else:
      self.setup_dialog.deiconify()

  def fileAbout (self):
    dialog = about.AboutDialog(self.dialog, self.app_config)
    dialog.title ("About Newsflash")
    dialog.closeCommand (dialog.destroy)

  def fileQuit(self):
    do_quit = 1
    if self.group_stat.isChanged():
      dialog = QuitWarningDialog(self.dialog,
		"Article status has been changed,\nsave article status to file?")
      dialog.title("Confirm Quit")
      result = dialog.Show()
      if result == 1:
        self.fileSave()
      dialog.DialogCleanup()
      if result == 0:
        do_quit = 0   # user pressed Cancel, don't quit
    if do_quit:
      sys.exit(0)

  def groupOpen (self):
    if self.thread_dialog == None:
      self.thread_dialog = threaddlg.ThreadsDialog(self.dialog,
		self.app_config, self.news_fetcher, self.group_stat)
      self.thread_dialog.title("Group")
      self.thread_dialog.closeCommand(self.thread_dialog.withdraw)
    else:
      self.thread_dialog.deiconify()
    self.thread_dialog.showGroupArticles(self.selected_group)

  def groupDelete (self):
    if self.selected_group != None:
      self.group_stat.deleteGroup(self.selected_group)
      self.glist.delete(self.selected_row)

  def groupAllGroups (self):
    if self.groups_dialog == None:
      self.groups_dialog = allgroups.AllGroupsDialog(self.dialog,
		self, self.app_config, self.news_fetcher)
      self.groups_dialog.closeCommand(self.groups_dialog.withdraw)
      self.groups_dialog.readGroupList()
    else:
      self.groups_dialog.deiconify()
    #self.groups_dialog.showGroupArticles(self.selected_group)

  def changeNewsSource (self):
    source = self.news_source.get()
    if source == "NNTP":
      self.news_fetcher.setSource("nntp")
    elif source == "Local":
      self.news_fetcher.setSource("local")

  def okSetupDialog (self):
    self.app_config.save (self.rc_filename)

  def openNewsRc (self, filename):
    self.glist.clearAll ()
    self.group_stat.load (filename)
    name_length = 0
    groups = self.group_stat.getGroupNames()
    for name in groups:
      if len(name) > name_length:
        name_length = len(name)
      self.glist.insert ('end', ['', name])
    self.glist.columnWidth (1, name_length)
    self.selected_group = None
    self.selected_row = None
    self.current_file = filename
    self.dialog.title ("%s - %s" % (self.app_config.getAppVersion(),
		filename))

  def singleClickList (self, row):
    self.selected_row = row
    #print "singleClickList", row
    self.selected_group = self.group_stat.getGroupName(row)

  def doubleClickList (self, row):
    self.groupOpen()

  def addGroup (self, group_name):
    self.glist.insert ('end', ['', group_name])
    self.group_stat.addGroup (group_name)

dir_name = "%s/.flashrc" % os.environ["HOME"]
if not os.path.exists(dir_name):
  os.mkdir(dir_name, 0700)

root = Tkinter.Tk()
root.withdraw()

root.option_add("*background", "DarkSeaGreen", "widgetDefault")
root.option_add("*highlightBackground", "DarkSeaGreen", "widgetDefault")
root.option_add("*font", "-adobe-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*", "widgetDefault")
root.option_add("*Text*font", "-*-lucidatypewriter-medium-r-normal-*-12-*-*-*-*-*-*-*", "widgetDefault")
root.option_add("*Menubar*font", "-adobe-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-*", "widgetDefault")
root.option_add("*Menubar*activeForeground", "Blue", "widgetDefault")
root.option_add("*Menubar*activeBackground", "DarkSeaGreen", "widgetDefault")
root.option_add("*Button.background", "Gray80", "widgetDefault")
root.option_add("*Button.activeBackground", "Gray90", "widgetDefault")

app = MyApp (root)
app.fileOpenNewsRc()
root.mainloop ()









