#
# multicolumn.py
#
# MultiColumn - multiple columns with scrollbar
#

import string
import Tkinter

# MultiColumnList
#

class MultiColumnList:
  def __init__(self, parent, columns, column_names):
    self.no_of_columns = columns
    self.lists = []
    self.select_command = None
    self.double_command = None
    self.__widget = Tkinter.Frame(parent)

    def_columnwidth = 10
    def_columnheight = 8
    self.select_mode = "single"

    scroll_frame = Tkinter.Frame(self.__widget)
    label = Tkinter.Label(scroll_frame)
    scrollbar = Tkinter.Scrollbar(scroll_frame, {"command":
		self.scrollLists})
    label.pack({"side": "top"})
    scrollbar.pack({"side": "top", "expand": "yes", "fill": "y"})
    scroll_frame.pack({"side": "right", "fill": "y"})

    i = 0
    while i < self.no_of_columns:
      if i < len(column_names):
        name = column_names[i]
      else:
        name = ""

      frame = Tkinter.Frame(self.__widget)
      list_label = Tkinter.Label(frame, {"text": name})
      listbox = Tkinter.Listbox(frame, {"yscroll": scrollbar.set,
	"width": def_columnwidth, "height": def_columnheight,
	"setgrid": "yes", "exportselection": "no",
	"selectmode": self.select_mode})
      self.lists.append(listbox)
      list_label.pack({"side": "top", "fill": "both", "expand": "no"})
      self.lists[i].pack({"side": "top", "fill": "both",
		"expand": "yes"})
      if i == self.no_of_columns-1:
        frame.pack({"side": "left", "fill": "both", "expand": "yes"})
      else:
        frame.pack({"side": "left", "fill": "both", "expand": "no"})
      self.lists[i].bind("<ButtonRelease-1>", self._listClick)
      self.lists[i].bind("<Double-ButtonRelease-1>",
			self._listClickDouble)
      i = i + 1

  def selectCommand (self, func):
    self.select_command = func

  def doubleClickCommand (self, func):
    self.double_command = func

  def pack (self, config):
    self.__widget.pack(config)

  def scrollLists (self, *args):
    if len (args) == 1:
      for list in self.lists:
        list.yview (args[0])
    elif len (args) == 2:
      for list in self.lists:
        list.yview (args[0], args[1])
    elif len (args) == 3:
      for list in self.lists:
        list.yview (args[0], args[1], args[2])

  def _listClick (self, event):
    index = self.lists[0].nearest(event.y)
    for list in self.lists:
      if self.select_mode == "single":
        list.select_clear(0, "end")
      list.select_set(index, index)
    if self.select_command != None:
      self.select_command(index)

  def _listClickDouble (self, event):
    index = self.lists[0].nearest(event.y)
    if self.double_command != None:
      self.double_command(index)

  def clearAllColumns (self):
    for list in self.lists:
      list.delete(0, "end")

  def clearSelection (self):
    for list in self.lists:
      list.select_clear(0, "end")

  def selectRow (self, row, call_callback=1):
    for list in self.lists:
      list.select_clear(0, "end")
      list.select_set(row, row)
    if call_callback == 1 and self.select_command != None:
      self.select_command(row)

  def addRow (self, items):
    i = 0
    for item in items:
      if i < self.no_of_columns:
        self.lists[i].insert("end", item)
      i = i + 1

  def replaceRow (self, row, items):
    for list in self.lists:
      list.delete(row)
      list.insert(row, items[i])

  def deleteRow (self, row):
    for list in self.lists:
      list.delete(row)

  def getRow (self, row_index):
    result = []
    for list in self.lists:
      result.append(list.get(row_index))
    return result

  def setWidth (self, column, width):
    self.lists[i].config("-width", width)







