#!/usr/local/bin/tkpython4.1
#
# MimeViewer
#
# Tkinter mime message viewer
# Koert Zeilstra
# 1996.07.12
#

import sys
import string
import posix
import os

import Tkinter

import filedlg, alert
import labelentry

import mime
import mailcap

class HeaderDialog(Tkinter.Toplevel):
  def __init__(self, parent):
    self._group_name = None
    self._article_number = None
    self._followup_command = None
    self._email_command = None
    self._close_command = None

    Tkinter.Toplevel.__init__(self, parent)

    header_frame = Tkinter.Frame(self)
    self._header_list = Tkinter.Listbox(header_frame,
	{"relief": "sunken", "bd": 2, "width": 70, "height": 6})
    scrollbar = Tkinter.Scrollbar(header_frame, {"relief": "sunken",
	"command": self._header_list.yview})
    self._header_list["yscrollcommand"] = scrollbar.set
    scrollbar.pack({"side": "right", "fill": "y"})
    self._header_list.pack({"side": "left", "expand": "yes",
		"fill": "both"})
    header_frame.pack({"side": "top", "fill": "both",
		"expand": "yes"})

    button_frame = Tkinter.Frame(self)
    close_btn = Tkinter.Button(button_frame, {"text": "Close",
		"width": 8, "command": self.close})
    close_btn.pack({"side": "right", "padx": 3, "pady": 2})
    button_frame.pack({"side": "top", "fill": "x"})

    self.protocol("WM_DELETE_WINDOW", self.close)

  def close (self):
    if self._close_command != None:
      self._close_command()
    else:
      self.withdraw()

  def closeCommand (self, command):
    self._close_command = command

  def showHeaders(self, message):
    self._header_list.delete(0, "end")
    for field in message.getHeaders():
      value = message.getHeaderField(field)
      self._header_list.insert("end", "%s: %s" % (field, value))


class MimeViewer(Tkinter.Toplevel):
  def __init__(self, parent):
    self.current_file = None
    self._group_name = None
    self._article_number = None
    self._followup_command = None
    self._email_command = None
    self._close_command = None
    self._header_dialog = None

    Tkinter.Toplevel.__init__(self, parent)

    menubar = Tkinter.Frame(self, {'relief': 'raised', 'bd': 2,
		"class": "Menubar"})
    msg = Tkinter.Menubutton (menubar, {'text': 'Message',
		'underline': 0})
    msg.pack ({'side': 'left', "ipadx": 4})
    msg_menu = Tkinter.Menu(msg)
    msg_menu.add ('command', {'label': 'Show Headers...',
		'underline': 5, 'command' : self.showMoreHeaders})
    msg_menu.add ('separator')
    msg_menu.add ('command', {'label': 'Save...', 'underline': 0, 
		     'command' : self.save})
    msg_menu.add ('command', {'label': 'Followup...', 'underline': 0, 
		     'command' : self.followup})
    msg_menu.add ('command', {'label': 'Email...', 'underline': 0,
		     'command' : self.email})
    msg_menu.add ('separator')
    msg_menu.add ('command', {'label': 'Close', 'underline': 0, 
		     'command' : self.close})
    msg['menu'] = msg_menu
    menubar.pack ({'side': 'top', 'fill': 'x'})

    header_frame = Tkinter.Frame(self)
    field_frame = Tkinter.Frame(header_frame)
    self.group = labelentry.LabelEntry(field_frame, "Newsgroup", 15, 50)
    self.author = labelentry.LabelEntry(field_frame, "From", 15, 50)
    self.subject = labelentry.LabelEntry(field_frame, "Subject", 15, 50)
    self.group.pack({"side": "top", "fill": "x"})
    self.author.pack({"side": "top", "fill": "x"})
    self.subject.pack({"side": "top", "fill": "x"})
    field_frame.pack({"side": "left", "fill": "x"})

    header_buttons = Tkinter.Frame(header_frame)
    more_btn = Tkinter.Button(header_buttons, {"text": "More..",
		"width": 8, "command": self.showMoreHeaders})
    more_btn.pack({"side": "top", "padx": 3, "pady": 2})
    #header_buttons.pack({"side": "left"})
    header_frame.pack({"side": "top", "fill": "x"})

    parts_frame = Tkinter.Frame(self)
    self.parts_list = Tkinter.Listbox(parts_frame,
	{"relief": "sunken", "bd": 2, "width": 70, "height": 3})
    scrollbar = Tkinter.Scrollbar(parts_frame, {"relief": "sunken",
	"command": self.parts_list.yview})
    self.parts_list["yscrollcommand"] = scrollbar.set
    scrollbar.pack({"side": "right", "fill": "y"})
    self.parts_list.pack({"side": "left", "expand": "yes",
		"fill": "both"})
    parts_frame.pack({"side": "top", "fill": "both",
		"expand": "yes"})
    self.parts_list.bind("<ButtonRelease-1>", self._clickPartsList)

    frame = Tkinter.Frame(self)
    self.text = Tkinter.Text(frame, {"relief": "sunken", "bd": 2,
		"setgrid": 1, "width": 70, "height": 30})
    scrollbar = Tkinter.Scrollbar(frame, {"relief": "sunken",
		"command": self.text.yview, "width": 14})
    self.text["yscrollcommand"] = scrollbar.set
    scrollbar.pack({"side": "right", "fill": "y"})
    self.text.pack({"expand": 1, "fill": "both"})
    frame.pack({"expand": 1, "side": "top", "fill": "both"})

    button_frame = Tkinter.Frame(self)
    save_btn = Tkinter.Button(button_frame, {"text": "Save..", "width": 8,
		"command": self.save})
    followup_btn = Tkinter.Button(button_frame, {"text": "Followup..", "width": 8,
		"command": self.followup})
    reply_btn = Tkinter.Button(button_frame, {"text": "Email..", "width": 8,
		"command": self.email})
    close_btn = Tkinter.Button(button_frame, {"text": "Close", "width": 8,
		"command": self.close})
    save_btn.pack({"side": "left", "padx": 3, "pady": 2})
    followup_btn.pack({"side": "left", "padx": 3, "pady": 2})
    reply_btn.pack({"side": "left", "padx": 3, "pady": 2})
    close_btn.pack({"side": "right", "padx": 3, "pady": 2})
    #button_frame.pack({"side": "top", "fill": "x"})

    self.protocol("WM_DELETE_WINDOW", self.close)

    self._mailcap = mailcap.Mailcap()
    filename = "%s/%s" % (os.environ["HOME"], ".mailcap")
    if os.path.exists(filename):
      self._mailcap.parse(filename)
    #self._mailcap.printAll()

  def showMoreHeaders(self):
    if self._header_dialog == None:
      self._header_dialog = HeaderDialog(self)
      self._header_dialog.title("Headers")
    else:
      self._header_dialog.deiconify()
    self._header_dialog.showHeaders(self._message)

  def save (self):
    dialog = filedlg.SaveFileDialog(self, "Save", "*")
    if dialog.Show() == 1:
      filename = dialog.GetFileName()
      self.art_window.save(filename)
    dialog.DialogCleanup()

  def followup (self):
    if self._followup_command != None:
      subject = self._message.getHeaderField("Subject")
      references = self._message.getHeaderField("Message-ID")
      art_number = self._article_number
      group = self._group_name
      self._followup_command(subject, references, group, art_number)

  def email (self):
    if self._email_command != None:
      address = self._message.getHeaderField("From")
      subject = self._message.getHeaderField("Subject")
      references = self._message.getHeaderField("Message-ID")
      art_number = self._article_number
      group = self._group_name
      self._email_command(address, subject, group, art_number)

  def close (self):
    if self._close_command != None:
      self._close_command()
    else:
      self.withdraw()
      #sys.exit(0)

  def followupCommand (self, command):
    self._followup_command = command

  def emailCommand (self, command):
    self._email_command = command

  def closeCommand (self, command):
    self._close_command = command

  def _clickPartsList (self, event):
    row = self.parts_list.nearest(event.y)
    if row >= 0 and row != self._selected_part:
      self._selected_part = row
      self.showPart(self._selected_part)

  def showMessage(self, group, art_number, file):
    self._group_name = group
    self._article_number = art_number

    self._selected_part = -1
    self._message = mime.Message()
    self._message.parse(file)

    #self.header_list.delete(0, "end")
    mime_version = ""
    for field in self._message.getHeaders():
      value = self._message.getHeaderField(field)
      if field == "Newsgroups":
        self.group.setEntry(value)
      elif field == "From":
        self.author.setEntry(value)
      elif field == "Subject":
        self.subject.setEntry(value)
      elif field == "Mime-Version":
        mime_version = value
      #self.header_list.insert("end", "%s: %s" % (field, value))

    self.parts_list.delete(0, "end")
    if mime_version == "":
      # No MIME
      self._selected_part = -2
    else:
      i = 0
      for part in self._message.getParts():
        value = "%s/%s" % (part.getMainType(), part.getSubType())
        self.parts_list.insert("end", value)
        if self._selected_part == -1 and part.getMainType() == "text":
          self._selected_part = i
        i = i + 1

    if self._selected_part >= 0:
      self.parts_list.select_set(self._selected_part)
    self.showPart(self._selected_part)

  def showPart (self, part_no):
    if part_no == -2 or part_no == -1:
      # No MIME, show whole message
      part = self._message
    else:
      part = self._message.getParts()[part_no]
    #print "showPart", part_no, part.getMainType()
    type = part.getMainType()
    subtype = part.getSubType()
    filename = part.getFilename()
    if filename:
      if self._mailcap.view(type, subtype, filename) != 0:
        if type == "text":
          file = open(filename, "r")
          text = file.read()
          self.text.delete("1.0", "end")
          self.text.insert("1.0", text)
          file.close()
        else:
          print "showPart: cannot view %s/%s", (type, subtype)

def test_exit():
  sys.exit(0)

if __name__ == "__main__":
  root = Tkinter.Tk()
  root.withdraw()

  root.option_add("*background", "DarkSeaGreen", "widgetDefault")
  root.option_add("*highlightBackground", "DarkSeaGreen", "widgetDefault")
  root.option_add("*font", "-adobe-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*", "widgetDefault")
  root.option_add("*Text*font", "-*-lucidatypewriter-medium-r-normal-*-12-*-*-*-*-*-*-*", "widgetDefault")
  root.option_add("*Menubar*font", "-adobe-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-*", "widgetDefault")
  root.option_add("*Menubar*activeForeground", "Blue", "widgetDefault")
  root.option_add("*Menubar*activeBackground", "DarkSeaGreen", "widgetDefault")
  root.option_add("*Button.background", "Gray80", "widgetDefault")
  root.option_add("*Button.activeBackground", "Gray90", "widgetDefault")

  viewer = MimeViewer (root)
  viewer.closeCommand(test_exit)

  filename = sys.argv[1]
  file = open(filename, "r")
  viewer.showMessage(file)

  root.mainloop ()


