#
# Message
#
# Mime Message handler
# Koert Zeilstra
# 1996.07.15
#


import sys
import os
import string
import mimetools
import tempfile

class Message:
  def __init__(self):
    self._header = None
    self._boundary = None
    self._filename = None
    self._parts = []

  def __del__(self):
    if self._filename:
      os.unlink(self._filename)

  def parse(self, file, part_boundary=None):
    """ Parse the headers and get the parts, if any """
    self._header = mimetools.Message(file)
    #print "headers", self._header.headers, self._header.getplist()
    if len(self._header) == 0:
      ret = 0
    else:
      #print "main-type:", self._header.getmaintype()
      if self._header.getmaintype() == "multipart":
        self._boundary = self._header.getparam("boundary")
        self._readParts(file)
        ret = 1
      else:
        # Copy part into temporary file
        filename = tempfile.mktemp()
        out_file = open(filename, "w")
        last_line = self._savePart(file, out_file, part_boundary)
        out_file.close()
        encoding = self._header.getencoding()
        if encoding in ["base64", "uuencode", "quoted-printable"]:
          # Decode part of it's not text
          out_filename = tempfile.mktemp()
          in_file = open(filename, "r")
          out_file = open(out_filename, "w")
          mimetools.decode(in_file, out_file, encoding)
          print "decoded", out_filename
          in_file.close()
          out_file.close()
          os.unlink(filename)
          self._filename = out_filename
        else:
          self._filename = filename
        if string.find(last_line, "--%s--" % part_boundary) == -1:
          ret = 1 # Last boundary has not been read
        else:
          ret = 2 # Last boundary has been read
    return ret

  def _savePart(self, in_file, out_file, part_boundary=None):
    """ Copy line by line from message file into output file """
    line = in_file.readline()
    if part_boundary:
      while line and string.find(line, part_boundary) == -1:
        out_file.write(line)
        line = in_file.readline()
    else:
      while line:
        out_file.write(line)
        line = in_file.readline()
    return line

  def _readParts(self, file):
    # Find the first boundary
    line = file.readline()
    while line and string.find(line, self._boundary) == -1:
      line = file.readline()

    done = 0
    while not done:
      part = Message()
      status = part.parse(file, self._boundary)
      if status == 1 or status == 2:
        self._parts.append(part)
      if status == 0 or status == 2:
        done = 1

  def getParts(self):
    return self._parts

  def getParameter(self, name):
    value = None
    try:
      value = self._header.getparam(name)
    except:
      pass
    return value

  def getHeaders(self):
    return self._header.keys()

  def getHeaderField(self, name):
    value = None
    try:
      value = self._header[name]
    except:
      pass
    return value

  def getMainType(self):
    return self._header.getmaintype()

  def getSubType(self):
    return self._header.getsubtype()

  def getFilename(self):
    return self._filename

  def printAll(self):
    print "==========================="
    print "from", self.getHeaderField("from")
    print "subject", self.getHeaderField("subject")
    print "mime-version", self.getHeaderField("mime-version")
    print "content-type", self._header["content-type"]
    print "filename", self._filename
    print "boundary", self._boundary
    print "main-type:", self._header.getmaintype()
    print "sub-type:", self._header.getsubtype()
    print "encoding:", self._header.getencoding()

    for part in self._parts:
      print "-------------------------"
      part.printAll()
      print "name", part.getParameter("name")

if __name__ == "__main__":
  file = open(sys.argv[1], "r")

  message = Message()
  message.parse(file)

  message.printAll()



