#
# Mailcap
#
# Mime file types
# Koert Zeilstra
# 1996.07.16
#


import sys
import os
import string

class Mailcap:
  def __init__(self):
    self._types = {}

  def __del__(self):
    pass

  def parse(self, filename):
    """ Parse the .mailcap file """
    file = open(filename, "r")
    line = file.readline()
    while line:
      line = string.strip(line)
      if len(line) > 0 and line[0] != "#":
        i = string.find(line, ";")
        if i > 0:
          self._addType(line[:i], line[i+1:])
      line = file.readline()

  def view(self, type, subtype, filename):
    result = 1
    if self._types.has_key(type):
      subtypes = self._types[type]
      if subtypes.has_key(subtype):
        command = subtypes[subtype]
      elif subtypes.has_key("*"):
        command = subtypes["*"]
      else:
        command = ""
      if command != "":
        os.system(command % filename)
        result = 0
    return result

  def _addType(self, key_part, command):
    keys = string.splitfields(key_part, "/")
    if len(keys) == 2:
      if not self._types.has_key(keys[0]):
        self._types[keys[0]] = {}
      self._types[keys[0]][keys[1]] = string.strip(command)

  def printAll(self):
    for key1 in self._types.keys():
      print "Main type", key1
      print self._types[key1]

if __name__ == "__main__":
  mailcap = Mailcap()
  mailcap.parse(sys.argv[1])
  mailcap.printAll()



