#
# Python based news reader
#
# Copyright 1995 - Koert Zeilstra
#
# No warranty - use at your own risk
#

import string

class GroupStat:
  def __init__ (self):
    self.reset()
    self.read_articles = {}
    self.group_names = []

  def reset (self):
    self.read_articles = {}
    self.group_names = []
    self.max_name_length = 0
    self.is_changed = 0

  def load (self, filename):
    fp = open (filename, "r")
    done = 0
    self.group_names = []
    self.read_articles = {}
    while done == 0:
      line = fp.readline()
      if not line:
        done = 1
      else:
        p = string.find (line, ':')
        if p != -1:
          group_name = string.strip(line[:p])
          self.group_names.append(group_name)
          rest = string.strip(line[p+1:])
          try:
            dummy = string.index (rest, ",")
            self.read_articles[group_name] = string.splitfields (rest, ",")
          except ValueError:
            self.read_articles[group_name] = [rest]
          if len(group_name) > self.max_name_length:
            self.max_name_length = len(group_name)
    self.is_changed = 0
    fp.close()

  def save (self, filename):
    fp = open(filename, "w")
    groups = self.read_articles.keys()
    groups.sort()
    for group in groups:
      if len(self.read_articles[group]) > 1:
        fp.write("%s: %s\n" % (group, string.joinfields(self.read_articles[group], ",")))
      elif len(self.read_articles[group]) == 1:
        fp.write("%s: %s\n" % (group, self.read_articles[group][0]))
      else:
        fp.write("%s: 1\n" % group)
    fp.close()
    self.is_changed = 0

  def getGroupNames (self):
    groups = self.group_names
    return groups

  def getGroupName (self, index):
    return self.group_names[index]

  def deleteGroup (self, group):
    index = self.group_names.index(group)
    del self.group_names[index]
    del self.read_articles[group]
    self.is_changed = 1

  def addGroup (self, group):
    if not self.read_articles.has_key(group):
      self.group_names.append(group)
      self.read_articles[group] = ["0"]
      self.is_changed = 1

  def setGroupReadArticles (self, group, artlist):
    self.read_article[group] = string.splitfields(artlist, ",")
    self.is_changed = 1

  def updateGroupReadArticles (self, group, artlist):
    self.read_articles[group] = artlist
    self.is_changed = 1

  def getGroupReadArticles (self, group):
    if self.read_articles.has_key(group):
      return self.read_articles[group]
    else:
      return ""

  def isRead (self, group, article):
    found = 0
    if self.read_articles.has_key(group):
      for artlist in self.read_articles.keys():
        alist = string.splitfields (artlist, "-")
        if len(alist) == 1:
          if alist == article:
            found = 1
            break
        else:
          if article >= alist[0] or article <= alist[1]:
            found = 1
            break
    return found

  def getLast (self, group):
    if self.read_articles.has_key(group):
      art = self.read_articles[group][-1]
      alist = string.splitfields(art, "-")
      number = string.atoi(alist[-1])
    else:
      number = 1
    return number

  def isChanged (self):
   return self.is_changed

  def addArticle (self, group, number):
    self.read_articles[group] = ["1-%d" % number]


class ArticleList:
  def __init__(self):
    self.article_array = {}
    self.lowest_number = 1
    #
    # self.article_array contains indexes to art. numbers
    # example: self.article_array[123] = 1  Article 123 is read

  def setArticleList (self, list):
    self.article_array = {}
    length = len(list)
    if length == 0:
      self.lowest_number = 1
    else:
      first_art = list[0]
      if string.find(first_art, "-") == -1:
        self.lowest_number = string.atoi(first_art)
      else:
        self.lowest_number = string.atoi(string.splitfields(first_art, "-")[1])

      if length > 1:
        numbers = list[1:]
        for art in numbers:
          if string.find(art, "-") != -1:
            art = string.splitfields(art, "-")
            art1 = string.atoi(art[0])
            art2 = string.atoi(art[1])
            i = art1
            while i < art2:
              self.article_array[i] = 1
              i = i + 1
          else:
            self.article_array[string.atoi(art)] = 1
        # for art...
      # if length > 1
    # if length == 0

  def getArticleList (self):
    result = []
    numbers = self.article_array.keys()
    numbers.sort()
    length = len(numbers)
    #if self.lowest_number > 1:
    #  result = ["1-%d" % self.lowest_number]
    start = 1
    previous_number = self.lowest_number
    for number in numbers:
      if previous_number != 1 and previous_number != number-1:
        if start == previous_number:
          result.append("%d" % start)
        else:
          result.append("%d-%d" % (start, previous_number))
        start = number
      previous_number = number
    if len(numbers) > 0:
      number = numbers[-1]
      if start == number:
        result.append("%d" % start)
      else:
        result.append("%d-%d" % (start, number))
    else:
      if self.lowest_number > 1:
        result = ["1-%d" % self.lowest_number]
      else:
        result = ["1"]
    return result

  def getLowestNumber (self):
    return self.lowest_number

  def setLowestNumber (self, number):
    self.lowest_number = number

  def isRead (self, number):
    if number <= self.lowest_number:
      return 1
    number_str = "%d" % number
    if self.article_array.has_key(number):
      return self.article_array[number]
    else:
      return 0

  def setRead (self, number):
    number_str = "%d" % number
    self.article_array[number] = 1

  def setReadAll (self, number):
    self.lowest_number = number
    self.article_array = {}

  def setNotRead (self, number):
    number_str = "%d" % number
    self.article_array.remove(number)







