#
# Newsflash
#
# Koert Zeilstra
# 1995.12.22
#

import Tkinter

class GroupListFrame:
  def __init__(self, parent):
    self.no_of_columns = 2
    self.frame = Tkinter.Frame(parent)
    scrollbar = Tkinter.Scrollbar(self.frame, {'orient':'vertical'})
    scrollbar.pack ({'side':'right', 'fill':'y'})
    self.glist = []
    i = 0
    while i < self.no_of_columns:
      list = Tkinter.Listbox(self.frame, {'yscroll': scrollbar.set,
		'width': 4, "exportselection": "no",
		"selectmode": "single"})
      #list.tk_listboxSingleSelect()
      if i == 1:
        list.pack ({'side' :'left', 'pady' :'1', 'fill' :'both',
			"expand": "yes"})
      else:
        list.pack ({'side' :'left', 'pady' :'1', 'fill' :'y'})
      list.bind ('<ButtonPress-1>', self.singleClickList)
      self.glist.append (list)
      i = i + 1
    scrollbar['command'] = self.scrollLists

  def pack (self, config):
    self.frame.pack(config)

  def clearAll (self):
    for list in self.glist:
      list.delete (0, 'end')

  def insert (self, row, value):
    i = 0
    for list in self.glist:
      list.insert (row, value[i])
      i = i + 1

  def delete (self, row):
    for list in self.glist:
      list.delete (row)

  def select (self, row):
    for list in self.glist:
      list.select_clear(0, "end")
      list.select_set(row, row)

  def columnWidth(self, column, width):
    self.glist[column]['width'] = width

  def scrollLists (self, *args):
    if len (args) == 1:
      for list in self.glist:
        list.yview (args[0])
    elif len (args) == 2:
      for list in self.glist:
        list.yview (args[0], args[1])
    elif len (args) == 3:
      for list in self.glist:
        list.yview (args[0], args[1], args[2])

  def singleclickCallback (self, func):
    self.singleclick_callback = func

  def doubleclickCallback (self, func):
    for list in self.glist:
      list.bind ("<Double-Button-1>", self.doubleClickList)
    self.doubleclick_callback = func

  def singleClickList (self, event):
    y = event.y
    self.current_row = event.widget.nearest (y)
    self.select (self.current_row)
    self.singleclick_callback (self.current_row)

  def doubleClickList (self, event):
    y = event.y
    self.current_row = event.widget.nearest (y)
    self.doubleclick_callback (self.current_row)



