#
# emaildlg.py
#
# Copyright 1996 - Koert Zeilstra
#
# No warranty - use at your own risk
#

import os
import Tkinter

import labelentry

#
# EmailWindow
#
class EmailWindow(Tkinter.Frame):
  def __init__ (self, parent, app_config):
    Tkinter.Frame.__init__ (self, parent)
    self._app_config = app_config

    self._to = labelentry.LabelEntry(self, "To", 15, 50)
    self._from = labelentry.LabelEntry(self, "From", 15, 50)
    self._subject = labelentry.LabelEntry(self, "Subject", 15, 50)
    self._to.pack({"side": "top",  "fill": "x"})
    self._from.pack({"side": "top",  "fill": "x"})
    self._subject.pack({"side": "top",  "fill": "x"})

    frame = Tkinter.Frame(self)
    self._text = Tkinter.Text(frame, {"relief": "sunken", "bd": 2,
	"setgrid": 1, "width": 70, "height": 30})
    scroll = Tkinter.Scrollbar(frame, {"relief": "sunken",
	"command": self._text.yview, "width": 14})
    self._text["yscrollcommand"] = scroll.set
    scroll.pack({"side": "right", "fill": "y"})
    self._text.pack({"expand": "yes", "fill": "both"})
    frame.pack({"expand": "yes", "side": "top", "fill": "both"})
 
    self._from.setEntry(self._app_config.get("email"))

  def clearAll(self):
    self._text.delete("1.0", "end")
    self._to.setEntry("")
    self._from.setEntry("")
    self._subject.setEntry("")
    self._text.insert("1.0", "\n\n%s" % self._app_config.getSignature())

  def setArticleBody(self, text):
    self._text.delete("1.0", "end")
    self._text.insert("1.0", text)

  def setHeaders(self, address, author, subject):
    self._to.setEntry(address)
    self._from.setEntry(author)
    self._subject.setEntry(subject)

  def save(self, filename):
    article = self._text.get("1.0", "end")
    fp = open(filename, "w")
    fp.write("To: %s\n" % self._to.getEntry())
    fp.write("From: %s\n" % self._from.getEntry())
    fp.write("Subject: %s\n" % self._subject.getEntry())
    fp.write(article)
    fp.close()

  def getToAddress(self):
    return self._to.getEntry()

  def getMessage(self):
    message = "From: %s\nTo: %s\nSubject: %s\n\n%s" % (self._from.getEntry(),
		self._to.getEntry(), self._subject.getEntry(),
		self._text.get("1.0",  "end"))
    return message

#
# EmailDialog
#
class EmailDialog(Tkinter.Toplevel):
  def __init__ (self, parent, app_config):
    Tkinter.Toplevel.__init__ (self, parent)
    self._app_config = app_config
    self._close_command = None

    self._email = EmailWindow(self, self._app_config)
    self._email.pack({"expand": "yes", "side": "top", "fill": "both"})

    frame = Tkinter.Frame(self, {"relief": "sunken", "bd": 1})
    ok_button = Tkinter.Button(frame, {"text": "OK", "width": 8,
		"command": self.ok})
    cancel_button = Tkinter.Button(frame, {"text": "Cancel",
		"width": 8, "command": self.close})
    cancel_button.pack({"side": "right", "padx": 3, "pady": 2})
    ok_button.pack({"side": "right", "padx": 3, "pady": 2})
    frame.pack({"side": "top", "fill": "x"})

    self.protocol("WM_DELETE_WINDOW", self.close)

  def ok(self):
    address = self._email.getToAddress()
    message = self._email.getMessage()
    transport = self._app_config.get("mail_transport")
    fp = os.popen("%s \"%s\"" % (transport, address), "w")
    fp.write(message)
    fp.close()
    self.close()

  def close(self):
    if self._close_command != None:
      self._close_command()

  def setAddressSubject(self, address, subject):
    author = "%s %s" % (self._app_config.get("email"),
		self._app_config.get("name"))
    self._email.clearAll()
    self._email.setHeaders(address, author, subject)

  def closeCommand(self, command):
    self._close_command = command




