#
# articlewnd.py
#
# Copyright 1995 - Koert Zeilstra
#
# No warranty - use at your own risk
#

import Tkinter

from labelentry import *

#
# ArticleWindow
#
#
class ArticleWindow(Tkinter.Frame):
  def __init__ (self, parent, dialog, app_config, news_fetcher,
		config=None):
    Tkinter.Frame.__init__(self, parent)
    self.article_dialog = dialog
    self.app_config = app_config
    self.news_fetcher = news_fetcher

    self.popup_menu = Tkinter.Menu(self, {"tearoff": 0})
    self.popup_menu.add("command", {"label": "Show Headers..",
		"underline": 0,
		"command": self.article_dialog.showHeaders})
    self.popup_menu.add("separator")
    self.popup_menu.add("command", {"label": "Check PGP Signature..",
		"underline": 6,
		"command": self.article_dialog.checkPGPSig})
    self.popup_menu.add("command", {"label": "Uudecode",
		"underline": 0,
		"command": self.article_dialog.uudecode})

    self.group = LabelEntry(self, "Newsgroup", 15, 50)
    self.author = LabelEntry(self, "From", 15, 50)
    self.subject = LabelEntry(self, "Subject", 15, 50)
    self.org = LabelEntry(self, "Organization", 15, 50)
    self.ref = LabelEntry(self, "References", 15, 50)
    self.group.pack({"side": "top", "fill": "x"})
    self.author.pack({"side": "top", "fill": "x"})
    self.subject.pack({"side": "top", "fill": "x"})
    self.org.pack({"side": "top", "fill": "x"})
    self.ref.pack({"side": "top", "fill": "x"})

    frame = Tkinter.Frame(self)
    self.text = Tkinter.Text(frame, {"relief": "sunken", "bd": 2,
		"setgrid": 1, "width": 70, "height": 30})
    scrollbar = Tkinter.Scrollbar(frame, {"relief": "sunken",
		"command": self.text.yview, "width": 14})
    self.text["yscrollcommand"] = scrollbar.set
    scrollbar.pack({"side": "right", "fill": "y"})
    self.text.pack({"expand": 1, "fill": "both"})
    frame.pack({"expand": 1, "side": "top", "fill": "both"})

    self.text.bind("<ButtonPress-3>", self.popupMenu)

    self.org.setEntry(self.app_config.get("organization"))
    address = "%s (%s)" % (self.app_config.get("email"),
		self.app_config.get("name"))
    self.author.setEntry(address)

  #def pack (self, config):
  #  self.__widget.pack(config)

  def popupMenu (self, event):
    px = event.x + self.text.winfo_rootx()
    py = event.y + self.text.winfo_rooty()
    #self.text.tk.call("tk_popup", event.__widget.name, px, py)

  def clearAll (self):
    self.text.delete("1.0", "end")
    self.group.setEntry("")
    self.author.setEntry("")
    self.subject.setEntry("")
    self.org.setEntry("")
    self.ref.setEntry("")

  def setArticleBody (self, text):
    self.text.delete("1.0", "end")
    self.text.insert("1.0", text)

  def setHeaders (self, headers):
    self.group.setEntry(headers["Newsgroups"])
    self.author.setEntry(headers["From"])
    self.subject.setEntry(headers["Subject"])
    self.org.setEntry(headers["Organization"])
    self.ref.setEntry(headers["References"])

  def save (self, filename):
    article = self.text.get("1.0", "end")
    fp = open(filename, "w")
    fp.write("Newsgroup: %s\n" % self.group.getEntry())
    fp.write("From: %s\n" % self.author.getEntry())
    fp.write("Subject: %s\n" % self.subject.getEntry())
    fp.write("Organization: %s\n" % self.org.getEntry())
    fp.write("References: %s\n" % self.ref.getEntry())
    fp.write(article)
    fp.close()

  def getArticleText (self):
    return self.text.get("1.0", "end")






