#
# artdialog.py
#
# Copyright 1995 - Koert Zeilstra
#
# No warranty - use at your own risk
#

import tempfile
import string
import Tkinter
import filedlg

import articlewnd

#
# ArticleDialog
#
#
class ArticleDialog(Tkinter.Toplevel):
  def __init__ (self, parent, thread_dlg, app_config, news_fetcher,
		config=None):
    Tkinter.Toplevel.__init__ (self, parent)
    self.thread_dialog = thread_dlg
    self.app_config = app_config
    self.news_fetcher = news_fetcher
    self.ok_command = None
    self.close_command = None
    self.window_title = ""
    self.header_dialog = None
    self.file_dialog = None
    self.header_field = None
    self.current_article = None
    self.current_group = None
    self.header_text = None

    self.art_window = articlewnd.ArticleWindow(self,
		self, self.app_config, self.news_fetcher)
    self.art_window.pack ({"expand": 1, "side": "top",
		"fill": "both"})

    frame = Tkinter.Frame(self)
    save_btn = Tkinter.Button(frame, {"text": "Save..", "width": 8,
		"command": self.save})
    followup_btn = Tkinter.Button(frame, {"text": "Followup..", "width": 8,
		"command": self.followup})
    reply_btn = Tkinter.Button(frame, {"text": "Email..", "width": 8,
		"command": self.email})
    close_btn = Tkinter.Button(frame, {"text": "Close", "width": 8,
		"command": self.close})
    save_btn.pack({"side": "left", "padx": 3, "pady": 2})
    followup_btn.pack({"side": "left", "padx": 3, "pady": 2})
    reply_btn.pack({"side": "left", "padx": 3, "pady": 2})
    close_btn.pack({"side": "right", "padx": 3, "pady": 2})
    frame.pack({"side": "top", "fill": "x"})

    #wm protocol . WM_DELETE_WINDOW "$this close"

  def showHeaders (self):
    header = self.news_fetcher.getArticle(self.current_article,
		"head")
    if self.header_dialog == None:
      self.header_dialog = headerdlg.HeaderDialog(self)
      self.header_dialog.title("Header")
      self.header_dialog.closeCommand(self.header_dialog.withdraw)
    else:
      self.header_dialog.deiconify()
    self.header_dialog.showHeader(self.current_group, header)

  def checkPGPSig (self):
    article_text = ""
    tmp_file = tempfile.mktemp()
    fp = open("|pgp -f >%s.out 2>%s.err" % (filename, filename), "w")
    fp.write(article_text)
    fp.close()
    pgp_out = ""
    pgp_err = ""
    fp = open("%s.err" % filename, "r")
    pgp_err = fp.read()
    fp.close()
    os.system("rm -f %s.out %s.err" % (filename, filename))
    if self.pgp_dialog == None or not self.pgp_dialog.winfo_exists():
      self.pgp_dialog = pgpdialog.PgpSignatureDialog(self)
      self.pgp_dialog.title("PGP Signature")
      self.pgp_dialog.closeCommand(self.pgp_dialog.destroy)
    self.pgp_dialog.setResult(pgp_err)

  def uudecode (self):
    tmp_file = tempfile.mktemp()
    self.art_window.save(tmp_file)
    uu.decode(tmp_file)
    os.system("rm %s" % tmp_file)

  def save (self):
    dialog = filedlg.SaveFileDialog(self, "Save", "*")
    if dialog.Show() == 1:
      filename = dialog.GetFileName()
      self.art_window.save(filename)
    dialog.DialogCleanup()

  def followup (self):
    if self.header_field.has_key("Subject"):
      subject = self.header_field["Subject"]
      if subject[:3] != "Re:":
        subject = "Re: %s" % subject
    else:
      subject = ""
    if self.header_field.has_key("Message-ID"):
      references = self.header_field["Message-ID"]
    else:
      references = ""
    if self.thread_dialog != None:
      self.thread_dialog.followup(subject, references,
			self.current_article)

  def email (self):
    if self.header_field.has_key("Subject"):
      subject = self.header_field["Subject"]
      if subject[:3] != "Re:":
        subject = "Re: %s" % subject
    else:
      subject = ""
    if self.header_field.has_key("From"):
      address = self.header_field["From"]
    else:
      address = ""
    if self.thread_dialog != None:
      self.thread_dialog.email(address, subject)

  def close (self):
    if self.close_command != None:
      self.close_command()

  def closeCommand (self, command):
    self.close_command = command

  def title (self, new_title):
    Tkinter.Toplevel.title(self, new_title)
    self.window_title = new_title

  def showArticle (self, group_name, article_number):
    #self.title("%s - %s" % (self.window_title, self.current_group))
    self.current_article = article_number
    self.current_group = group_name
    self.header_field = {}
    self.header_field["From"] = ""
    self.header_field["Subject"] = ""
    self.header_field["Newsgroups"] = group_name
    self.header_field["Organization"] = ""
    self.header_field["References"] = ""
    self.header_text = self.news_fetcher.getArticle(article_number,
		"head")
    headers = string.split(self.header_text, "\n")
    for header in headers:
      i = string.find(header, ":")
      if i != -1:
        self.header_field[header[:i]] = header[i+1:]
    article_text = self.news_fetcher.getArticle(article_number,
		"body")
    self.art_window.setArticleBody(article_text)
    self.art_window.setHeaders(self.header_field)







