#
# allgroups.py
#
# Copyright 1995 - Koert Zeilstra
#
# No warranty - use at your own risk
#

import string
import posix
import Tkinter

import searchgroups

#
# AllGroupsDialog
#
#
class AllGroupsDialog(Tkinter.Toplevel):
  def __init__(self, parent, main, app_config, news_fetcher):
    Tkinter.Toplevel.__init__(self, parent)
    self.main = main
    self.app_config = app_config
    self.news_fetcher = news_fetcher
    self.selected_group = None
    self.close_command = None
    self.group_file = "%s/.flashrc/allgroups" % posix.environ["HOME"]
    self.search_dialog = None
    self.title("Newsgroups List")

    frame = Tkinter.Frame(self)
    self.list = Tkinter.Listbox(frame, {"relief": "sunken", "bd": 2,
		"width": 40, "height": 20})
    scrollbar = Tkinter.Scrollbar(frame, {"relief": "sunken",
		"command": self.list.yview})
    self.list["yscrollcommand"] = scrollbar.set
    scrollbar.pack({"side": "right", "fill": "y"})
    self.list.pack({"side": "left", "expand": "yes", "fill": "both"})
    frame.pack({"side": "top", "fill": "both", "expand": "yes"})
    self.list.bind("<ButtonRelease-1>", self._clickList)

    buttons = Tkinter.Frame(self, {"relief": "sunken", "bd": 1})
    self.search_button = Tkinter.Button(buttons, {"text": "Search..",
		"width": 8, "command": self.search})
    self.read_button = Tkinter.Button(buttons, {"text": "Open..",
		"width": 8, "command": self.read})
    self.subscribe_button = Tkinter.Button(buttons, {"text":
		"Subscribe", "width": 8, "command": self.subscribe})
    self.reload_button = Tkinter.Button(buttons, {"text":
		"Reload List", "width": 8, "command": self.reload})
    close_button = Tkinter.Button(buttons, {"text": "Close",
		"width": 8, "command": self.close})
    self.search_button.pack({"side": "left", "fill": "x",
		"pady": 2, "padx": 3})
    #self.read_button.pack({"side": "left", "fill": "x",
	#	"pady": 2, "padx": 3})
    self.subscribe_button.pack({"side": "left", "fill": "x",
		"pady": 2, "padx": 3})
    self.reload_button.pack({"side": "left", "fill": "x",
		"pady": 2, "padx": 3})
    close_button.pack({"side": "right", "fill": "x",
		"pady": 2, "padx": 3})
    buttons.pack({"side": "top", "fill": "x"})

    self.protocol("WM_DELETE_WINDOW", self.close)

  def search (self):
    if self.search_dialog == None:
      self.search_dialog = searchgroups.SearchGroupsDialog(self)
      self.search_dialog.title("Groups Search")
      self.search_dialog.searchCommand(self.doSearch)
      self.search_dialog.selectCommand(self.selectRow)
      self.search_dialog.closeCommand(self.search_dialog.withdraw)
    else:
      self.search_dialog.deiconify()

  def read (self):
    if self.selected_group != None:
      #print self.selected_group
      #{ send $parentapp openGroup $selected_group }
      pass

  def subscribe (self):
    if self.selected_group != None:
      #print self.selected_group
      self.main.addGroup(self.selected_group)

  def reload (self):
    groups = self.news_fetcher.getGroupList()
    groups.sort()
    fp = open(self.group_file, "w")
    for group in groups:
      fp.write("%s\n" % group[0])
    fp.close()
    self.selected_group = None
    self.list.delete(0, "end")
    self.readGroupList()

  def closeCommand (self, func):
    self.close_command = func

  def close (self):
    if self.close_command != None:
      self.close_command()

  def selectRow (self, row):
    self.list.select_clear(0, "end")
    self.list.select_set(row)
    self.list.see(row)
    self.selected_group = self.list.get(row)

  def doSearch (self, search_string):
    groups = self.list.get(0, "end")
    result = []
    row = 0
    for group in groups:
      if string.find(group, search_string) != -1:
        result.append((row, group))
      row = row + 1
    return result

  def readGroupList (self):
    self.selected_group = None
    try:
      fp = open(self.group_file, "r")
      done = 0
      while done == 0:
        line = fp.readline()
        if not line:
          done = 1
        else:
          line = string.strip(line)
          if len(line) > 0:
            self.list.insert("end", line)
    except IOError:
     pass

  def _clickList (self, event):
    index = self.list.nearest(event.y)
    self.selected_group = self.list.get(index)











