#
# about.py
#
# Copyright 1995 - Koert Zeilstra
#
# No warranty - use at your own risk
#

import Tkinter

class AboutDialog(Tkinter.Toplevel):
  def __init__ (self, parent, app_config, config={}):
    Tkinter.Toplevel.__init__ (self, parent, config)
    self.close_command = None
    self.app_config = app_config

    version = app_config.getVersion()
    label1 = Tkinter.Label(self, {"text": "Newsflash", "font": "-*-lucida-bold-i-*-*-24-*-*-*-*-*-*-*"})
    label1.pack({"fill": "x", "side": "top"})
    label2 = Tkinter.Label(self, {"text": "Version %s" % version})
    label2.pack({"fill": "x", "side": "top"})
    label3 = Tkinter.Label(self, {"text": "NNTP Usenet Newsreader"})
    label3.pack({"fill": "x", "side": "top"})
    label4 = Tkinter.Label(self, {"text": "Koert Zeilstra"})
    label4.pack({"fill": "x", "side": "top"})

    frame1 = Tkinter.Frame(self, {"relief": "sunken", "bd": 2, "height": 4})
    frame1.pack({"fill": "x", "side": "top", "pady": 3})

    buttons = Tkinter.Frame(self, {"relief": "sunken", "bd": 2})
    close_button = Tkinter.Button(self, {"text": "Close", "width": 8,
		"command": self.close})
    close_button.pack ({"side": "top", "pady": 2, "padx": 3})
    buttons.pack({"side": "top", "fill": "x"})

  def close (self):
    if self.close_command == None:
      del self
    else:
      self.close_command()

  def closeCommand (self, func):
    self.close_command = func







