#!/usr/local/bin/python
#
# Simple client using RemoteCall interface to make a server do some maths.
#

import sys

def usage():
	print "Usage: %s ('tcp' [host] port) | ('unix' path)" % sys.argv[0]
	sys.exit(-1)

def main():
	import RemoteCall

	if len(sys.argv) == 1 or sys.argv[1] == 'unix':
		RemCall = RemoteCall.UnixStreamRemoteCall
		if len(sys.argv) > 2:
			addr = sys.argv[2]
		else:
			addr = '/tmp/remcall'
	elif sys.argv[1] == 'tcp':
		RemCall = RemoteCall.TCPRemoteCall
		if len(sys.argv) > 3:
			host = sys.argv[2]
			port = eval(sys.argv[3])
			addr = (host, port)
		elif len(sys.argv) == 3:
			host = '127.0.0.1'
			port = eval(sys.argv[2])
			addr = (host, port)
		else:
			host = '127.0.0.1'
			port = 7979
			addr = (host, port)
	else:
		RemCall = RemoteCall.UnixStreamRemoteCall
		addr = sys.argv[1]
        


	print "Do some remote calculations:"
	remcall = RemCall(addr)
	print "Ok, remote call connection established."

	n = 100000
	print "\nLet the server calculate sum(8/((4n+1)(4n+3))), when n =", n


	pi = remcall.Eval("reduce(lambda sum, n: sum+8.0/((4*n+1)*(4*n+3)), range(%d), 0)" % n)
	print "Result =", pi

main()
