from types import *
import RemoteCallServer
import agent_serverdefs

class TestRequestHandler(RemoteCallServer.RemCallHandler):
	def Eval(self, expr):
		# Called by RemoteCallServer.
		# Derived to let remote client use objects
		# in this namespace
		return eval(expr)


class TCPTestServer(RemoteCallServer.TkTCPRemoteCallServer):
#class TestServer(RemoteCallServer.TkUnixStreamRemoteCallServer):
	def __init__(self, addr):
		RemoteCallServer.TkTCPRemoteCallServer.__init__(self, addr, TestRequestHandler)
		self.EnableAgents()

class UnixStreamTestServer(RemoteCallServer.TkUnixStreamRemoteCallServer):
	def __init__(self, addr):
		RemoteCallServer.TkUnixStreamRemoteCallServer.__init__(self, addr, TestRequestHandler)
		self.EnableAgents()


def main():
	import sys
	if len(sys.argv) == 1 or sys.argv[-1] == 'unix':
		import os
		addr = '/tmp/remcall'
		os.unlink(addr)
		server = UnixStreamTestServer(addr)
	else:
		addr = ('', 7979)
		server = TCPTestServer(addr)
	server._VERBOSE = 2 # 1 or 2 for more verbose server

	# Register server in Tkinter dispatcher
	server.add_input()
	server.SendAsAgent(agent_serverdefs.StupidServer)

	print 'OK, waiting on ', addr, '...'

	import Tkinter
	Tkinter.mainloop()

if __name__ == '__main__':
        main()
