#!/usr/local/bin/python


from Agent import Agent
import sys

def usage():
	print "Usage: %s ('tcp' [host] port) | ('unix' path)" % sys.argv[0]
	sys.exit(-1)

def main():
	import RemoteCall

	if len(sys.argv) == 1 or sys.argv[1] == 'unix':
		RemCall = RemoteCall.UnixStreamRemoteCall
		if len(sys.argv) > 2:
			addr = sys.argv[2]
		else:
			addr = '/tmp/remcall'
	elif sys.argv[1] == 'tcp':
		RemCall = RemoteCall.TCPRemoteCall
		if len(sys.argv) > 3:
			host = sys.argv[2]
			port = eval(sys.argv[3])
			addr = (host, port)
		elif len(sys.argv) == 3:
			host = '127.0.0.1'
			port = eval(sys.argv[2])
			addr = (host, port)
		else:
			host = '127.0.0.1'
			port = 7979
			addr = (host, port)
	else:
		RemCall = RemoteCall.UnixStreamRemoteCall
		addr = sys.argv[1]


	print "Create agent for module serverdefs"

	# Here we create an agent for a module!
	agent = Agent('agent_serverdefs', addr)
	print "Ok, agent created and configured"

	print "\nThe following methods are available:"

	dict = agent.__dict__

	for item in dict.keys():
		if hasattr(dict[item], '__class__') and dict[item].__class__ == Agent.Method:
			print ' '*3, item


	print "\nCreate an instance of a server object"
	server = agent.new_server()

	print "\nThe following methods are available:"
	dict = server.__dict__
	for item in dict.keys():
		if hasattr(dict[item], '__class__') and dict[item].__class__ == Agent.Method:
			print ' '*3, item


	def print_attrs(server):
		print "Values of attributes:"
		print "  _a_ =", server._a_
		print "  _b_ =", server._b_

	print
	print_attrs(server)

	print "\nCall server.increase_a()"
	server.increase_a()
	print_attrs(server)

	print "\nCall server.set_b_ix()"
	from Complex import Complex
	item = Complex(3.14, 2.71828)
	server.set_b_ix(3, item)
	print_attrs(server)

	# Raise an exception on server side, and catch it
	print "\nCatching a remote exception:"
	try:
		server.increase_a('This argument is not expected')
	except TypeError:
		print 'Oops, I caught an exception: (%s, %s)' % (sys.exc_type, sys.exc_value)

if __name__ == '__main__':
	main()

